/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.SepaLastschriftNew;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastBuchungNew;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftNew;
import de.willuhn.jameica.hbci.gui.controller.AbstractSepaSammelTransferControl;
import de.willuhn.jameica.hbci.gui.parts.SepaSammelLastschriftList;
import de.willuhn.jameica.hbci.gui.parts.SepaSammelTransferBuchungList;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaSammelLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class SepaSammelLastschriftControl
extends AbstractSepaSammelTransferControl<SepaSammelLastschrift> {
    private SepaSammelLastschrift transfer = null;
    private SepaSammelLastschriftList table = null;
    private TablePart buchungen = null;
    private SelectInput sequenceType = null;
    private SelectInput type = null;
    private DateInput targetDate = null;
    private Input name = null;

    public SepaSammelLastschriftControl(AbstractView view) {
        super(view);
    }

    public Input getSequenceType() throws RemoteException {
        if (this.sequenceType == null) {
            this.sequenceType = new SelectInput((Object[])SepaLastSequenceType.values(), (Object)this.getTransfer().getSequenceType());
            this.sequenceType.setName(i18n.tr("Sequenz-Typ"));
            this.sequenceType.setEnabled(!this.getTransfer().ausgefuehrt());
            this.sequenceType.setMandatory(true);
        }
        return this.sequenceType;
    }

    @Override
    public Input getName() throws RemoteException {
        if (this.name != null) {
            return this.name;
        }
        this.name = super.getName();
        if (StringUtils.trimToNull((String)((String)this.name.getValue())) == null) {
            this.name.setValue((Object)i18n.tr("SEPA-Sammellastschrift vom {0}", HBCI.LONGDATEFORMAT.format(new Date())));
        }
        return this.name;
    }

    public Input getType() throws RemoteException {
        if (this.type == null) {
            this.type = new SelectInput((Object[])SepaLastType.values(), (Object)this.getTransfer().getType());
            this.type.setName(i18n.tr("Lastschrift-Art"));
            this.type.setEnabled(!this.getTransfer().ausgefuehrt());
        }
        return this.type;
    }

    public Input getTargetDate() throws RemoteException {
        if (this.targetDate == null) {
            this.targetDate = new DateInput(this.getTransfer().getTargetDate(), DateUtil.DEFAULT_FORMAT);
            this.targetDate.setName(i18n.tr("Zieltermin"));
            this.targetDate.setEnabled(!this.getTransfer().ausgefuehrt());
            this.targetDate.setMandatory(true);
        }
        return this.targetDate;
    }

    @Override
    public synchronized boolean handleStore() {
        SepaSammelLastschrift t;
        block5: {
            try {
                t = this.getTransfer();
                if (!t.ausgefuehrt()) break block5;
                return true;
            }
            catch (Exception e) {
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                } else {
                    Logger.error((String)"error while saving order", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                return false;
            }
        }
        t.setSequenceType((SepaLastSequenceType)((Object)this.getSequenceType().getValue()));
        t.setType((SepaLastType)((Object)this.getType().getValue()));
        t.setTargetDate((Date)this.getTargetDate().getValue());
        this.store();
        return true;
    }

    @Override
    public SepaSammelLastschrift getTransfer() throws RemoteException {
        if (this.transfer != null) {
            return this.transfer;
        }
        this.transfer = (SepaSammelLastschrift)this.getCurrentObject();
        if (this.transfer != null) {
            return this.transfer;
        }
        this.transfer = (SepaSammelLastschrift)Settings.getDBService().createObject(SepaSammelLastschrift.class, null);
        return this.transfer;
    }

    @Override
    public Class<? extends SynchronizeJob> getSynchronizeJobType() {
        return SynchronizeJobSepaSammelLastschrift.class;
    }

    @Override
    public SepaSammelLastschriftList getListe() throws RemoteException {
        if (this.table != null) {
            return this.table;
        }
        this.table = new SepaSammelLastschriftList(new SepaSammelLastschriftNew());
        return this.table;
    }

    @Override
    public TablePart getBuchungen() throws RemoteException {
        if (this.buchungen != null) {
            return this.buchungen;
        }
        Action a = new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new SepaSammelLastBuchungNew().handleAction(context);
            }
        };
        this.buchungen = new SepaSammelTransferBuchungList(this.getTransfer(), a);
        this.buchungen.setMulti(true);
        ContextMenu ctx = new ContextMenu();
        ctx.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Buchung \u00f6ffnen"), (Action)new SepaSammelLastBuchungNew(), "document-open.png"));
        ctx.addItem((ContextMenuItem)new AbstractSepaSammelTransferControl.DeleteMenuItem());
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new AbstractSepaSammelTransferControl.CreateMenuItem(new SepaSammelLastBuchungNew()));
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("In Einzellastschrift duplizieren"), (Action)new SepaLastschriftNew(), "lastschrift.png"));
        this.buchungen.setContextMenu(ctx);
        return this.buchungen;
    }
}

