/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.action.SepaSammelUeberweisungBuchungNew;
import de.willuhn.jameica.hbci.gui.action.SepaSammelUeberweisungNew;
import de.willuhn.jameica.hbci.gui.controller.AbstractSepaSammelTransferControl;
import de.willuhn.jameica.hbci.gui.input.TerminInput;
import de.willuhn.jameica.hbci.gui.parts.SepaSammelTransferBuchungList;
import de.willuhn.jameica.hbci.gui.parts.SepaSammelUeberweisungList;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaSammelUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SepaSammelUeberweisungControl
extends AbstractSepaSammelTransferControl<SepaSammelUeberweisung> {
    private SepaSammelUeberweisung transfer = null;
    private SepaSammelUeberweisungList table = null;
    private TablePart buchungen = null;
    private SelectInput typ = null;
    private TerminInput termin = null;
    private Listener terminListener = new TerminListener();
    private Input name = null;

    public SepaSammelUeberweisungControl(AbstractView view) {
        super(view);
    }

    @Override
    public Input getName() throws RemoteException {
        if (this.name != null) {
            return this.name;
        }
        this.name = super.getName();
        if (StringUtils.trimToNull((String)((String)this.name.getValue())) == null) {
            this.name.setValue((Object)i18n.tr("SEPA-Sammel\u00fcberweisung vom {0}", HBCI.LONGDATEFORMAT.format(new Date())));
        }
        return this.name;
    }

    public SelectInput getTyp() throws RemoteException {
        if (this.typ != null) {
            return this.typ;
        }
        final SepaSammelUeberweisung u = this.getTransfer();
        ArrayList<Typ> list = new ArrayList<Typ>();
        list.add(new Typ(false));
        list.add(new Typ(true));
        this.typ = new SelectInput(list, (Object)new Typ(u.isTerminUeberweisung()));
        this.typ.setName(i18n.tr("Auftragstyp"));
        this.typ.setAttribute("name");
        this.typ.setEnabled(!u.ausgefuehrt());
        this.typ.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    Typ t = (Typ)SepaSammelUeberweisungControl.this.getTyp().getValue();
                    u.setTerminUeberweisung(t.termin);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to set flag", (Throwable)e);
                }
            }
        });
        this.typ.addListener(this.terminListener);
        this.terminListener.handleEvent(null);
        return this.typ;
    }

    @Override
    public TerminInput getTermin() throws RemoteException {
        if (this.termin != null) {
            return this.termin;
        }
        this.termin = super.getTermin();
        this.termin.setName(String.valueOf(this.termin.getName()) + "  ");
        this.termin.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    if (!SepaSammelUeberweisungControl.this.termin.hasChanged()) {
                        return;
                    }
                    Date date = (Date)SepaSammelUeberweisungControl.this.termin.getValue();
                    if (date == null) {
                        return;
                    }
                    Typ typ = (Typ)SepaSammelUeberweisungControl.this.getTyp().getValue();
                    if (typ == null || typ.termin) {
                        return;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(DateUtil.startOfDay((Date)new Date()));
                    cal.add(5, 6);
                    if (DateUtil.startOfDay((Date)date).after(cal.getTime())) {
                        String q = i18n.tr("Soll der Auftrag als bankseitig gef\u00fchrte SEPA-Sammeltermin\u00fcberweisung ausgef\u00fchrt werden?");
                        if (Application.getCallback().askUser(q)) {
                            SepaSammelUeberweisungControl.this.getTyp().setValue((Object)new Typ(true));
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to check for termsammelueb", (Throwable)e);
                }
            }
        });
        return this.termin;
    }

    @Override
    public SepaSammelUeberweisung getTransfer() throws RemoteException {
        if (this.transfer != null) {
            return this.transfer;
        }
        this.transfer = (SepaSammelUeberweisung)this.getCurrentObject();
        if (this.transfer != null) {
            return this.transfer;
        }
        this.transfer = (SepaSammelUeberweisung)Settings.getDBService().createObject(SepaSammelUeberweisung.class, null);
        return this.transfer;
    }

    @Override
    public SepaSammelUeberweisungList getListe() throws RemoteException {
        if (this.table != null) {
            return this.table;
        }
        this.table = new SepaSammelUeberweisungList(new SepaSammelUeberweisungNew());
        return this.table;
    }

    @Override
    public Class<? extends SynchronizeJob> getSynchronizeJobType() {
        return SynchronizeJobSepaSammelUeberweisung.class;
    }

    @Override
    public TablePart getBuchungen() throws RemoteException {
        if (this.buchungen != null) {
            return this.buchungen;
        }
        Action a = new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new SepaSammelUeberweisungBuchungNew().handleAction(context);
            }
        };
        this.buchungen = new SepaSammelTransferBuchungList(this.getTransfer(), a);
        this.buchungen.setMulti(true);
        ContextMenu ctx = new ContextMenu();
        ctx.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Buchung \u00f6ffnen"), (Action)new SepaSammelUeberweisungBuchungNew(), "document-open.png"));
        ctx.addItem((ContextMenuItem)new AbstractSepaSammelTransferControl.DeleteMenuItem());
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new AbstractSepaSammelTransferControl.CreateMenuItem(new SepaSammelUeberweisungBuchungNew()));
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("In Einzel\u00fcberweisung duplizieren"), (Action)new AuslandsUeberweisungNew(), "ueberweisung.png"));
        this.buchungen.setContextMenu(ctx);
        return this.buchungen;
    }

    @Override
    public synchronized void store() throws Exception {
        SepaSammelUeberweisung t = this.getTransfer();
        if (t.ausgefuehrt()) {
            return;
        }
        Typ typ = (Typ)this.getTyp().getValue();
        t.setTerminUeberweisung(typ.termin);
        super.store();
    }

    private class TerminListener
    implements Listener {
        private TerminListener() {
        }

        public void handleEvent(Event event) {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TerminInput input = SepaSammelUeberweisungControl.this.getTermin();
                        Typ typ = (Typ)SepaSammelUeberweisungControl.this.getTyp().getValue();
                        if (typ != null && typ.termin) {
                            input.setName(i18n.tr("Ausf\u00fchrungstermin"));
                            Date date = (Date)input.getValue();
                            if (date != null && !DateUtil.startOfDay((Date)date).after(DateUtil.startOfDay((Date)new Date()))) {
                                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Ausf\u00fchrungstermin der Sammeltermin\u00fcberweisung liegt in der Vergangenheit"), 2));
                            }
                        } else {
                            input.setName(i18n.tr("Erinnerungstermin"));
                        }
                        input.updateComment();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update label", (Throwable)e);
                    }
                }
            });
        }
    }

    public class Typ {
        private boolean termin = false;

        private Typ(boolean termin) {
            this.termin = termin;
        }

        public String getName() {
            if (this.termin) {
                return i18n.tr("Bankseitige SEPA-Sammeltermin\u00fcberweisung");
            }
            return i18n.tr("SEPA-Sammel\u00fcberweisung");
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Typ)) {
                return false;
            }
            Typ other = (Typ)o;
            return other.termin == this.termin;
        }
    }
}

