/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.ColorInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.experiments.Feature;
import de.willuhn.jameica.hbci.experiments.FeatureService;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.gui.action.UmsatzTypNew;
import de.willuhn.jameica.hbci.gui.parts.RangeList;
import de.willuhn.jameica.hbci.gui.parts.UmsatzTypTree;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SettingsControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private CheckboxInput cachePin = null;
    private CheckboxInput storePin = null;
    private CheckboxInput decimalGrouping = null;
    private CheckboxInput kontoCheck = null;
    private CheckboxInput excludeAddresses = null;
    private Input buchungSollFg = null;
    private Input buchungHabenFg = null;
    private CheckboxInput boldValues = null;
    private CheckboxInput colorValues = null;
    private UmsatzTypTree umsatzTypTree = null;
    private Map<Range.Category, RangeList> ranges = new HashMap<Range.Category, RangeList>();
    private Input ueberweisungLimit = null;
    private CheckboxInput exFeatures = null;
    private List<CheckboxInput> experiments = null;
    private Input serverURL = null;
    private Input userName = null;
    private Input password = null;
    private Input bezirksID = null;
    private Input buchungsJahr = null;

    public SettingsControl(AbstractView view) {
        super(view);
    }

    public UmsatzTypTree getUmsatzTypTree() throws RemoteException {
        if (this.umsatzTypTree == null) {
            this.umsatzTypTree = new UmsatzTypTree(new UmsatzTypNew());
        }
        return this.umsatzTypTree;
    }

    public RangeList getRanges(Range.Category category) throws RemoteException {
        RangeList list = this.ranges.get((Object)category);
        if (list != null) {
            return list;
        }
        list = new RangeList(category);
        this.ranges.put(category, list);
        return list;
    }

    public CheckboxInput getDecimalGrouping() {
        if (this.decimalGrouping == null) {
            this.decimalGrouping = new CheckboxInput(Settings.getDecimalGrouping());
        }
        return this.decimalGrouping;
    }

    public CheckboxInput getBoldValues() {
        if (this.boldValues == null) {
            this.boldValues = new CheckboxInput(Settings.getBoldValues());
        }
        return this.boldValues;
    }

    public CheckboxInput getColorValues() {
        if (this.colorValues == null) {
            this.colorValues = new CheckboxInput(Settings.getColorValues());
            this.colorValues.setComment(i18n.tr("Deaktivieren, um die ganze Zeile farbig anzuzeigen"));
        }
        return this.colorValues;
    }

    public CheckboxInput getKontoCheck() {
        if (this.kontoCheck == null) {
            this.kontoCheck = new CheckboxInput(Settings.getKontoCheck());
            Listener l = new Listener(){

                public void handleEvent(Event event) {
                    SettingsControl.this.getKontoCheckExcludeAddressbook().setEnabled(((Boolean)SettingsControl.this.kontoCheck.getValue()).booleanValue());
                }
            };
            this.kontoCheck.addListener(l);
            l.handleEvent(null);
        }
        return this.kontoCheck;
    }

    public CheckboxInput getKontoCheckExcludeAddressbook() {
        if (this.excludeAddresses == null) {
            this.excludeAddresses = new CheckboxInput(Settings.getKontoCheckExcludeAddressbook());
        }
        return this.excludeAddresses;
    }

    public CheckboxInput getCachePin() {
        if (this.cachePin != null) {
            return this.cachePin;
        }
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                boolean b1 = (Boolean)SettingsControl.this.getCachePin().getValue();
                boolean b2 = Application.getStartupParams().getPassword() == null;
                SettingsControl.this.getStorePin().setEnabled(b1 && b2);
                if (!b2) {
                    SettingsControl.this.getStorePin().setComment(i18n.tr("Deaktiviert. Master-Passwort nicht manuell eingegeben"));
                }
            }
        };
        this.cachePin = new CheckboxInput(Settings.getCachePin());
        this.cachePin.addListener(l);
        l.handleEvent(null);
        return this.cachePin;
    }

    public CheckboxInput getStorePin() {
        if (this.storePin != null) {
            return this.storePin;
        }
        this.storePin = new CheckboxInput(Settings.getStorePin());
        this.storePin.setComment("");
        this.storePin.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (event.type != 13) {
                    return;
                }
                boolean enabled = (Boolean)SettingsControl.this.storePin.getValue();
                if (enabled) {
                    boolean b = false;
                    try {
                        YesNoDialog d = new YesNoDialog(1);
                        d.setTitle(i18n.tr("Warnung"));
                        d.setSideImage(SWTUtil.getImage((String)"dialog-warning-large.png"));
                        d.setText(i18n.tr("Mit der permanenten Speicherung der PIN versto\u00dfen Sie unter Umst\u00e4nden\ngegen die Onlinebanking-AGB Ihres Geldinstitutes. Bitte wenden Sie sich\nan Ihre Bank und fragen Sie diese, ob das Speichern der PIN zul\u00e4ssig ist.\n\nPIN-Speicherung wirklich aktivieren?"));
                        b = (Boolean)d.open();
                    }
                    catch (OperationCanceledException d) {
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to open dialog", (Throwable)e);
                    }
                    SettingsControl.this.getStorePin().setValue((Object)b);
                }
            }
        });
        return this.storePin;
    }

    public CheckboxInput getExFeatures() {
        if (this.exFeatures != null) {
            return this.exFeatures;
        }
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        FeatureService fs = (FeatureService)bs.get(FeatureService.class);
        this.exFeatures = new CheckboxInput(fs.enabled());
        this.exFeatures.setName(i18n.tr("Experimentelle Funktionen aktivieren"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                boolean enabled = (Boolean)SettingsControl.this.getExFeatures().getValue();
                for (CheckboxInput c : SettingsControl.this.getExperiments()) {
                    c.setEnabled(enabled);
                }
            }
        };
        this.exFeatures.addListener(l);
        l.handleEvent(null);
        return this.exFeatures;
    }

    public List<CheckboxInput> getExperiments() {
        if (this.experiments != null) {
            return this.experiments;
        }
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        FeatureService fs = (FeatureService)bs.get(FeatureService.class);
        this.experiments = new ArrayList<CheckboxInput>();
        for (Feature f : fs.getFeatures()) {
            CheckboxInput c = new CheckboxInput(fs.isEnabled(f));
            c.setData("feature", (Object)f);
            c.setData("description", (Object)(String.valueOf(f.getDescription()) + "\n\n" + i18n.tr("Vorgabewert: {0}", i18n.tr(f.getDefault() ? "aktiviert" : "deaktiviert"))));
            c.setName(f.getName());
            this.experiments.add(c);
        }
        return this.experiments;
    }

    public Input getUeberweisungLimit() {
        if (this.ueberweisungLimit == null) {
            this.ueberweisungLimit = new DecimalInput(Settings.getUeberweisungLimit(), HBCI.DECIMALFORMAT);
            this.ueberweisungLimit.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        }
        return this.ueberweisungLimit;
    }

    public Input getServerURL() {
        if (this.serverURL == null) {
            this.serverURL = new TextInput(Settings.getServerURL());
        }
        return this.serverURL;
    }

    public Input getUserName() {
        if (this.userName == null) {
            this.userName = new TextInput(Settings.getUserName());
        }
        return this.userName;
    }

    public Input getPassword() {
        if (this.password == null) {
            this.password = new TextInput(Settings.getPassword());
        }
        return this.password;
    }

    public Input getBezirksID() {
        if (this.bezirksID == null) {
            this.bezirksID = new TextInput(Settings.getBezirksID());
        }
        return this.bezirksID;
    }

    public Input getBuchungsJahr() {
        if (this.buchungsJahr == null) {
            this.buchungsJahr = new TextInput(Settings.getBuchungsJahr());
        }
        return this.buchungsJahr;
    }

    public Input getBuchungSollForeground() {
        if (this.buchungSollFg == null) {
            this.buchungSollFg = new ColorInput(Settings.getBuchungSollForeground(), true);
        }
        return this.buchungSollFg;
    }

    public Input getBuchungHabenForeground() {
        if (this.buchungHabenFg == null) {
            this.buchungHabenFg = new ColorInput(Settings.getBuchungHabenForeground(), true);
        }
        return this.buchungHabenFg;
    }

    public void handleStore() {
        Double limit;
        boolean haveError = false;
        Color hf = (Color)this.getBuchungHabenForeground().getValue();
        Color sf = (Color)this.getBuchungSollForeground().getValue();
        Settings.setBuchungHabenForeground(hf.getRGB());
        Settings.setBuchungSollForeground(sf.getRGB());
        Settings.setDecimalGrouping((Boolean)this.getDecimalGrouping().getValue());
        Settings.setBoldValues((Boolean)this.getBoldValues().getValue());
        Settings.setColorValues((Boolean)this.getColorValues().getValue());
        Settings.setKontoCheck((Boolean)this.getKontoCheck().getValue());
        Settings.setKontoCheckExcludeAddressbook((Boolean)this.getKontoCheckExcludeAddressbook().getValue());
        boolean storeEnabled = (Boolean)this.getStorePin().getValue();
        boolean cacheEnabled = (Boolean)this.getCachePin().getValue();
        Settings.setCachePin(cacheEnabled);
        Settings.setStorePin(storeEnabled);
        if (!cacheEnabled) {
            DialogFactory.clearPINCache(null);
        }
        if (!storeEnabled) {
            DialogFactory.clearPINStore(null);
        }
        Settings.setUeberweisungLimit((limit = (Double)this.getUeberweisungLimit().getValue()) == null ? 0.0 : limit);
        Settings.setServerURL((String)this.getServerURL().getValue());
        Settings.setUserName((String)this.getUserName().getValue());
        Settings.setPassword((String)this.getPassword().getValue());
        Settings.setBezirksID((String)this.getBezirksID().getValue());
        Settings.setBuchungsJahr((String)this.getBuchungsJahr().getValue());
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        FeatureService fs = (FeatureService)bs.get(FeatureService.class);
        boolean ex = (Boolean)this.getExFeatures().getValue();
        boolean changed = ex ^ fs.enabled();
        fs.setEnabled(ex);
        if (ex) {
            try {
                for (CheckboxInput checkboxInput : this.getExperiments()) {
                    Feature f = (Feature)checkboxInput.getData("feature");
                    fs.setEnabled(f, (Boolean)checkboxInput.getValue());
                }
            }
            catch (Exception exception) {
                Logger.error((String)"unable to store feature", (Throwable)exception);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Speichern der experimentellen Features fehlgeschlagen"), 1));
                haveError = true;
            }
        }
        for (Map.Entry entry : this.ranges.entrySet()) {
            try {
                Range.Category cat = (Range.Category)((Object)entry.getKey());
                RangeList table = (RangeList)((Object)entry.getValue());
                Range.setActiveRanges(cat, table.getItems(true));
            }
            catch (Exception e) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Speichern der Zeitr\u00e4ume fehlgeschlagen"), 1));
                haveError = true;
            }
        }
        if (changed) {
            try {
                GUI.getCurrentView().reload();
            }
            catch (Exception exception) {
                Logger.error((String)"unable to reload view", (Throwable)exception);
            }
        }
        if (!haveError) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Einstellungen gespeichert."), 0));
        }
    }
}

