/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.TextSchluessel;
import de.willuhn.jameica.hbci.gui.action.UeberweisungNew;
import de.willuhn.jameica.hbci.gui.controller.AbstractBaseUeberweisungControl;
import de.willuhn.jameica.hbci.gui.input.TerminInput;
import de.willuhn.jameica.hbci.gui.parts.UeberweisungList;
import de.willuhn.jameica.hbci.rmi.BaseUeberweisung;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.rmi.Ueberweisung;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UeberweisungControl
extends AbstractBaseUeberweisungControl {
    private UeberweisungList table = null;
    private Ueberweisung transfer = null;
    private SelectInput typ = null;
    private SelectInput textschluessel = null;
    private TerminInput termin = null;

    public UeberweisungControl(AbstractView view) {
        super(view);
    }

    @Override
    public HibiscusTransfer getTransfer() throws RemoteException {
        if (this.transfer != null) {
            return this.transfer;
        }
        this.transfer = (Ueberweisung)this.getCurrentObject();
        if (this.transfer != null) {
            return this.transfer;
        }
        this.transfer = (Ueberweisung)Settings.getDBService().createObject(Ueberweisung.class, null);
        return this.transfer;
    }

    public SelectInput getTyp() throws RemoteException {
        if (this.typ != null) {
            return this.typ;
        }
        final Ueberweisung u = (Ueberweisung)this.getTransfer();
        ArrayList<Typ> list = new ArrayList<Typ>();
        list.add(new Typ(false, false));
        list.add(new Typ(true, false));
        list.add(new Typ(false, true));
        this.typ = new SelectInput(list, (Object)new Typ(u.isTerminUeberweisung(), u.isUmbuchung()));
        this.typ.setName(i18n.tr("Auftragstyp"));
        this.typ.setAttribute("name");
        this.typ.setEnabled(!u.ausgefuehrt());
        this.typ.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    Typ t = (Typ)UeberweisungControl.this.getTyp().getValue();
                    u.setTerminUeberweisung(t.termin);
                    UeberweisungControl.this.getTermin().updateComment();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to set flag", (Throwable)e);
                }
            }
        });
        return this.typ;
    }

    @Override
    public TerminInput getTermin() throws RemoteException {
        if (this.termin != null) {
            return this.termin;
        }
        this.termin = super.getTermin();
        this.termin.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    if (!UeberweisungControl.this.termin.hasChanged()) {
                        return;
                    }
                    Date date = (Date)UeberweisungControl.this.termin.getValue();
                    if (date == null) {
                        return;
                    }
                    Typ typ = (Typ)UeberweisungControl.this.getTyp().getValue();
                    if (typ == null || typ.termin) {
                        return;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(DateUtil.startOfDay((Date)new Date()));
                    cal.add(5, 6);
                    if (DateUtil.startOfDay((Date)date).after(cal.getTime())) {
                        String q = i18n.tr("Soll der Auftrag als bankseitig gef\u00fchrte Termin-\u00dcberweisung ausgef\u00fchrt werden?");
                        if (Application.getCallback().askUser(q)) {
                            UeberweisungControl.this.getTyp().setValue((Object)new Typ(true, false));
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to check for termueb", (Throwable)e);
                }
            }
        });
        return this.termin;
    }

    public UeberweisungList getUeberweisungListe() throws RemoteException {
        if (this.table != null) {
            return this.table;
        }
        this.table = new UeberweisungList(new UeberweisungNew());
        return this.table;
    }

    @Override
    public Input getTextSchluessel() throws RemoteException {
        if (this.textschluessel != null) {
            return this.textschluessel;
        }
        String current = ((BaseUeberweisung)this.getTransfer()).getTextSchluessel();
        this.textschluessel = new SelectInput((Object[])TextSchluessel.get(TextSchluessel.SET_UEB), (Object)TextSchluessel.get(current));
        this.textschluessel.setName(i18n.tr("Textschl\u00fcssel"));
        this.textschluessel.setEnabled(!((Terminable)((Object)this.getTransfer())).ausgefuehrt());
        this.updateZweck(current);
        if (this.textschluessel.isEnabled()) {
            this.textschluessel.addListener(new Listener(){

                public void handleEvent(Event event) {
                    TextSchluessel s = (TextSchluessel)UeberweisungControl.this.textschluessel.getValue();
                    UeberweisungControl.this.updateZweck(s != null ? s.getCode() : null);
                }
            });
        }
        return this.textschluessel;
    }

    private void updateZweck(String code) {
        try {
            TextInput zweck = this.getZweck();
            if (code != null && code.equals("67")) {
                zweck.setName(i18n.tr("BZ\u00dc-Pr\u00fcfziffer"));
                zweck.setMaxLength(HBCIProperties.HBCI_TRANSFER_BZU_LENGTH);
                zweck.setValidChars(HBCIProperties.HBCI_BZU_VALIDCHARS);
            } else if (code == null || !code.equals("69")) {
                zweck.setName(i18n.tr("Verwendungszweck"));
                zweck.setMaxLength(HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
                zweck.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to apply changes", (Throwable)e);
        }
    }

    @Override
    public synchronized boolean handleStore() {
        Ueberweisung u;
        block3: {
            try {
                u = (Ueberweisung)this.getTransfer();
                if (!u.ausgefuehrt()) break block3;
                return true;
            }
            catch (RemoteException re) {
                Logger.error((String)"error while storing ueberweisung", (Throwable)re);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Speichern der \u00dcberweisung"));
                return false;
            }
        }
        Typ t = (Typ)this.getTyp().getValue();
        u.setTerminUeberweisung(t.termin);
        u.setUmbuchung(t.umb);
        return super.handleStore();
    }

    public class Typ {
        private boolean termin = false;
        private boolean umb = false;

        private Typ(boolean termin, boolean umb) {
            this.termin = termin;
            this.umb = umb;
        }

        public String getName() {
            if (this.termin) {
                return i18n.tr("Termin-\u00dcberweisung");
            }
            if (this.umb) {
                return i18n.tr("Interne Umbuchung (\u00dcbertrag)");
            }
            return i18n.tr("\u00dcberweisung");
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Typ)) {
                return false;
            }
            Typ other = (Typ)o;
            return other.termin == this.termin && other.umb == this.umb;
        }
    }
}

