/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.BICInput;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.gui.input.IBANInput;
import de.willuhn.jameica.hbci.gui.input.UmsatzTypInput;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.Addressbook;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UmsatzDetailControl
extends AbstractControl {
    private static de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Umsatz umsatz = null;
    private Input konto = null;
    private Input empfaengerName = null;
    private Input empfaengerName2 = null;
    private Input empfaengerKonto = null;
    private Input empfaengerBlz = null;
    private Input datum = null;
    private Input valuta = null;
    private Input zweck = null;
    private LabelInput betrag = null;
    private LabelInput saldo = null;
    private Input primanota = null;
    private Input art = null;
    private Input customerRef = null;
    private TextInput endToEndId = null;
    private TextInput mandateId = null;
    private TextInput gvcode = null;
    private TextInput creditorId = null;
    private Input kommentar = null;
    private SelectInput umsatzTyp = null;
    private CheckboxInput zweckSwitch = null;

    public UmsatzDetailControl(AbstractView view) {
        super(view);
    }

    public Umsatz getUmsatz() {
        if (this.umsatz != null) {
            return this.umsatz;
        }
        this.umsatz = (Umsatz)this.getCurrentObject();
        return this.umsatz;
    }

    public Input getKommentar() throws RemoteException {
        if (this.kommentar != null) {
            return this.kommentar;
        }
        this.kommentar = new TextAreaInput(this.getUmsatz().getKommentar());
        this.kommentar.setEnabled(!this.getUmsatz().hasFlag(2));
        return this.kommentar;
    }

    public Address getAddressbookEntry() throws RemoteException {
        try {
            Umsatz u = this.getUmsatz();
            HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
            Addressbook ab = (Addressbook)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
            e.setBlz(u.getGegenkontoBLZ());
            e.setKontonummer(u.getGegenkontoNummer());
            e.setName(u.getGegenkontoName());
            return ab.contains(e);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.error((String)"unable to check, if address in addressbook", (Throwable)e);
            return null;
        }
    }

    public Input getKonto() throws RemoteException {
        if (this.konto != null) {
            return this.konto;
        }
        Konto k = this.getUmsatz().getKonto();
        this.konto = new LabelInput(k.getKontonummer());
        this.konto.setComment(HBCIProperties.getNameForBank(k.getBLZ()));
        return this.konto;
    }

    public Input getEmpfaengerName() throws RemoteException {
        if (this.empfaengerName == null) {
            this.empfaengerName = new AddressInput(this.getUmsatz().getGegenkontoName());
            this.empfaengerName.setEnabled(false);
        }
        return this.empfaengerName;
    }

    public Input getEmpfaengerName2() throws RemoteException {
        if (this.empfaengerName2 == null) {
            this.empfaengerName2 = new TextInput(this.getUmsatz().getGegenkontoName2());
            this.empfaengerName2.setName(i18n.tr("Name 2"));
            this.empfaengerName2.setEnabled(false);
        }
        return this.empfaengerName2;
    }

    public SelectInput getUmsatzTyp() throws RemoteException {
        UmsatzTyp ut;
        if (this.umsatzTyp != null) {
            return this.umsatzTyp;
        }
        int typ = 2;
        Umsatz u = this.getUmsatz();
        UmsatzTyp umsatzTyp = ut = u != null ? u.getUmsatzTyp() : null;
        if (u != null && ut == null && u.getBetrag() != 0.0) {
            typ = u.getBetrag() > 0.0 ? 1 : 0;
        }
        this.umsatzTyp = new UmsatzTypInput(ut, typ, false);
        this.umsatzTyp.setComment("");
        this.umsatzTyp.setEnabled(!u.hasFlag(2));
        return this.umsatzTyp;
    }

    public Input getEmpfaengerKonto() throws RemoteException {
        if (this.empfaengerKonto != null) {
            return this.empfaengerKonto;
        }
        String s = this.getUmsatz().getGegenkontoNummer();
        if (StringUtils.trimToEmpty((String)s).length() > 10) {
            this.empfaengerKonto = new IBANInput(s, null);
            this.empfaengerKonto.setName(i18n.tr("IBAN"));
        } else {
            this.empfaengerKonto = new TextInput(s, HBCIProperties.HBCI_IBAN_MAXLENGTH);
            this.empfaengerKonto.setName(i18n.tr("Konto/IBAN"));
        }
        this.empfaengerKonto.setEnabled(false);
        return this.empfaengerKonto;
    }

    public Input getEmpfaengerBLZ() throws RemoteException {
        if (this.empfaengerBlz != null) {
            return this.empfaengerBlz;
        }
        String value = this.getUmsatz().getGegenkontoBLZ();
        boolean isBic = value == null || value.trim().length() == 0;
        try {
            HBCIProperties.checkChars(value, HBCIProperties.HBCI_BLZ_VALIDCHARS);
            isBic = false;
        }
        catch (Exception e) {
            isBic = true;
        }
        this.empfaengerBlz = isBic ? new BICInput(value) : new BLZInput(value);
        this.empfaengerBlz.setName(i18n.tr(isBic ? "BIC" : "BLZ"));
        this.empfaengerBlz.setEnabled(false);
        return this.empfaengerBlz;
    }

    public Input getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        double s = this.getUmsatz().getBetrag();
        this.betrag = new LabelInput(HBCI.DECIMALFORMAT.format(s));
        this.betrag.setComment(this.getUmsatz().getKonto().getWaehrung());
        this.betrag.setColor(ColorUtil.getColor(s, Color.ERROR, Color.SUCCESS, Color.FOREGROUND));
        return this.betrag;
    }

    public Input getDatum() throws RemoteException {
        if (this.datum == null) {
            this.datum = new DateInput(this.getUmsatz().getDatum(), HBCI.DATEFORMAT);
            this.datum.setEnabled(false);
        }
        return this.datum;
    }

    public Input getValuta() throws RemoteException {
        if (this.valuta == null) {
            this.valuta = new DateInput(this.getUmsatz().getValuta(), HBCI.DATEFORMAT);
            this.valuta.setEnabled(false);
        }
        return this.valuta;
    }

    public Input getSaldo() throws RemoteException {
        if (this.saldo != null) {
            return this.saldo;
        }
        double s = this.getUmsatz().getSaldo();
        this.saldo = new LabelInput(HBCI.DECIMALFORMAT.format(s));
        this.saldo.setComment(this.getUmsatz().getKonto().getWaehrung());
        this.saldo.setColor(ColorUtil.getColor(s, Color.ERROR, Color.SUCCESS, Color.FOREGROUND));
        return this.saldo;
    }

    public Input getPrimanota() throws RemoteException {
        if (this.primanota == null) {
            this.primanota = new TextInput(this.getUmsatz().getPrimanota());
            this.primanota.setEnabled(false);
        }
        return this.primanota;
    }

    public Input getArt() throws RemoteException {
        if (this.art == null) {
            this.art = new TextInput(this.getUmsatz().getArt(), 500);
            this.art.setEnabled(false);
        }
        return this.art;
    }

    public Input getCustomerRef() throws RemoteException {
        if (this.customerRef == null) {
            this.customerRef = new TextInput(this.getUmsatz().getCustomerRef());
            this.customerRef.setEnabled(false);
        }
        return this.customerRef;
    }

    public Input getEndToEndId() throws RemoteException {
        if (this.endToEndId == null) {
            String eref = StringUtils.trimToNull((String)this.getUmsatz().getEndToEndId());
            if (eref == null) {
                eref = VerwendungszweckUtil.getTag(this.getUmsatz(), VerwendungszweckUtil.Tag.EREF);
            }
            this.endToEndId = new TextInput(eref, HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            this.endToEndId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
            this.endToEndId.setName(i18n.tr("End-to-End ID"));
            this.endToEndId.setEnabled(false);
        }
        return this.endToEndId;
    }

    public Input getMandateId() throws RemoteException {
        if (this.mandateId == null) {
            String mref = StringUtils.trimToNull((String)this.getUmsatz().getMandateId());
            if (mref == null) {
                mref = VerwendungszweckUtil.getTag(this.getUmsatz(), VerwendungszweckUtil.Tag.MREF);
            }
            this.mandateId = new TextInput(mref, HBCIProperties.HBCI_SEPA_MANDATEID_MAXLENGTH);
            this.mandateId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
            this.mandateId.setEnabled(false);
        }
        return this.mandateId;
    }

    public Input getCreditorId() throws RemoteException {
        if (this.creditorId == null) {
            String credId = StringUtils.trimToNull((String)this.getUmsatz().getCreditorId());
            if (credId == null) {
                credId = VerwendungszweckUtil.getTag(this.getUmsatz(), VerwendungszweckUtil.Tag.CRED);
            }
            this.creditorId = new TextInput(credId, HBCIProperties.HBCI_SEPA_CREDITORID_MAXLENGTH);
            this.creditorId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
            this.creditorId.setName(i18n.tr("Gl\u00e4ubiger ID"));
            this.creditorId.setEnabled(false);
        }
        return this.creditorId;
    }

    public Input getGvCode() throws RemoteException {
        if (this.gvcode == null) {
            String gv = this.getUmsatz().getGvCode();
            String add = this.getUmsatz().getAddKey();
            if (gv == null) {
                gv = "";
            }
            if (add != null && add.length() > 0) {
                gv = String.valueOf(gv) + "/" + add;
            }
            this.gvcode = new TextInput(gv, 7);
            this.gvcode.setValidChars("01234567890/");
            this.gvcode.setEnabled(false);
        }
        return this.gvcode;
    }

    public Input getZweck() {
        if (this.zweck != null) {
            return this.zweck;
        }
        this.zweck = new TextAreaInput("");
        this.zweck.setEnabled(false);
        return this.zweck;
    }

    public CheckboxInput getZweckSwitch() throws RemoteException {
        if (this.zweckSwitch != null) {
            return this.zweckSwitch;
        }
        boolean b = settings.getBoolean("usage.display.all", true);
        this.zweckSwitch = new CheckboxInput(b);
        this.zweckSwitch.setName(i18n.tr("Alle Daten des Verwendungszwecks anzeigen"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                boolean b2 = (Boolean)UmsatzDetailControl.this.zweckSwitch.getValue();
                settings.setAttribute("usage.display.all", b2);
                String usage = UmsatzDetailControl.this.getUsage(b2);
                UmsatzDetailControl.this.getZweck().setValue((Object)usage);
            }
        };
        this.zweckSwitch.addListener(l);
        l.handleEvent(null);
        return this.zweckSwitch;
    }

    protected String getUsage(boolean showAll) {
        try {
            Umsatz u = this.getUmsatz();
            if (showAll) {
                return VerwendungszweckUtil.toString(u);
            }
            return (String)u.getAttribute(VerwendungszweckUtil.Tag.SVWZ.name());
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to display usage text", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anzeigen des Verwendungszweck: {0}", re.getMessage()), 1));
            return "";
        }
    }

    public boolean handleStore() {
        Umsatz u = this.getUmsatz();
        try {
            u.setKommentar((String)this.getKommentar().getValue());
            u.setUmsatzTyp((UmsatzTyp)this.getUmsatzTyp().getValue());
            this.getUmsatz().store();
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Umsatz gespeichert"), 0));
            return true;
        }
        catch (ApplicationException e2) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e2.getMessage(), 1));
        }
        catch (RemoteException e) {
            Logger.error((String)"error while storing umsatz", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Speichern des Umsatzes: {0}", e.getMessage()), 1));
        }
        return false;
    }
}

