/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetailEdit;
import de.willuhn.jameica.hbci.gui.controller.UmsatzDetailControl;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.InputCompat;
import de.willuhn.jameica.hbci.messaging.SaldoMessage;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UmsatzDetailEditControl
extends UmsatzDetailControl {
    private Input zweck = null;
    private Input betrag = null;
    private Input saldo = null;

    public UmsatzDetailEditControl(AbstractView view) {
        super(view);
    }

    @Override
    public Input getEmpfaengerName() throws RemoteException {
        Input input = super.getEmpfaengerName();
        if (!input.isEnabled()) {
            input.setEnabled(true);
            input.addListener((Listener)new EmpfaengerListener());
        }
        return input;
    }

    @Override
    public Input getEmpfaengerName2() throws RemoteException {
        Input input = super.getEmpfaengerName2();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getEmpfaengerKonto() throws RemoteException {
        Input input = super.getEmpfaengerKonto();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getEmpfaengerBLZ() throws RemoteException {
        Input input = super.getEmpfaengerBLZ();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        this.betrag = new DecimalInput(this.getUmsatz().getBetrag(), HBCI.DECIMALFORMAT);
        this.betrag.setMandatory(true);
        final Konto konto = this.getUmsatz().getKonto();
        this.betrag.setComment(konto == null ? "" : konto.getWaehrung());
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                try {
                    Double value = (Double)UmsatzDetailEditControl.this.betrag.getValue();
                    if (value == null) {
                        return;
                    }
                    if (konto.hasFlag(2) && UmsatzDetailEditControl.this.getUmsatz().isNewObject()) {
                        UmsatzDetailEditControl.this.getSaldo().setValue((Object)(konto.getSaldo() + value));
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to autoformat value", (Throwable)e);
                }
            }
        };
        this.betrag.addListener(l);
        l.handleEvent(null);
        return this.betrag;
    }

    @Override
    public Input getSaldo() throws RemoteException {
        if (this.saldo == null) {
            this.saldo = new DecimalInput(this.getUmsatz().getSaldo(), HBCI.DECIMALFORMAT);
            this.saldo.setMandatory(true);
            Konto konto = this.getUmsatz().getKonto();
            if (konto.hasFlag(2) && this.getUmsatz().isNewObject()) {
                this.saldo.setValue((Object)konto.getSaldo());
            }
            this.saldo.setComment(konto == null ? "" : konto.getWaehrung());
        }
        return this.saldo;
    }

    @Override
    public Input getZweck() {
        if (this.zweck != null) {
            return this.zweck;
        }
        this.zweck = new TextAreaInput("");
        return this.zweck;
    }

    @Override
    public Input getDatum() throws RemoteException {
        Input input = super.getDatum();
        if (!input.isEnabled()) {
            input.setMandatory(true);
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getValuta() throws RemoteException {
        Input input = super.getValuta();
        if (!input.isEnabled()) {
            input.setMandatory(false);
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getPrimanota() throws RemoteException {
        Input input = super.getPrimanota();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getArt() throws RemoteException {
        Input input = super.getArt();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getCustomerRef() throws RemoteException {
        Input input = super.getCustomerRef();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getEndToEndId() throws RemoteException {
        Input input = super.getEndToEndId();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getMandateId() throws RemoteException {
        Input input = super.getMandateId();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getCreditorId() throws RemoteException {
        Input input = super.getCreditorId();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public Input getGvCode() throws RemoteException {
        Input input = super.getGvCode();
        if (!input.isEnabled()) {
            input.setEnabled(true);
        }
        return input;
    }

    @Override
    public CheckboxInput getZweckSwitch() throws RemoteException {
        CheckboxInput input = super.getZweckSwitch();
        input.setEnabled(false);
        return input;
    }

    @Override
    protected String getUsage(boolean showAll) {
        try {
            Umsatz u = this.getUmsatz();
            if (showAll) {
                return VerwendungszweckUtil.toString(u, "\n");
            }
            String usage = (String)BeanUtil.get((Object)u, (String)VerwendungszweckUtil.Tag.SVWZ.name());
            int limit = HBCIProperties.HBCI_TRANSFER_USAGE_DB_MAXLENGTH;
            if (usage == null || usage.length() <= limit) {
                return usage;
            }
            return VerwendungszweckUtil.merge(VerwendungszweckUtil.rewrap(limit, usage));
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to display usage text", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anzeigen des Verwendungszweck: {0}", re.getMessage()), 1));
            return "";
        }
    }

    @Override
    public boolean handleStore() {
        Umsatz u = this.getUmsatz();
        try {
            String[] values;
            u.transactionBegin();
            u.setKommentar((String)this.getKommentar().getValue());
            u.setUmsatzTyp((UmsatzTyp)this.getUmsatzTyp().getValue());
            u.setGegenkontoName(((AddressInput)this.getEmpfaengerName()).getText());
            u.setGegenkontoName2((String)this.getEmpfaengerName2().getValue());
            u.setGegenkontoNummer((String)this.getEmpfaengerKonto().getValue());
            u.setGegenkontoBLZ((String)this.getEmpfaengerBLZ().getValue());
            u.setZweck((String)this.getZweck().getValue());
            u.setArt((String)this.getArt().getValue());
            Double betrag = (Double)this.getBetrag().getValue();
            u.setBetrag(betrag != null ? betrag : 0.0);
            Double su = (Double)this.getSaldo().getValue();
            u.setSaldo(su);
            Konto k = u.getKonto();
            if (k.hasFlag(2) && u.isNewObject()) {
                k.setSaldo(su);
                k.store();
                Application.getMessagingFactory().sendMessage((Message)new SaldoMessage((GenericObject)k));
            }
            u.setCustomerRef((String)this.getCustomerRef().getValue());
            u.setPrimanota((String)this.getPrimanota().getValue());
            u.setEndToEndId((String)this.getEndToEndId().getValue());
            u.setMandateId((String)this.getMandateId().getValue());
            u.setCreditorId((String)this.getCreditorId().getValue());
            Date valuta = (Date)this.getValuta().getValue();
            Date datum = (Date)this.getDatum().getValue();
            if (valuta == null) {
                valuta = datum;
                this.getValuta().setValue((Object)valuta);
            }
            if (datum == null) {
                datum = valuta;
                this.getDatum().setValue((Object)datum);
            }
            u.setValuta(valuta);
            u.setDatum(datum);
            String gvcode = (String)this.getGvCode().getValue();
            String add = null;
            if (gvcode != null && gvcode.indexOf(47) != -1 && (values = gvcode.split("/")) != null && values.length > 0) {
                gvcode = values[0];
                if (values.length > 1) {
                    add = values[1];
                }
            }
            u.setGvCode(gvcode);
            u.setAddKey(add);
            String z = (String)this.getZweck().getValue();
            u.setZweck(null);
            u.setZweck2(null);
            u.setWeitereVerwendungszwecke(null);
            String[] lines = VerwendungszweckUtil.split(z);
            VerwendungszweckUtil.apply(u, lines);
            u.store();
            if (InputCompat.valueHasChanged(this.getEmpfaengerBLZ(), this.getEmpfaengerKonto(), this.getEmpfaengerName(), this.getEmpfaengerName2(), this.getZweck(), this.getBetrag(), this.getSaldo(), this.getDatum(), this.getValuta(), this.getPrimanota(), this.getArt(), this.getCustomerRef())) {
                String[] fields = new String[]{u.getGegenkontoName(), u.getGegenkontoNummer(), u.getGegenkontoBLZ(), HBCI.DATEFORMAT.format(u.getDatum()), u.getZweck(), String.valueOf(k.getWaehrung()) + " " + HBCI.DECIMALFORMAT.format(u.getBetrag())};
                String msg = i18n.tr("Umsatz [Gegenkonto: {0}, Kto. {1} BLZ {2}], Datum {3}, Zweck: {4}] {5} ge\u00e4ndert", fields);
                k.addToProtokoll(msg, 1);
            }
            u.transactionCommit();
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Umsatz gespeichert"), 0));
            return true;
        }
        catch (ApplicationException e2) {
            try {
                u.transactionRollback();
            }
            catch (RemoteException e1) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e1);
            }
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e2.getMessage(), 1));
        }
        catch (RemoteException e) {
            try {
                u.transactionRollback();
            }
            catch (RemoteException e1) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e1);
            }
            Logger.error((String)"error while storing umsatz", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Speichern des Umsatzes: {0}", e.getMessage()), 1));
        }
        return false;
    }

    public void handleNext() {
        Umsatz u = this.getUmsatz();
        try {
            if (this.handleStore()) {
                new UmsatzDetailEdit().handleAction(u.getKonto());
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Umsatz gespeichert, neuer Umsatz angelegt"), 0));
            }
        }
        catch (ApplicationException e2) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e2.getMessage(), 1));
        }
        catch (RemoteException e) {
            Logger.error((String)"error while storing umsatz", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Speichern des Umsatzes: {0}", e.getMessage()), 1));
        }
    }

    private class EmpfaengerListener
    implements Listener {
        private EmpfaengerListener() {
        }

        public void handleEvent(Event event) {
            if (event == null || event.data == null || !(event.data instanceof Address)) {
                return;
            }
            Address empfaenger = (Address)event.data;
            try {
                UmsatzDetailEditControl.this.getEmpfaengerKonto().setValue((Object)empfaenger.getIban());
                String bic = empfaenger.getBic();
                UmsatzDetailEditControl.this.getEmpfaengerBLZ().setValue((Object)bic);
                String name = HBCIProperties.getNameForBank(bic);
                UmsatzDetailEditControl.this.getEmpfaengerBLZ().setComment(name);
            }
            catch (RemoteException er) {
                Logger.error((String)"error while choosing empfaenger", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei der Auswahl des Empf\u00e4ngers"));
            }
        }
    }
}

