/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.ColorInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.UmsatzTypInput;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UmsatzTypControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private UmsatzTyp ut = null;
    private TextInput name = null;
    private TextInput nummer = null;
    private TextInput pattern = null;
    private CheckboxInput regex = null;
    private SelectInput art = null;
    private UmsatzTypInput parent = null;
    private TextInput kommentar = null;
    private KontoInput konto = null;
    private CheckboxInput skipReport = null;
    private ColorInput color = null;
    private CheckboxInput customColor = null;

    public UmsatzTypControl(AbstractView view) {
        super(view);
    }

    public UmsatzTyp getUmsatzTyp() throws RemoteException {
        if (this.ut != null) {
            return this.ut;
        }
        this.ut = (UmsatzTyp)this.getCurrentObject();
        if (this.ut != null) {
            return this.ut;
        }
        this.ut = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
        return this.ut;
    }

    public TextInput getName() throws RemoteException {
        if (this.name == null) {
            this.name = new TextInput(this.getUmsatzTyp().getName());
            this.name.setMandatory(true);
        }
        return this.name;
    }

    public TextInput getKommentar() throws RemoteException {
        if (this.kommentar != null) {
            return this.kommentar;
        }
        this.kommentar = new TextAreaInput(this.getUmsatzTyp().getKommentar(), 1000);
        return this.kommentar;
    }

    public TextInput getNummer() throws RemoteException {
        if (this.nummer == null) {
            this.nummer = new TextInput(this.getUmsatzTyp().getNummer(), 5);
            this.nummer.setHint(i18n.tr("Wird auch f\u00fcr die Sortierung verwendet"));
            this.nummer.setMandatory(false);
        }
        return this.nummer;
    }

    public TextInput getPattern() throws RemoteException {
        if (this.pattern == null) {
            this.pattern = new TextInput(this.getUmsatzTyp().getPattern(), 1000);
            this.pattern.setHint(i18n.tr("F\u00fcr automatische Zuordnung anhand von Suchbegriffen"));
            this.pattern.addListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        String p = (String)UmsatzTypControl.this.pattern.getValue();
                        if (p == null || p.length() == 0) {
                            return;
                        }
                        boolean b = (Boolean)UmsatzTypControl.this.getRegex().getValue();
                        if (b) {
                            try {
                                Pattern.compile(p);
                            }
                            catch (PatternSyntaxException pse) {
                                GUI.getView().setErrorText(i18n.tr("Regul\u00e4rer Ausdruck ung\u00fcltig: {0}", pse.getDescription()));
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to verify pattern", (Throwable)e);
                    }
                }
            });
        }
        return this.pattern;
    }

    public CheckboxInput getRegex() throws RemoteException {
        if (this.regex == null) {
            this.regex = new CheckboxInput(this.getUmsatzTyp().isRegex());
        }
        return this.regex;
    }

    public CheckboxInput getCustomColor() throws RemoteException {
        if (this.customColor != null) {
            return this.customColor;
        }
        this.customColor = new CheckboxInput(this.getUmsatzTyp().isCustomColor());
        this.customColor.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    Boolean b = (Boolean)UmsatzTypControl.this.customColor.getValue();
                    UmsatzTypControl.this.getColor().setEnabled(b.booleanValue());
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to update color input", (Throwable)re);
                }
            }
        });
        return this.customColor;
    }

    public ColorInput getColor() throws RemoteException {
        if (this.color == null) {
            int[] rgb = this.getUmsatzTyp().getColor();
            if (rgb == null || rgb.length != 3) {
                rgb = new int[3];
            }
            this.color = new ColorInput(new Color((Device)GUI.getDisplay(), new RGB(rgb[0], rgb[1], rgb[2])), true);
            this.color.setEnabled(this.getUmsatzTyp().isCustomColor());
        }
        return this.color;
    }

    public SelectInput getArt() throws RemoteException {
        if (this.art == null) {
            ArrayList<UmsatzTypObject> list = new ArrayList<UmsatzTypObject>();
            list.add(new UmsatzTypObject(2));
            list.add(new UmsatzTypObject(1));
            list.add(new UmsatzTypObject(0));
            this.art = new SelectInput(list, (Object)new UmsatzTypObject(this.getUmsatzTyp().getTyp()));
        }
        return this.art;
    }

    public UmsatzTypInput getParent() throws RemoteException {
        if (this.parent != null) {
            return this.parent;
        }
        this.parent = new UmsatzTypInput((UmsatzTyp)this.getUmsatzTyp().getParent(), this.getUmsatzTyp(), 2, false);
        this.parent.setComment("");
        return this.parent;
    }

    public KontoInput getKonto() throws RemoteException {
        if (this.konto != null) {
            return this.konto;
        }
        String kat = this.getUmsatzTyp().getKontoKategorie();
        Konto k = this.getUmsatzTyp().getKonto();
        this.konto = new KontoInput(k, KontoFilter.ALL);
        this.konto.setComment(null);
        this.konto.setPleaseChoose("<" + i18n.tr("keine Einschr\u00e4nkung") + ">");
        this.konto.setSupportGroups(true);
        this.konto.setName(i18n.tr("Nur f\u00fcr Konto/Gruppe"));
        if (kat != null && kat.length() > 0) {
            this.konto.setValue(kat);
        }
        return this.konto;
    }

    public CheckboxInput getSkipReport() throws RemoteException {
        if (this.skipReport != null) {
            return this.skipReport;
        }
        this.skipReport = new CheckboxInput(this.getUmsatzTyp().hasFlag(1));
        this.skipReport.setName(i18n.tr("In Auswertungen ignorieren"));
        return this.skipReport;
    }

    public synchronized boolean handleStore() {
        try {
            UmsatzTypObject t = (UmsatzTypObject)this.getArt().getValue();
            UmsatzTyp ut = this.getUmsatzTyp();
            ut.setTyp(t == null ? 2 : t.typ);
            ut.setName((String)this.getName().getValue());
            ut.setKommentar((String)this.getKommentar().getValue());
            ut.setNummer((String)this.getNummer().getValue());
            ut.setPattern((String)this.getPattern().getValue());
            ut.setRegex((Boolean)this.getRegex().getValue());
            ut.setParent((UmsatzTyp)this.getParent().getValue());
            Object k = this.getKonto().getValue();
            if (k == null) {
                ut.setKonto(null);
                ut.setKontoKategorie(null);
            } else if (k instanceof Konto) {
                ut.setKonto((Konto)k);
            } else {
                ut.setKontoKategorie((String)k);
            }
            boolean skip = (Boolean)this.getSkipReport().getValue();
            int flags = ut.getFlags();
            boolean have = ut.hasFlag(1);
            if (skip && !have) {
                ut.setFlags(flags | 1);
            } else if (!skip && have) {
                ut.setFlags(flags ^ 1);
            }
            boolean b = (Boolean)this.getCustomColor().getValue();
            ut.setCustomColor(b);
            if (b) {
                Color c = (Color)this.getColor().getValue();
                if (c == null) {
                    ut.setColor(null);
                } else {
                    RGB rgb = c.getRGB();
                    ut.setColor(new int[]{rgb.red, rgb.green, rgb.blue});
                }
            }
            ut.store();
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Umsatz-Kategorie gespeichert"), 0));
            return true;
        }
        catch (ApplicationException e2) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e2.getMessage(), 1));
        }
        catch (RemoteException e) {
            Logger.error((String)"error while storing umsatz type", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Speichern der Umsatz-Kategorie"), 1));
        }
        return false;
    }

    public static class UmsatzTypObject
    implements GenericObject {
        private int typ = 2;

        private UmsatzTypObject(int typ) {
            this.typ = typ;
        }

        public int getTyp() {
            return this.typ;
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == this) {
                return true;
            }
            if (other == null || !(other instanceof UmsatzTypObject)) {
                return false;
            }
            return this.typ == ((UmsatzTypObject)other).typ;
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return UmsatzTypUtil.getNameForType(this.typ);
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name"};
        }

        public String getID() throws RemoteException {
            return String.valueOf(this.typ);
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }
}

