/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.DateFromInput;
import de.willuhn.jameica.hbci.gui.input.DateToInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.RangeInput;
import de.willuhn.jameica.hbci.gui.parts.UmsatzTree;
import de.willuhn.jameica.hbci.gui.parts.UmsatzTypVerlauf;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UmsatzTypTreeControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Map cache = new HashMap();
    private KontoInput kontoAuswahl = null;
    private TextInput text = null;
    private DateInput start = null;
    private DateInput end = null;
    private RangeInput range = null;
    private UmsatzTree tree = null;
    private UmsatzTypVerlauf chart = null;
    private boolean expanded = false;
    private Listener listener = new DelayedListener(new Listener(){

        public void handleEvent(Event event) {
            UmsatzTypTreeControl.this.handleReload();
        }
    });

    public UmsatzTypTreeControl(AbstractView view) {
        super(view);
    }

    public Listener changedListener(final Input input) {
        return new Listener(){

            public void handleEvent(Event event) {
                if (input.hasChanged()) {
                    UmsatzTypTreeControl.this.listener.handleEvent(event);
                }
            }
        };
    }

    public Input getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(null, KontoFilter.ALL);
        this.kontoAuswahl.setPleaseChoose(i18n.tr("<Alle Konten>"));
        this.kontoAuswahl.setSupportGroups(true);
        this.kontoAuswahl.setComment(null);
        this.kontoAuswahl.setRememberSelection("auswertungen.umsatztree");
        this.kontoAuswahl.addListener(this.changedListener((Input)this.kontoAuswahl));
        return this.kontoAuswahl;
    }

    public TextInput getText() {
        if (this.text != null) {
            return this.text;
        }
        this.text = new TextInput((String)cache.get("kontoauszug.list.text"), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
        this.text.setName(i18n.tr("Suchbegriff"));
        return this.text;
    }

    public RangeInput getRange() {
        if (this.range != null) {
            return this.range;
        }
        this.range = new RangeInput(this.getStart(), this.getEnd(), Range.Category.AUSWERTUNG, "auswertungen.umsatztree.filter.range");
        this.range.addListener(this.changedListener((Input)this.range));
        return this.range;
    }

    public Input getStart() {
        if (this.start != null) {
            return this.start;
        }
        this.start = new DateFromInput(null, "auswertungen.umsatztree.filter.from");
        this.start.setName(i18n.tr("Von"));
        this.start.setComment(null);
        this.start.addListener(this.changedListener((Input)this.start));
        return this.start;
    }

    public Input getEnd() {
        if (this.end != null) {
            return this.end;
        }
        this.end = new DateToInput(null, "auswertungen.umsatztree.filter.to");
        this.end.setName(i18n.tr("bis"));
        this.end.setComment(null);
        this.end.addListener(this.changedListener((Input)this.end));
        return this.end;
    }

    public de.willuhn.jameica.hbci.io.UmsatzTree getUmsatzTree() throws RemoteException {
        de.willuhn.jameica.hbci.io.UmsatzTree tree = new de.willuhn.jameica.hbci.io.UmsatzTree();
        tree.setEnd((Date)this.getEnd().getValue());
        tree.setStart((Date)this.getStart().getValue());
        Object konto = this.getKontoAuswahl().getValue();
        if (konto != null && konto instanceof Konto) {
            tree.setTitle(((Konto)konto).getBezeichnung());
        } else if (konto != null && konto instanceof String) {
            tree.setTitle((String)konto);
        }
        Object o = this.getTree().getSelection();
        LinkedList<UmsatzTreeNode> selection = new LinkedList<UmsatzTreeNode>();
        if (o instanceof UmsatzTreeNode) {
            selection.add((UmsatzTreeNode)o);
        } else if (o instanceof UmsatzTreeNode[]) {
            selection.addAll(Arrays.asList((UmsatzTreeNode[])o));
        }
        tree.setUmsatzTree(selection.size() > 0 ? selection : this.getTree().getItems());
        return tree;
    }

    public TreePart getTree() throws RemoteException {
        if (this.tree != null) {
            return this.tree;
        }
        this.tree = new UmsatzTree((GenericIterator)this.getUmsaetze());
        this.tree.setExpanded(this.expanded);
        return this.tree;
    }

    private DBIterator getUmsaetze() throws RemoteException {
        Object o = this.getKontoAuswahl().getValue();
        Date von = (Date)this.getStart().getValue();
        Date bis = (Date)this.getEnd().getValue();
        String text = (String)this.getText().getValue();
        cache.put("kontoauszug.list.text", text);
        Konto k = o instanceof Konto ? (Konto)o : null;
        String kat = o instanceof String ? (String)o : null;
        return UmsatzUtil.find(k, kat, von, bis, text);
    }

    public UmsatzTypVerlauf getChart() throws RemoteException {
        if (this.chart != null) {
            return this.chart;
        }
        this.chart = new UmsatzTypVerlauf();
        this.chart.setData(this.getAllGroups(), (Date)this.getStart().getValue(), (Date)this.getEnd().getValue());
        return this.chart;
    }

    public void handleExpand() {
        try {
            TreePart tree = this.getTree();
            List items = tree.getItems();
            int i = 0;
            while (i < items.size()) {
                tree.setExpanded((Object)((GenericObject)items.get(i)), !this.expanded, true);
                ++i;
            }
            this.expanded = !this.expanded;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to expand tree", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aufklappen/Zuklappen"), 1));
        }
    }

    public void handleReload() {
        try {
            this.getTree().setList((GenericIterator)this.getUmsaetze());
            this.getTree().restoreState();
            this.handleRefreshChart();
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to redraw tree", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren"), 1));
        }
    }

    public void handleRefreshChart() {
        try {
            Object selection = this.getTree().getSelection();
            List<UmsatzTreeNode> l = null;
            if (selection != null && selection instanceof UmsatzTreeNode[]) {
                l = Arrays.asList((UmsatzTreeNode[])selection);
            } else if (selection != null && selection instanceof UmsatzTreeNode) {
                l = new ArrayList<UmsatzTreeNode>();
                l.add((UmsatzTreeNode)selection);
            }
            if (l == null) {
                l = this.getAllGroups();
            }
            this.getChart().setData(l, (Date)this.getStart().getValue(), (Date)this.getEnd().getValue());
            this.getChart().redraw();
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to redraw chart", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren"), 1));
        }
    }

    private List<GenericObjectNode> getAllGroups() throws RemoteException {
        ArrayList<GenericObjectNode> list = new ArrayList<GenericObjectNode>();
        List root = this.getTree().getItems();
        for (GenericObjectNode r : root) {
            this._addGroup(r, list);
        }
        return list;
    }

    private void _addGroup(GenericObjectNode root, List<GenericObjectNode> target) throws RemoteException {
        target.add(root);
        GenericIterator children = root.getChildren();
        while (children.hasNext()) {
            GenericObject o = children.next();
            if (!(o instanceof GenericObjectNode)) continue;
            this._addGroup((GenericObjectNode)o, target);
        }
    }
}

