/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.FormTextPart;
import de.willuhn.jameica.gui.util.LabelGroup;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.DonateView;
import de.willuhn.jameica.hbci.gui.dialogs.DebugDialog;
import de.willuhn.jameica.hbci.rmi.Version;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.kapott.hbci.manager.HBCIUtils;

public class About
extends AbstractDialog {
    public About(int position) {
        super(position, true);
        AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
        I18N i18n = plugin.getResources().getI18N();
        this.setTitle(i18n.tr("\u00dcber ..."));
        this.setPanelText(i18n.tr("Hibiscus {0}", plugin.getManifest().getVersion().toString()));
    }

    protected void paint(Composite parent) throws Exception {
        AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
        final I18N i18n = plugin.getResources().getI18N();
        DBIterator list = Settings.getDBService().createList(Version.class);
        list.addFilter("name = ?", new Object[]{"db"});
        Version version = (Version)list.next();
        Label l = GUI.getStyleFactory().createLabel(parent, 2048);
        l.setImage(SWTUtil.getImage((String)"hibiscus-splash.png"));
        LabelGroup container = new LabelGroup(parent, i18n.tr("Versionsinformationen"), true);
        FormTextPart text = new FormTextPart();
        text.setText("<form><p><b>Hibiscus - HBCI-Onlinebanking f\u00fcr Jameica</b></p><p>Lizenz: GPL [<a href=\"http://www.gnu.org/copyleft/gpl.html\">www.gnu.org/copyleft/gpl.html</a>]<br/>Copyright by Olaf Willuhn [<a href=\"mailto:hibiscus@willuhn.de\">hibiscus@willuhn.de</a>]<br/><a href=\"http://www.willuhn.de/products/hibiscus/\">www.willuhn.de/products/hibiscus/</a></p><p>Software-Version: " + plugin.getManifest().getVersion() + "<br/>" + "HBCI4Java-Version: " + HBCIUtils.version() + "<br/>" + "Datenbank-Version: " + version.getVersion() + "<br/>" + "Myema-Plugin-Version: 0.8 <br/>" + "Build: " + plugin.getManifest().getBuildnumber() + " [Datum " + plugin.getManifest().getBuildDate() + "]</p>" + "</form>");
        container.addPart((Part)text);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Datenbank Infos"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    new DebugDialog(1).open();
                }
                catch (OperationCanceledException oce) {
                    Logger.info((String)oce.getMessage());
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to display debug dialog", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anzeigen der Datenbank-Informationen"), 1));
                }
            }
        }, null, false, "dialog-information.png");
        buttons.addButton(i18n.tr("Spenden"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                About.this.close();
                new DonateView().handleAction(null);
            }
        }, null, false, "emblem-special.png");
        buttons.addButton(i18n.tr("Schlie\u00dfen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                About.this.close();
            }
        }, null, true, "window-close.png");
        container.addButtonArea(buttons);
        this.setSize(-1, 600);
    }

    protected Object getData() throws Exception {
        return null;
    }
}

