/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.IntegerInput;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.AccountContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class AccountContainerDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 600;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private HBCIPassport passport = null;
    private AccountContainer container = null;
    private Input blz = null;
    private Input host = null;
    private Input port = null;
    private SelectInput filter = null;
    private Input userid = null;
    private Input customerid = null;
    private LabelInput text = null;

    public AccountContainerDialog(HBCIPassport passport) {
        super(1);
        this.passport = passport;
        this.setTitle(i18n.tr("Eingabe Ihrer Bank-Daten"));
        this.setSize(600, -1);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addHeadline(i18n.tr("Benutzerdaten"));
        c.addText(i18n.tr("Bitte geben Sie die Benutzerdaten des Kontos ein."), true);
        c.addLabelPair(i18n.tr("Benutzerkennung"), this.getUserId());
        c.addLabelPair(i18n.tr("Kundenkennung"), this.getCustomerId());
        c.addLabelPair(i18n.tr("Bankleitzahl"), this.getBLZ());
        c.addHeadline(i18n.tr("Verbindungsdaten"));
        c.addText(i18n.tr("Geben Sie hier bitte die Verbindungsdaten zu Ihrer Bank ein."), true);
        c.addLabelPair(i18n.tr("Hostname/URL des Bankservers"), this.getHost());
        c.addLabelPair(i18n.tr("TCP-Port des Bankservers"), this.getPort());
        c.addLabelPair(i18n.tr("Filter f\u00fcr die \u00dcbertragung"), (Input)this.getFilter());
        c.addLabelPair("", (Input)this.getText());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                AccountContainerDialog.this.container = new AccountContainer();
                AccountContainerDialog.this.container.blz = (String)AccountContainerDialog.this.getBLZ().getValue();
                AccountContainerDialog.this.container.userid = (String)AccountContainerDialog.this.getUserId().getValue();
                AccountContainerDialog.this.container.customerid = (String)AccountContainerDialog.this.getCustomerId().getValue();
                AccountContainerDialog.this.container.filter = (String)AccountContainerDialog.this.getFilter().getValue();
                AccountContainerDialog.this.container.host = (String)AccountContainerDialog.this.getHost().getValue();
                Integer i = (Integer)AccountContainerDialog.this.getPort().getValue();
                int n = AccountContainerDialog.this.container.port = i != null ? i : -1;
                if (AccountContainerDialog.this.container.userid == null || AccountContainerDialog.this.container.userid.length() == 0) {
                    AccountContainerDialog.this.getText().setValue((Object)i18n.tr("Bitte geben Sie eine Benutzerkennung ein."));
                    return;
                }
                if (AccountContainerDialog.this.container.blz == null || AccountContainerDialog.this.container.blz.length() == 0) {
                    AccountContainerDialog.this.getText().setValue((Object)i18n.tr("Bitte geben Sie eine Bankleitzahl ein."));
                    return;
                }
                if (AccountContainerDialog.this.container.host == null || AccountContainerDialog.this.container.host.length() == 0) {
                    AccountContainerDialog.this.getText().setValue((Object)i18n.tr("Bitte geben Sie den Hostnamen bzw. die URL des Bankservers ein."));
                    return;
                }
                if (AccountContainerDialog.this.container.port <= 0) {
                    AccountContainerDialog.this.getText().setValue((Object)i18n.tr("Bitte geben Sie den TCP-Port des Bankservers ein."));
                    return;
                }
                AccountContainerDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(600, -1));
    }

    protected Object getData() throws Exception {
        return this.container;
    }

    private LabelInput getText() {
        if (this.text == null) {
            this.text = new LabelInput("");
            this.text.setColor(Color.ERROR);
        }
        return this.text;
    }

    private Input getBLZ() {
        if (this.blz != null) {
            return this.blz;
        }
        this.blz = new BLZInput(this.passport.getBLZ());
        this.blz.setMandatory(true);
        this.blz.addListener(new Listener(){

            public void handleEvent(Event arg0) {
                try {
                    String b;
                    BankInfo bi;
                    String host = (String)AccountContainerDialog.this.getHost().getValue();
                    if ((host == null || host.length() == 0) && (bi = HBCIProperties.getBankInfo(b = (String)AccountContainerDialog.this.blz.getValue())) != null) {
                        String clazz = AccountContainerDialog.this.passport.getClass().getName();
                        if (clazz.toUpperCase().indexOf("PINTAN") != -1) {
                            String s = bi.getPinTanAddress();
                            if (s != null && s.startsWith("https://")) {
                                s = s.replaceFirst("https://", "");
                            }
                            AccountContainerDialog.this.getHost().setValue((Object)s);
                        } else {
                            AccountContainerDialog.this.getHost().setValue((Object)bi.getRdhAddress());
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while auto detecting url/ip for blz", (Throwable)e);
                }
            }
        });
        return this.blz;
    }

    private Input getHost() {
        if (this.host != null) {
            return this.host;
        }
        this.host = new TextInput(this.passport.getHost()){

            public Object getValue() {
                String s = (String)super.getValue();
                if (s == null || s.length() == 0) {
                    return null;
                }
                return AccountContainerDialog.this.cleanUrl(s);
            }
        };
        this.host.addListener(new Listener(){

            public void handleEvent(Event event) {
                AccountContainerDialog.this.getHost().setValue(AccountContainerDialog.this.getHost().getValue());
            }
        });
        this.host.setComment(i18n.tr("Bitte ohne \"https://\" eingeben"));
        this.host.setMandatory(true);
        return this.host;
    }

    private Input getPort() {
        if (this.port == null) {
            Integer value = this.passport.getPort();
            int i = value != null && value > 0 ? value : (this.passport instanceof AbstractPinTanPassport ? 443 : 3000);
            this.port = new IntegerInput(i);
            this.port.setComment(i18n.tr("Bei PIN/TAN \"443\", sonst \"3000\""));
            this.port.setMandatory(true);
        }
        return this.port;
    }

    private Input getUserId() {
        if (this.userid == null) {
            this.userid = new TextInput(this.passport.getUserId(), 30);
            this.userid.setMandatory(true);
        }
        return this.userid;
    }

    private Input getCustomerId() {
        if (this.customerid == null) {
            this.customerid = new TextInput(this.passport.getCustomerId(), 30);
            this.customerid.setComment(i18n.tr("Meist identisch mit Benutzerkennung"));
        }
        return this.customerid;
    }

    private SelectInput getFilter() {
        if (this.filter == null) {
            this.filter = new SelectInput((Object[])new String[]{"None", "Base64"}, (Object)this.passport.getFilterType());
            this.filter.setComment(i18n.tr("Bei PIN/TAN meist \"Base64\", sonst \"None\""));
            String clazz = this.passport.getClass().getName();
            if (clazz.toUpperCase().indexOf("PINTAN") != -1) {
                this.filter.setPreselected((Object)"Base64");
            }
        }
        return this.filter;
    }

    private String cleanUrl(String url) {
        if ((url = StringUtils.trimToEmpty((String)url)).length() == 0) {
            return url;
        }
        if (url.startsWith("https://")) {
            url = url.replaceFirst("https://", "");
        }
        url = url.replaceFirst(":[0-9]{1,5}/", "/");
        return url;
    }
}

