/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.parts.EmpfaengerList;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class AdresseAuswahlDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = new Settings(AdresseAuswahlDialog.class);
    private static final int WINDOW_WIDTH = 640;
    private static final int WINDOW_HEIGHT = 460;
    private Address choosen = null;
    private AddressFilter filter = null;

    public AdresseAuswahlDialog(int position) {
        this(position, null);
    }

    public AdresseAuswahlDialog(int position, AddressFilter filter) {
        super(position);
        this.filter = filter;
        this.setTitle(i18n.tr("Adressbuch"));
        this.setSize(settings.getInt("window.width", 640), settings.getInt("window.height", 460));
    }

    protected void paint(Composite parent) throws Exception {
        Action a = new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof Address)) {
                    return;
                }
                AdresseAuswahlDialog.this.choosen = (Address)context;
                AdresseAuswahlDialog.this.close();
            }
        };
        SimpleContainer c1 = new SimpleContainer(parent, true, 1);
        final EmpfaengerList empf = new EmpfaengerList(a, this.filter, false);
        empf.setContextMenu(null);
        empf.setMulti(false);
        empf.removeFeature(FeatureSummary.class);
        final Button apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Object o = empf.getSelection();
                if (o == null || !(o instanceof Address)) {
                    return;
                }
                AdresseAuswahlDialog.this.choosen = (Address)o;
                AdresseAuswahlDialog.this.close();
            }
        }, null, true, "ok.png");
        apply.setEnabled(false);
        empf.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                apply.setEnabled(empf.getSelection() != null);
            }
        });
        empf.paint(c1.getComposite());
        ButtonArea b = new ButtonArea();
        b.addButton(apply);
        b.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        SimpleContainer c2 = new SimpleContainer(parent);
        c2.addButtonArea(b);
        this.getShell().setMinimumSize(640, 460);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell shell = AdresseAuswahlDialog.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                Point size = shell.getSize();
                Logger.debug((String)("saving window size: " + size.x + "x" + size.y));
                settings.setAttribute("window.width", size.x);
                settings.setAttribute("window.height", size.y);
            }
        });
    }

    protected Object getData() throws Exception {
        return this.choosen;
    }
}

