/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.dialogs.AbstractExecuteDialog;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import org.eclipse.swt.widgets.Composite;

public class AuslandsUeberweisungDialog
extends AbstractExecuteDialog {
    private AuslandsUeberweisung ueb;

    public AuslandsUeberweisungDialog(AuslandsUeberweisung u, int position) {
        super(position);
        this.ueb = u;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addHeadline(i18n.tr("Details der SEPA-\u00dcberweisung"));
        LabelInput kto = new LabelInput(this.ueb.getKonto().getKontonummer());
        kto.setComment(this.ueb.getKonto().getBezeichnung());
        group.addLabelPair(i18n.tr("Eigenes Konto"), (Input)kto);
        LabelInput empfName = new LabelInput(this.ueb.getGegenkontoName());
        group.addLabelPair(i18n.tr("Name des Empf\u00e4ngers"), (Input)empfName);
        LabelInput empfKto = new LabelInput(HBCIProperties.formatIban(this.ueb.getGegenkontoNummer()));
        group.addLabelPair(i18n.tr("IBAN des Empf\u00e4ngers"), (Input)empfKto);
        LabelInput empfBic = new LabelInput(this.ueb.getGegenkontoBLZ());
        group.addLabelPair(i18n.tr("BIC des Empf\u00e4ngers"), (Input)empfBic);
        LabelInput betrag = new LabelInput(String.valueOf(HBCI.DECIMALFORMAT.format(this.ueb.getBetrag())) + " " + this.ueb.getKonto().getWaehrung());
        betrag.setColor(Color.ERROR);
        group.addLabelPair(i18n.tr("Betrag"), (Input)betrag);
        if (this.ueb.isTerminUeberweisung()) {
            LabelInput termin = new LabelInput(HBCI.DATEFORMAT.format(this.ueb.getTermin()));
            group.addLabelPair(i18n.tr("Ausf\u00fchrungstermin"), (Input)termin);
        }
        group.addHeadline(i18n.tr("Verwendungszweck"));
        group.addText(VerwendungszweckUtil.toString(this.ueb, "\n"), false);
        super.paint(parent);
        this.getShell().setMinimumSize(this.getShell().computeSize(-1, -1));
    }
}

