/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.dialogs.CalendarDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BaseDauerauftragDeleteDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Date date = null;
    private DialogInput dateInput = null;
    private CheckboxInput box = null;
    private LabelInput comment = null;

    public BaseDauerauftragDeleteDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Zieldatum"));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addHeadline(i18n.tr("Zieldatum zur L\u00f6schung des Dauerauftrages"));
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie das Datum aus, zu dem Sie den Dauerauftrag l\u00f6schen wollen\nHinweis: Es ist durchaus m\u00f6glich, dass Ihre Bank das L\u00f6schen eines\nDauerauftrages zu einem definierten Datum nicht unterst\u00fctzt.\nW\u00e4hlen Sie in diesem Fall bitte \"Zum n\u00e4chstm\u00f6glichen Zeitpunkt\""), true);
        this.box = new CheckboxInput(true);
        this.box.addListener(new Listener(){

            public void handleEvent(Event event) {
                Boolean b = (Boolean)BaseDauerauftragDeleteDialog.this.box.getValue();
                if (b.booleanValue()) {
                    BaseDauerauftragDeleteDialog.this.dateInput.disableButton();
                } else {
                    BaseDauerauftragDeleteDialog.this.dateInput.enableButton();
                }
            }
        });
        group.addCheckbox(this.box, i18n.tr("Zum n\u00e4chstm\u00f6glichen Zeitpunkt"));
        CalendarDialog cd = new CalendarDialog(0);
        cd.setTitle(i18n.tr("Zieldatum"));
        cd.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (event == null || event.data == null || !(event.data instanceof Date)) {
                    return;
                }
                BaseDauerauftragDeleteDialog.this.date = (Date)event.data;
                if (BaseDauerauftragDeleteDialog.this.date == null) {
                    BaseDauerauftragDeleteDialog.this.comment.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie ein Zieldatum aus"));
                    BaseDauerauftragDeleteDialog.this.dateInput.setValue(null);
                    BaseDauerauftragDeleteDialog.this.dateInput.setText(null);
                    return;
                }
                Date today = new Date(System.currentTimeMillis() - 86400000L);
                if (BaseDauerauftragDeleteDialog.this.date != null && BaseDauerauftragDeleteDialog.this.date.before(today)) {
                    BaseDauerauftragDeleteDialog.this.comment.setValue((Object)i18n.tr("Datum darf nicht in der Vergangenheit liegen"));
                    return;
                }
                BaseDauerauftragDeleteDialog.this.comment.setValue((Object)"");
                BaseDauerauftragDeleteDialog.this.dateInput.setValue((Object)BaseDauerauftragDeleteDialog.this.date);
                BaseDauerauftragDeleteDialog.this.dateInput.setText(HBCI.DATEFORMAT.format(BaseDauerauftragDeleteDialog.this.date));
            }
        });
        cd.setDate(this.date == null ? new Date() : this.date);
        this.dateInput = new DialogInput(this.date == null ? null : HBCI.DATEFORMAT.format(this.date), (AbstractDialog)cd);
        this.dateInput.disableClientControl();
        this.dateInput.setValue((Object)this.date);
        group.addLabelPair(i18n.tr("Dauerauftrag l\u00f6schen zum"), (Input)this.dateInput);
        this.comment = new LabelInput("");
        this.comment.setColor(Color.ERROR);
        group.addLabelPair("", (Input)this.comment);
        ButtonArea b = new ButtonArea();
        b.addButton(i18n.tr("Jetzt bei der Bank l\u00f6schen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Boolean b = (Boolean)BaseDauerauftragDeleteDialog.this.box.getValue();
                if (b.booleanValue()) {
                    BaseDauerauftragDeleteDialog.this.date = null;
                } else {
                    BaseDauerauftragDeleteDialog.this.date = (Date)BaseDauerauftragDeleteDialog.this.dateInput.getValue();
                    if (BaseDauerauftragDeleteDialog.this.date == null) {
                        BaseDauerauftragDeleteDialog.this.comment.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie ein Datum aus."));
                        return;
                    }
                    Date today = new Date(System.currentTimeMillis() - 86400000L);
                    if (BaseDauerauftragDeleteDialog.this.date != null && BaseDauerauftragDeleteDialog.this.date.before(today)) {
                        BaseDauerauftragDeleteDialog.this.comment.setValue((Object)i18n.tr("Datum darf nicht in der Vergangenheit liegen"));
                        return;
                    }
                }
                BaseDauerauftragDeleteDialog.this.close();
            }
        }, null, false, "user-trash-full.png");
        b.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, true, "process-stop.png");
        group.addButtonArea(b);
    }

    protected Object getData() throws Exception {
        return this.date;
    }
}

