/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.SpinnerInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.ScrolledContainer;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.csv.Column;
import de.willuhn.jameica.hbci.io.csv.Format;
import de.willuhn.jameica.hbci.io.csv.Profile;
import de.willuhn.jameica.hbci.io.csv.ProfileUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CSVImportDialog
extends AbstractDialog {
    private static final Settings settings = new Settings(CSVImportDialog.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final String[] CHARSETS = new String[]{"UTF-8", "ISO-8859-15", "ISO-8859-1", "UTF-16"};
    private SelectInput profiles = null;
    private Profile result = null;
    private Format format = null;
    private byte[] data = null;
    private TextInput sepChar = null;
    private TextInput quoteChar = null;
    private SelectInput encoding = null;
    private SpinnerInput skipLines = null;
    private LabelInput error = null;
    private List<SelectInput> selects = new ArrayList<SelectInput>();
    private Composite parent = null;

    public CSVImportDialog(byte[] data, Format format, int position) throws IOException, ApplicationException {
        super(position);
        this.format = format;
        this.data = data;
        this.setTitle(i18n.tr("Zuordnung der Spalten"));
        this.setSize(680, 700);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer options = new SimpleContainer(parent);
        options.addInput((Input)this.getProfiles());
        ButtonArea b = new ButtonArea();
        b.addButton(i18n.tr("CSV-Datei neu laden"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CSVImportDialog.this.reload();
            }
        }, null, false, "view-refresh.png");
        b.addButton(i18n.tr("Profil speichern..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Profile p = new Profile();
                p.setColumns(CSVImportDialog.this.getColumns());
                p.setName(CSVImportDialog.this.getProfile().getName());
                p.setSystem(false);
                p.setFileEncoding((String)CSVImportDialog.this.getFileEncoding().getValue());
                p.setQuotingChar((String)CSVImportDialog.this.getQuoteChar().getValue());
                p.setSeparatorChar((String)CSVImportDialog.this.getSeparatorChar().getValue());
                p.setSkipLines((Integer)CSVImportDialog.this.getSkipLines().getValue());
                Profile pNew = ProfileUtil.add(CSVImportDialog.this.format, p);
                if (pNew != null) {
                    CSVImportDialog.this.getProfiles().setList(ProfileUtil.read(CSVImportDialog.this.format));
                    CSVImportDialog.this.getProfiles().setPreselected((Object)pNew);
                }
            }
        }, null, false, "document-save.png");
        b.addButton(i18n.tr("Profil l\u00f6schen..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    if (!Application.getCallback().askUser(i18n.tr("Soll das Profil wirklich gel\u00f6scht werden?"), false)) {
                        return;
                    }
                }
                catch (OperationCanceledException | ApplicationException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to delete profile", (Throwable)e);
                    CSVImportDialog.this.getError().setValue((Object)i18n.tr("Fehler beim L\u00f6schen: {0}", e.getMessage()));
                    return;
                }
                if (ProfileUtil.delete(CSVImportDialog.this.format, CSVImportDialog.this.getProfile())) {
                    CSVImportDialog.this.getProfiles().setList(ProfileUtil.read(CSVImportDialog.this.format));
                    CSVImportDialog.this.getProfiles().setValue(CSVImportDialog.this.getProfiles().getList().get(0));
                }
                CSVImportDialog.this.update();
                CSVImportDialog.this.reload();
            }
        }, null, false, "user-trash-full.png");
        options.addButtonArea(b);
        options.addText("", false);
        options.addHeadline(i18n.tr("Optionen"));
        options.addInput((Input)this.getFileEncoding());
        options.addInput((Input)this.getSeparatorChar());
        options.addInput((Input)this.getQuoteChar());
        options.addInput((Input)this.getSkipLines());
        options.addText("", false);
        options.addHeadline(i18n.tr("Zuordnung der Spalten"));
        options.addText(i18n.tr("In der linken Spalte sehen Sie die erste Zeile Ihrer CSV-Datei.\nOrdnen Sie die Felder bitte \u00fcber die Auswahl-Elemente auf der rechte Seite zu."), true);
        this.parent = new Composite(parent, 0);
        this.parent.setLayoutData((Object)new GridData(1808));
        this.parent.setLayout((Layout)new GridLayout());
        this.reload();
        SimpleContainer c = new SimpleContainer(parent);
        c.addInput((Input)this.getError());
        ButtonArea b2 = new ButtonArea();
        b2.addButton(i18n.tr("Import starten"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CSVImportDialog.this.result = CSVImportDialog.this.getProfile();
                CSVImportDialog.this.result.setFileEncoding((String)CSVImportDialog.this.getFileEncoding().getValue());
                CSVImportDialog.this.result.setQuotingChar((String)CSVImportDialog.this.getQuoteChar().getValue());
                CSVImportDialog.this.result.setSeparatorChar((String)CSVImportDialog.this.getSeparatorChar().getValue());
                CSVImportDialog.this.result.setSkipLines((Integer)CSVImportDialog.this.getSkipLines().getValue());
                CSVImportDialog.this.result.setColumns(CSVImportDialog.this.getColumns());
                settings.setAttribute(String.valueOf(CSVImportDialog.this.format.getType().getSimpleName()) + ".defaultprofile", CSVImportDialog.this.result.getName());
                CSVImportDialog.this.close();
            }
        }, null, false, "ok.png");
        b2.addButton((Button)new Cancel());
        c.addButtonArea(b2);
    }

    private List<Column> getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        int i = 0;
        while (i < this.selects.size()) {
            SelectInput input = this.selects.get(i);
            Column c = (Column)input.getValue();
            if (c != null) {
                try {
                    c = (Column)c.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                c.setColumn(i);
                columns.add(c);
            }
            ++i;
        }
        return columns;
    }

    private void reload() {
        int skip;
        int cols;
        ArrayList lines;
        Profile p;
        CsvListReader csv;
        block16: {
            block15: {
                block14: {
                    csv = null;
                    SWTUtil.disposeChildren((Composite)this.parent);
                    this.parent.setLayout((Layout)new GridLayout());
                    this.selects.clear();
                    p = this.getProfile();
                    lines = new ArrayList();
                    cols = 0;
                    CsvPreference prefs = p.createCsvPreference();
                    String enc = (String)this.getFileEncoding().getValue();
                    Charset charset = null;
                    try {
                        charset = Charset.forName(enc);
                    }
                    catch (UnsupportedCharsetException e) {
                        this.getError().setValue((Object)i18n.tr("Encoding {0} ignoriert, wird nicht unterst\u00fctzt", enc));
                    }
                    csv = new CsvListReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(this.data), charset != null ? charset : Charset.defaultCharset()), prefs);
                    List line = null;
                    while ((line = csv.read()) != null) {
                        ArrayList l = new ArrayList(line);
                        lines.add(l);
                        cols = Math.max(l.size(), cols);
                    }
                    if (cols != 0) break block14;
                    this.getError().setValue((Object)i18n.tr("CSV-Datei enth\u00e4lt keine Spalten"));
                    IOUtil.close((Closeable[])new Closeable[]{csv});
                    return;
                }
                if (lines.size() != 0) break block15;
                this.getError().setValue((Object)i18n.tr("CSV-Datei enth\u00e4lt keine Zeilen"));
                IOUtil.close((Closeable[])new Closeable[]{csv});
                return;
            }
            skip = (Integer)this.getSkipLines().getValue();
            if (lines.size() > skip) break block16;
            this.getError().setValue((Object)i18n.tr("CSV-Datei enth\u00e4lt nur {0} Zeilen", Integer.toString(lines.size())));
            IOUtil.close((Closeable[])new Closeable[]{csv});
            return;
        }
        try {
            try {
                List<Column> all = this.format.getDefaultProfile().getColumns();
                List<Column> columns = p.getColumns();
                List current = (List)lines.get(skip);
                ScrolledContainer container = new ScrolledContainer(this.parent);
                int i = 0;
                while (i < cols) {
                    String value = "";
                    try {
                        value = (String)current.get(i);
                        if (value.length() > 30) {
                            value = String.valueOf(value.substring(0, 30)) + "...";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SelectInput s = new SelectInput(all, (Object)this.getColumn(columns, i));
                    s.setName(String.valueOf(i + 1) + ". " + (value != null ? value : "<" + i18n.tr("leer") + ">"));
                    s.setPleaseChoose("<" + i18n.tr("Nicht zugeordnet") + ">");
                    this.selects.add(s);
                    container.addInput((Input)s);
                    ++i;
                }
                container.update();
                this.parent.layout(true);
                this.getError().setValue((Object)"");
            }
            catch (Exception e) {
                Logger.error((String)"unable to read file", (Throwable)e);
                this.getError().setValue((Object)i18n.tr("Fehler beim Lesen der Datei: {0}", e.getMessage()));
                IOUtil.close((Closeable[])new Closeable[]{csv});
            }
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{csv});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{csv});
    }

    private Column getColumn(List<Column> list, int nr) {
        for (Column c : list) {
            if (c.getColumn() != nr) continue;
            return c;
        }
        return null;
    }

    protected Object getData() throws Exception {
        return this.result;
    }

    private TextInput getSeparatorChar() {
        if (this.sepChar != null) {
            return this.sepChar;
        }
        this.sepChar = new TextInput(this.getProfile().getSeparatorChar(), 1);
        this.sepChar.setName(i18n.tr("Trennzeichen"));
        this.sepChar.setComment(i18n.tr("Zeichen, mit dem die Spalten getrennt sind"));
        this.sepChar.setMandatory(true);
        return this.sepChar;
    }

    private LabelInput getError() {
        if (this.error != null) {
            return this.error;
        }
        this.error = new LabelInput("");
        this.error.setName("");
        this.error.setColor(Color.ERROR);
        return this.error;
    }

    private TextInput getQuoteChar() {
        if (this.quoteChar != null) {
            return this.quoteChar;
        }
        this.quoteChar = new TextInput(this.getProfile().getQuotingChar(), 1);
        this.quoteChar.setName(i18n.tr("Anf\u00fchrungszeichen"));
        this.quoteChar.setComment(i18n.tr("Zeichen, mit dem die Spalten umschlossen sind"));
        this.quoteChar.setMandatory(false);
        return this.quoteChar;
    }

    private SelectInput getFileEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        this.encoding = new SelectInput((Object[])CHARSETS, (Object)this.getProfile().getFileEncoding());
        this.encoding.setName(i18n.tr("Zeichensatz"));
        this.encoding.setComment(i18n.tr("Zeichensatz der CSV-Datei"));
        this.encoding.setMandatory(true);
        this.encoding.setEditable(true);
        return this.encoding;
    }

    private SpinnerInput getSkipLines() {
        if (this.skipLines != null) {
            return this.skipLines;
        }
        this.skipLines = new SpinnerInput(0, 10, this.getProfile().getSkipLines());
        this.skipLines.setName(i18n.tr("Zeilen \u00fcberspringen"));
        this.skipLines.setComment(i18n.tr("Zu \u00fcberspringende Zeilen am Datei-Anfang"));
        this.skipLines.setMandatory(false);
        return this.skipLines;
    }

    private Profile getProfile() {
        return (Profile)this.getProfiles().getValue();
    }

    private SelectInput getProfiles() {
        if (this.profiles != null) {
            return this.profiles;
        }
        List<Profile> list = ProfileUtil.read(this.format);
        String name = settings.getString(String.valueOf(this.format.getType().getSimpleName()) + ".defaultprofile", null);
        Profile p = null;
        if (name != null) {
            for (Profile pr : list) {
                if (!StringUtils.equals((String)pr.getName(), (String)name)) continue;
                p = pr;
                break;
            }
        }
        this.profiles = new SelectInput(list, p);
        this.profiles.setAttribute("name");
        this.profiles.setName(i18n.tr("Profil"));
        this.profiles.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (event != null && event.type == 13) {
                    CSVImportDialog.this.update();
                    CSVImportDialog.this.reload();
                }
            }
        });
        return this.profiles;
    }

    private void update() {
        Profile p = this.getProfile();
        Logger.info((String)("changing profile to: " + p));
        this.getFileEncoding().setValue((Object)p.getFileEncoding());
        this.getQuoteChar().setValue((Object)p.getQuotingChar());
        this.getSeparatorChar().setValue((Object)p.getSeparatorChar());
        this.getSkipLines().setValue((Object)p.getSkipLines());
        this.reload();
    }
}

