/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.csv.Format;
import de.willuhn.jameica.hbci.io.csv.Profile;
import de.willuhn.jameica.hbci.io.csv.ProfileUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;

public class CSVProfileStoreDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 500;
    private Format format = null;
    private Profile profile = null;
    private Button apply = null;
    private TextInput name = null;
    private LabelInput hint = null;
    private List<Profile> profiles = null;

    public CSVProfileStoreDialog(Format format, Profile profile) {
        super(1);
        this.setSize(500, -1);
        this.setTitle(i18n.tr("Name des Profils"));
        this.setSideImage(SWTUtil.getImage((String)"dialog-question-large.png"));
        this.profile = profile;
        this.profile.setSystem(false);
        this.format = format;
        this.profiles = ProfileUtil.read(format);
    }

    private TextInput getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = new TextInput(this.suggestName());
        this.name.setName("");
        this.name.setMandatory(true);
        return this.name;
    }

    private String suggestName() {
        String template = this.profile.getName();
        int space = template.lastIndexOf(" ");
        if (space > 0) {
            String s1 = StringUtils.trimToNull((String)template.substring(0, space));
            String s2 = StringUtils.trimToNull((String)template.substring(space));
            if (s1 != null && s2 != null && s2.matches("[0-9]{1,4}")) {
                template = s1;
            }
        }
        int i = 2;
        while (i < 100) {
            boolean found = false;
            String name = String.valueOf(template) + " " + i;
            for (Profile p : this.profiles) {
                if (!name.equals(p.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                return name;
            }
            ++i;
        }
        return template;
    }

    private LabelInput getHint() {
        if (this.hint != null) {
            return this.hint;
        }
        this.hint = new LabelInput("");
        this.hint.setName("");
        this.hint.setColor(Color.ERROR);
        return this.hint;
    }

    private Button getApply() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CSVProfileStoreDialog.this.profile.setName((String)CSVProfileStoreDialog.this.getName().getValue());
                boolean found = false;
                for (Profile p : CSVProfileStoreDialog.this.profiles) {
                    if (p.isSystem() || !p.getName().equals(CSVProfileStoreDialog.this.profile.getName())) continue;
                    CSVProfileStoreDialog.this.profiles.set(CSVProfileStoreDialog.this.profiles.indexOf(p), CSVProfileStoreDialog.this.profile);
                    found = true;
                    break;
                }
                if (!found) {
                    CSVProfileStoreDialog.this.profiles.add(CSVProfileStoreDialog.this.profile);
                }
                ProfileUtil.store(CSVProfileStoreDialog.this.format, CSVProfileStoreDialog.this.profiles);
                CSVProfileStoreDialog.this.close();
            }
        }, null, true, "ok.png");
        return this.apply;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(i18n.tr("Bitte geben Sie einen Namen f\u00fcr das Profil an.\n\nVerwenden Sie einen noch nicht benutzten Namen, um ein neues Profil hinzuzuf\u00fcgen. Vergeben Sie alternativ einen bereits verwendeten Namen, um dieses Profil zu \u00fcberschreiben."), true);
        TextInput name = this.getName();
        c.addInput((Input)name);
        name.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CSVProfileStoreDialog.this.updateUI();
            }
        });
        c.addInput((Input)this.getHint());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.getApply());
        buttons.addButton((Button)new Cancel());
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
        this.updateUI();
    }

    private void updateUI() {
        String text = StringUtils.trimToNull((String)((String)this.name.getValue()));
        this.getApply().setEnabled(text != null);
        if (text == null) {
            return;
        }
        this.getHint().setValue((Object)"");
        boolean found = false;
        boolean system = false;
        for (Profile p : this.profiles) {
            if (!p.getName().equals(text)) continue;
            found = true;
            system = p.isSystem();
        }
        if (!found) {
            this.getHint().setColor(Color.SUCCESS);
            this.getHint().setValue((Object)i18n.tr("Ein neues Profil wird angelegt."));
        }
        if (found && !system) {
            this.getHint().setColor(Color.LINK);
            this.getHint().setValue((Object)i18n.tr("Existierendes Profil wird \u00fcberschrieben."));
        }
        if (system) {
            this.getHint().setColor(Color.ERROR);
            this.getHint().setValue((Object)i18n.tr("Das Default-Profil darf nicht \u00fcberschrieben werden."));
            this.getApply().setEnabled(false);
        }
    }

    protected Object getData() throws Exception {
        return this.profile;
    }
}

