/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class CamtSetupDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 780;
    private Konto konto = null;
    private CheckboxInput switchAll = null;
    private Boolean value = null;

    public CamtSetupDialog(Konto k) {
        super(1);
        this.konto = k;
        this.setTitle(i18n.tr("Ums\u00e4tze im SEPA CAMT-Format abrufen"));
        this.setSize(780, -1);
        this.setSideImage(SWTUtil.getImage((String)"camtsetup.png"));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        String text = "Hibiscus unterst\u00fctzt beim Abruf der Konto-Ums\u00e4tze jetzt auch das neue moderne XML-basierte CAMT-Format, welches f\u00fcr den SEPA-Zahlungsverkehr besser geeignet ist als das bisherige MT940-Format.\n\nDas Konto \"{0}\" kann jetzt auf CAMT umgestellt werden. Sie k\u00f6nnen diese Umstellung sp\u00e4ter in den Synchronisierungsoptionen des Kontos jederzeit wieder r\u00fcckg\u00e4ngig machen.";
        c.addText(i18n.tr(text, this.konto.getLongName()), true);
        c.addHeadline(i18n.tr("Hinweis"));
        text = "Da sich die Datenformate von CAMT und MT940 grundlegend unterscheiden, kann es nach der Umstellung dazu kommen, dass Umsatzbuchungen ggf. doppelt angezeigt werden. Sie k\u00f6nnen diese Duplikate einfach l\u00f6schen. In der Regel sollte das jedoch nur am Tag der Umstellung selbst auftreten.";
        c.addText(text, true);
        c.addInput((Input)this.getSwitchAll());
        ButtonArea buttons = new ButtonArea();
        Button yes = new Button(i18n.tr("Ja, auf CAMT umstellen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CamtSetupDialog.this.apply(true);
            }
        }, null, true, "ok.png");
        buttons.addButton(yes);
        Button no = new Button(i18n.tr("Nein, nicht umstellen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CamtSetupDialog.this.apply(false);
            }
        }, null, true, "window-close.png");
        buttons.addButton(no);
        Button later = new Button(i18n.tr("Beim n\u00e4chsten Mal erinnern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CamtSetupDialog.this.close();
            }
        }, null, true, "preferences-system-time.png");
        buttons.addButton(later);
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(780, -1));
    }

    private CheckboxInput getSwitchAll() {
        if (this.switchAll != null) {
            return this.switchAll;
        }
        this.switchAll = new CheckboxInput(false);
        this.switchAll.setName(i18n.tr("Auch auf alle anderen Konten anwenden"));
        return this.switchAll;
    }

    private void apply(boolean enabled) {
        try {
            try {
                this.value = enabled;
                String s = Boolean.toString(enabled);
                Boolean all = (Boolean)this.getSwitchAll().getValue();
                List<Konto> konten = all != false ? KontoUtil.getKonten(KontoFilter.ONLINE) : Arrays.asList(this.konto);
                for (Konto k : konten) {
                    MetaKey.UMSATZ_CAMT.set(k, s);
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to save changes", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("\u00dcbernehmen der Einstellungen fehlgeschlagen: {0}", e.getMessage()), 1));
                this.close();
            }
        }
        finally {
            this.close();
        }
    }

    protected Object getData() throws Exception {
        return this.value;
    }
}

