/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.services.TransportService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.ConsoleMonitor;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.transport.Transport;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CaptchaDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private InputStream image = null;
    private String data = null;
    private TextInput solution = null;
    private Button applyButton = null;

    public CaptchaDialog(String url, int position) throws ApplicationException {
        this(new ByteArrayInputStream(CaptchaDialog.fetch(url)), position);
    }

    public CaptchaDialog(InputStream is, int position) throws ApplicationException {
        super(position, false);
        this.setTitle(i18n.tr("Captcha l\u00f6sen"));
        this.setPanelText(i18n.tr("Bitte geben Sie den in der Grafik angezeigten Text ein."));
        this.image = is;
    }

    private static byte[] fetch(String url) throws ApplicationException {
        try {
            TransportService ts = (TransportService)Application.getBootLoader().getBootable(TransportService.class);
            Transport t = ts.getTransport(new URL(url));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.get((OutputStream)bos, (ProgressMonitor)new ConsoleMonitor());
            return bos.toByteArray();
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to fetch image", (Throwable)e);
            throw new ApplicationException(i18n.tr("Download des Captcha-Bildes fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        this.createCaptcha((Container)container);
        container.addInput((Input)this.getSolution());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.getApplyButton());
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("Dialog abgebrochen");
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
        this.getSolution().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String s = (String)CaptchaDialog.this.getSolution().getValue();
                CaptchaDialog.this.getApplyButton().setEnabled(StringUtils.trimToNull((String)s) != null);
            }
        });
        this.getShell().setMinimumSize(this.getShell().computeSize(-1, -1));
    }

    protected Object getData() throws Exception {
        return this.data;
    }

    private void createCaptcha(Container container) {
        GridData labelGrid = new GridData(128);
        labelGrid.verticalAlignment = 1;
        Label label = GUI.getStyleFactory().createLabel(container.getComposite(), 0);
        label.setText(i18n.tr("Captcha"));
        label.setLayoutData((Object)labelGrid);
        final Image image = new Image((Device)GUI.getDisplay(), this.image);
        final Rectangle size = image.getBounds();
        Composite comp = new Composite(container.getComposite(), 2048);
        comp.setBackground(GUI.getDisplay().getSystemColor(1));
        GridData gd = new GridData(1808);
        gd.widthHint = size.width + 2;
        gd.heightHint = size.height + 2;
        comp.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        comp.setLayout((Layout)gl);
        final Canvas captcha = new Canvas(comp, 0);
        captcha.setBackground(GUI.getDisplay().getSystemColor(1));
        captcha.setLayoutData((Object)new GridData(1808));
        captcha.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point area = captcha.getSize();
                e.gc.drawImage(image, (area.x - size.width) / 2, (area.y - size.height) / 2);
            }
        });
    }

    private TextInput getSolution() {
        if (this.solution != null) {
            return this.solution;
        }
        this.solution = new TextInput(null);
        this.solution.setName(i18n.tr("L\u00f6sung"));
        this.solution.setMandatory(true);
        return this.solution;
    }

    private Button getApplyButton() {
        if (this.applyButton != null) {
            return this.applyButton;
        }
        this.applyButton = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CaptchaDialog.this.data = (String)CaptchaDialog.this.getSolution().getValue();
                if (StringUtils.trimToNull((String)CaptchaDialog.this.data) != null) {
                    CaptchaDialog.this.close();
                }
            }
        }, null, true, "ok.png");
        this.applyButton.setEnabled(false);
        return this.applyButton;
    }
}

