/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.input.UmsatzDaysInput;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;

public class CustomRangeDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 500;
    private Calendar cal = Calendar.getInstance();
    private Range.Category category = null;
    private Range.CustomRange range = null;
    private TextInput name = null;
    private UmsatzDaysInput daysPast = null;
    private UmsatzDaysInput daysFuture = null;
    private Button apply = null;

    public CustomRangeDialog(Range.Category category, Range.CustomRange range) {
        super(1);
        this.range = range;
        this.category = category;
        this.setTitle(i18n.tr("Benutzerdefinierter Zeitraum"));
        this.setSize(500, -1);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(i18n.tr("Bitte geben Sie einen Namen f\u00fcr den benutzerdefinierten Zeitraum ein und w\u00e4hlen Sie dann aus, wie weit dieser in die Vergangenheit und Zukunft reichen soll."), true);
        c.addInput((Input)this.getName());
        c.addInput((Input)this.getDaysPast());
        c.addInput((Input)this.getDaysFuture());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.getApply());
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CustomRangeDialog.this.close();
            }
        }, null, false, "window-close.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
    }

    private Button getApply() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                CustomRangeDialog.this.handleStore();
                CustomRangeDialog.this.close();
            }
        }, null, true, "ok.png");
        return this.apply;
    }

    private TextInput getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = new TextInput(this.range.toString());
        this.name.setMandatory(true);
        this.name.setName(i18n.tr("Bezeichnung"));
        this.name.setMaxLength(100);
        this.name.setValue((Object)this.range.toString());
        this.name.addListener(e -> this.getApply().setEnabled(StringUtils.trimToNull((String)((String)this.getName().getValue())) != null));
        return this.name;
    }

    private UmsatzDaysInput getDaysPast() {
        if (this.daysPast != null) {
            return this.daysPast;
        }
        this.daysPast = new MyUmsatzDaysInput(false);
        this.daysPast.setName(i18n.tr("Beginn des Zeitraumes"));
        this.daysPast.setValue(this.range.getDaysPast());
        return this.daysPast;
    }

    private UmsatzDaysInput getDaysFuture() {
        if (this.daysFuture != null) {
            return this.daysFuture;
        }
        this.daysFuture = new MyUmsatzDaysInput(true);
        this.daysFuture.setName(i18n.tr("Ende des Zeitraumes"));
        this.daysFuture.setValue(this.range.getDaysFuture());
        return this.daysFuture;
    }

    protected Object getData() throws Exception {
        return null;
    }

    private void handleStore() {
        try {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Einstellungen gespeichert"), 0));
            this.range.setName((String)this.getName().getValue());
            this.range.setDaysFuture((Integer)this.getDaysFuture().getValue());
            this.range.setDaysPast((Integer)this.getDaysPast().getValue());
            Range.saveCustomRange(this.category, this.range);
        }
        catch (Exception e) {
            Logger.error((String)"error while saving settings", (Throwable)e);
        }
    }

    private class MyUmsatzDaysInput
    extends UmsatzDaysInput {
        private boolean future = false;

        private MyUmsatzDaysInput(boolean future) {
            this.future = future;
            this.setScaling(1, this.getUndefinedMax() - 1, 1, 7);
        }

        @Override
        protected int getUndefinedMax() {
            return 3651;
        }

        public void setComment(String comment) {
            int days = (Integer)this.getValue();
            if (days == 1) {
                super.setComment(this.future ? i18n.tr("morgen") : i18n.tr("gestern"));
                return;
            }
            CustomRangeDialog.this.cal.setTime(DateUtil.startOfDay((Date)new Date()));
            CustomRangeDialog.this.cal.add(5, this.future ? days : -days);
            super.setComment(i18n.tr("{0} {1} Tagen ({2})", new String[]{this.future ? "in" : "vor", Integer.toString(days), HBCI.DATEFORMAT.format(CustomRangeDialog.this.cal.getTime())}));
        }
    }
}

