/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.DBSupport;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;

public class DebugDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 550;
    private static final int WINDOW_HEIGHT = 250;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public DebugDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Datenbank-Informationen"));
        this.setSize(550, 250);
    }

    protected Object getData() throws Exception {
        return null;
    }

    protected void paint(Composite parent) throws Exception {
        HBCIDBService service = (HBCIDBService)Application.getServiceFactory().lookup(HBCI.class, "database");
        DBSupport driver = service.getDriver();
        StringBuffer sb = new StringBuffer();
        sb.append(i18n.tr("JDBC-Treiber: {0}\n", driver.getJdbcDriver()));
        sb.append(i18n.tr("JDBC-URL: {0}\n", driver.getJdbcUrl()));
        sb.append(i18n.tr("JDBC-Username: {0}\n", driver.getJdbcUsername()));
        sb.append(i18n.tr("JDBC-Passwort: {0}\n", driver.getJdbcPassword()));
        SimpleContainer container = new SimpleContainer(parent, true);
        container.addHeadline(i18n.tr("Datenbank-Einstellungen"));
        TextAreaInput text = new TextAreaInput(sb.toString());
        container.addPart((Part)text);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Schlie\u00dfen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                DebugDialog.this.close();
            }
        }, null, true, "window-close.png");
        container.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(550, 250));
    }
}

