/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.internal.action.Program;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.IORegistry;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class ExportDialog
extends AbstractDialog
implements Extendable {
    public static final Settings SETTINGS = new Settings(ExportDialog.class);
    private static final int WINDOW_WIDTH = 550;
    private static DateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Input exporterListe = null;
    private CheckboxInput openFile = null;
    private final Object[] objects;
    private final Class type;
    private boolean exportEnabled = true;
    private Container group = null;

    public ExportDialog(Object[] objects, Class type) {
        super(1);
        this.setTitle(i18n.tr("Daten-Export"));
        this.setSize(550, -1);
        this.objects = objects;
        this.type = type;
    }

    protected void paint(Composite parent) throws Exception {
        this.group = new SimpleContainer(parent);
        this.group.addText(i18n.tr("Bitte w\u00e4hlen Sie das gew\u00fcnschte Dateiformat aus f\u00fcr den Export aus"), true);
        Input formats = this.getExporterList();
        this.group.addInput(formats);
        this.exportEnabled = !(formats instanceof LabelInput);
        CheckboxInput open = this.getOpenFile();
        open.setEnabled(this.exportEnabled);
        this.group.addInput((Input)open);
        ExtensionRegistry.extend((Extendable)this);
        ButtonArea buttons = new ButtonArea();
        Button expBtn = new Button(i18n.tr("Export starten"), x -> this.export(), null, true, "ok.png");
        expBtn.setEnabled(this.exportEnabled);
        buttons.addButton(expBtn);
        buttons.addButton(i18n.tr("Abbrechen"), x -> this.close(), null, false, "process-stop.png");
        this.group.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(550, -1));
    }

    private void export() throws ApplicationException {
        String s;
        ExportFormat exp;
        try {
            exp = (ExportFormat)this.getExporterList().getValue();
        }
        catch (Exception e) {
            Logger.error((String)"error while saving export file", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Starten des Exports"), (Throwable)e);
        }
        if (exp == null || exp.exporter == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Export-Format aus"));
        }
        SETTINGS.setAttribute("lastformat", exp.format.getName());
        FileDialog fd = new FileDialog(GUI.getShell(), 8192);
        fd.setText(i18n.tr("Bitte geben Sie eine Datei ein, in die die Daten exportiert werden sollen."));
        fd.setOverwrite(true);
        String[] se = exp.format.getFileExtensions();
        String ext = se == null ? "" : se[0];
        ext = ext.replaceAll("\\*.", "");
        fd.setFileName(i18n.tr("hibiscus-export-{0}." + ext, DATEFORMAT.format(new Date())));
        String path = SETTINGS.getString("lastdir", System.getProperty("user.home"));
        if (path != null && path.length() > 0) {
            fd.setFilterPath(path);
        }
        if ((s = fd.open()) == null || s.length() == 0) {
            this.close();
            return;
        }
        final File file = new File(s);
        SETTINGS.setAttribute("lastdir", file.getParent());
        final boolean open = (Boolean)this.getOpenFile().getValue();
        SETTINGS.setAttribute("open", open);
        this.close();
        final Exporter exporter = exp.exporter;
        final IOFormat format = exp.format;
        BackgroundTask t = new BackgroundTask(){

            public void run(ProgressMonitor monitor) throws ApplicationException {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                    exporter.doExport(ExportDialog.this.objects, format, os, monitor);
                    monitor.setPercentComplete(100);
                    monitor.setStatus(4);
                    GUI.getStatusBar().setSuccessText(i18n.tr("Daten exportiert nach {0}", s));
                    monitor.setStatusText(i18n.tr("Daten exportiert nach {0}", s));
                    if (open) {
                        GUI.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    new Program().handleAction((Object)file);
                                }
                                catch (ApplicationException ae) {
                                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getLocalizedMessage(), 1));
                                }
                            }
                        });
                    }
                }
                catch (ApplicationException ae) {
                    monitor.setStatus(3);
                    monitor.setStatusText(ae.getMessage());
                    GUI.getStatusBar().setErrorText(ae.getMessage());
                    throw ae;
                }
                catch (OperationCanceledException oce) {
                    Logger.info((String)("operation cancelled: " + oce.getMessage()));
                    monitor.setStatus(5);
                    monitor.setStatusText(i18n.tr("Export abgebrochen"));
                }
                catch (Exception e) {
                    monitor.setStatus(3);
                    Logger.error((String)("error while writing objects to " + s), (Throwable)e);
                    ApplicationException ae = new ApplicationException(i18n.tr("Fehler beim Exportieren der Daten in {0}", s), (Throwable)e);
                    monitor.setStatusText(ae.getMessage());
                    GUI.getStatusBar().setErrorText(ae.getMessage());
                    throw ae;
                }
            }

            public void interrupt() {
            }

            public boolean isInterrupted() {
                return false;
            }
        };
        Application.getController().start(t);
    }

    private CheckboxInput getOpenFile() {
        if (this.openFile == null) {
            this.openFile = new CheckboxInput(SETTINGS.getBoolean("open", true));
            this.openFile.setName(i18n.tr("Datei nach dem Export \u00f6ffnen"));
        }
        return this.openFile;
    }

    public Input getExporterList() {
        if (this.exporterListe != null) {
            return this.exporterListe;
        }
        Exporter[] exporters = IORegistry.getExporters();
        ArrayList<ExportFormat> supportedExportFormats = new ArrayList<ExportFormat>();
        String lastFormat = SETTINGS.getString("lastformat", null);
        ExportFormat selected = null;
        Exporter[] exporterArray = exporters;
        int n = exporters.length;
        int n2 = 0;
        while (n2 < n) {
            Exporter exp = exporterArray[n2];
            if (exp != null) {
                IOFormat[] formats = exp.getIOFormats(this.type);
                if (formats == null || formats.length == 0) {
                    Logger.debug((String)("Exporter " + exp.getName() + " provides no export formats for " + this.type + ". Skipping"));
                } else {
                    IOFormat[] iOFormatArray = formats;
                    int n3 = formats.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IOFormat format = iOFormatArray[n4];
                        ExportFormat e = new ExportFormat(exp, format);
                        supportedExportFormats.add(e);
                        if (lastFormat != null && lastFormat.equals(e.format.getName())) {
                            selected = e;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        if (supportedExportFormats.isEmpty()) {
            this.exporterListe = new LabelInput(i18n.tr("Keine Export-Filter verf\u00fcgbar"));
        } else {
            Collections.sort(supportedExportFormats);
            this.exporterListe = new SelectInput(supportedExportFormats, selected);
        }
        this.exporterListe.setName(i18n.tr("Verf\u00fcgbare Formate"));
        return this.exporterListe;
    }

    protected Object getData() throws Exception {
        return null;
    }

    public String getExtendableID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Container getContainer() {
        return this.group;
    }

    public Class getType() {
        return this.type;
    }

    public static class ExportFormat
    implements GenericObject,
    Comparable<ExportFormat> {
        private final Exporter exporter;
        private final IOFormat format;

        private ExportFormat(Exporter exporter, IOFormat format) {
            this.exporter = exporter;
            this.format = format;
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return this.format.getName();
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name"};
        }

        public String getID() throws RemoteException {
            return String.valueOf(this.exporter.getClass().getName()) + "#" + this.format.getName();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            if (arg0 == null) {
                return false;
            }
            return this.getID().equals(arg0.getID());
        }

        public Exporter getExporter() {
            return this.exporter;
        }

        @Override
        public int compareTo(ExportFormat other) {
            if (other == null) {
                return -1;
            }
            try {
                return this.format.getName().compareTo(other.format.getName());
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

