/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.FileInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.NotificationPanel;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCITraceMessage;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCITraceMessageConsumer;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class HBCITraceDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = new Settings(HBCITraceDialog.class);
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private NotificationPanel panel = null;
    private Button apply = null;
    private KontoInput auswahl = null;
    private FileInput file = null;

    public HBCITraceDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("HBCI-Protokoll speichern..."));
        this.setSize(400, -1);
    }

    protected void paint(Composite parent) throws Exception {
        this.panel = new NotificationPanel();
        this.panel.paint(parent);
        this.panel.setText(NotificationPanel.Type.INFO, i18n.tr("W\u00e4hlen Sie ein Konto aus, um nur dessen Protokoll zu speichern."));
        SimpleContainer group = new SimpleContainer(parent);
        group.addHeadline(i18n.tr("Wichtiger Hinweis"));
        group.addText(i18n.tr("Das HBCI-Protokoll kann streng vertrauliche Informationen wie z.Bsp. Ihre PIN enthalten. Ver\u00f6ffentlichen Sie das Protokoll daher niemals in einem Forum bzw. versenden Sie es nicht per E-Mail. \u00d6ffnen Sie die Datei ggf. in einem Texteditor und schw\u00e4rzen Sie darin enthaltene sensible Daten.\n"), true, Color.ERROR);
        group.addText(i18n.tr("Klicken Sie nach Auswahl des Kontos bitte auf \"Speichern\", um die HBCI-Protokolle des Kontos in der angegebenen Datei zu speichern."), true);
        group.addInput((Input)this.getKontoAuswahl());
        group.addInput((Input)this.getFile());
        ButtonArea b = new ButtonArea();
        b.addButton(this.getApplyButton());
        b.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(b);
        this.getShell().setMinimumSize(this.getShell().computeSize(400, -1));
        this.getKontoAuswahl().focus();
    }

    protected Object getData() throws Exception {
        return null;
    }

    private KontoInput getKontoAuswahl() throws RemoteException {
        if (this.auswahl != null) {
            return this.auswahl;
        }
        this.auswahl = new KontoInput(null, KontoFilter.ONLINE);
        this.auswahl.setSupportGroups(false);
        this.auswahl.setPleaseChoose("<" + i18n.tr("ohne Bezug zu einem Konto") + ">");
        this.auswahl.setComment(null);
        return this.auswahl;
    }

    private FileInput getFile() {
        if (this.file != null) {
            return this.file;
        }
        String dir = settings.getString("lastdir", System.getProperty("user.home"));
        String file = "hbcitrace_" + DF.format(new Date()) + ".log";
        this.file = new FileInput(new File(dir, file).getPath(), true){

            protected void customize(FileDialog fd) {
                fd.setOverwrite(true);
            }
        };
        this.file.setMandatory(true);
        this.file.setName(i18n.tr("Protokoll speichern in"));
        return this.file;
    }

    private boolean export() {
        try {
            String file = (String)this.getFile().getValue();
            if (StringUtils.isEmpty((String)file)) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie eine Datei aus."));
            }
            File f = new File(file);
            File dir = f.getParentFile();
            if (!dir.canWrite()) {
                throw new ApplicationException(i18n.tr("Keine Schreibrechte in diesem Ordner."));
            }
            settings.setAttribute("lastdir", dir.getPath());
            Konto konto = (Konto)this.getKontoAuswahl().getValue();
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            HBCITraceMessageConsumer tracer = (HBCITraceMessageConsumer)service.get(HBCITraceMessageConsumer.class);
            List<HBCITraceMessage> messages = tracer.getTrace(konto != null ? konto.getID() : null);
            if (messages == null || messages.size() == 0) {
                if (konto != null) {
                    throw new ApplicationException(i18n.tr("Keine HBCI-Protokolle zu diesem Konto vorhanden"));
                }
                throw new ApplicationException(i18n.tr("Keine HBCI-Protokolle ohne Konto-Bezug vorhanden"));
            }
            BufferedOutputStream os = null;
            String wrap = System.getProperty("line.separator", "\n");
            try {
                os = new BufferedOutputStream(new FileOutputStream(f));
                for (HBCITraceMessage m : messages) {
                    ((OutputStream)os).write(m.getData().getBytes());
                    ((OutputStream)os).write(wrap.getBytes());
                }
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("HBCI-Protokoll gespeichert"), 0));
            return true;
        }
        catch (ApplicationException ae) {
            this.panel.setText(NotificationPanel.Type.ERROR, ae.getMessage());
        }
        catch (OperationCanceledException ae) {
        }
        catch (Exception e) {
            this.panel.setText(NotificationPanel.Type.ERROR, i18n.tr("Fehler: {0}", e.getMessage()));
        }
        return false;
    }

    private Button getApplyButton() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (HBCITraceDialog.this.export()) {
                    HBCITraceDialog.this.close();
                }
            }
        }, null, true, "document-save.png");
        return this.apply;
    }
}

