/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.IBANCode;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class IbanCalcDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 500;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private TextInput konto = null;
    private TextInput blz = null;
    private TextInput iban = null;
    private TextInput bic = null;
    private LabelInput msg = null;
    private Listener listener = new CalcListener();

    public IbanCalcDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("IBAN-Rechner"));
        this.setSize(500, -1);
    }

    protected boolean isModeless() {
        return true;
    }

    protected Object getData() throws Exception {
        return null;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer container1 = new SimpleContainer(parent);
        container1.addHeadline(i18n.tr("Wichtiger Hinweis"));
        container1.addText(i18n.tr("F\u00fcr einige Banken gelten Sonderregeln f\u00fcr die IBAN-Berechnung, die von Hibiscus u.U. nicht unterst\u00fctzt werden.\n\nDaher gilt: Bitte verifizieren Sie die errechnete IBAN."), true);
        SimpleContainer container2 = new SimpleContainer(parent);
        container2.addHeadline(i18n.tr("Nationale Bankverbindung"));
        container2.addInput((Input)this.getBlz());
        container2.addInput((Input)this.getKonto());
        container2.addHeadline(i18n.tr("Zugeh\u00f6rige SEPA-Bankverbindung"));
        container2.addInput((Input)this.getBic());
        container2.addInput((Input)this.getIban());
        container2.addInput((Input)this.getMessage());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Berechnen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                IbanCalcDialog.this.calc();
            }
        }, null, true, "accessories-calculator.png");
        buttons.addButton(i18n.tr("Schlie\u00dfen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                IbanCalcDialog.this.close();
            }
        }, null, false, "window-close.png");
        container2.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
    }

    private TextInput getKonto() {
        if (this.konto != null) {
            return this.konto;
        }
        this.konto = new TextInput("", HBCIProperties.HBCI_KTO_MAXLENGTH_SOFT);
        this.konto.setName(i18n.tr("Kontonummer"));
        this.konto.setComment("");
        this.konto.setValidChars(String.valueOf(HBCIProperties.HBCI_KTO_VALIDCHARS) + " ");
        this.konto.setMandatory(true);
        this.konto.addListener(this.listener);
        this.konto.addListener(new Listener(){

            public void handleEvent(Event event) {
                String s = (String)IbanCalcDialog.this.konto.getValue();
                if (s == null || s.length() == 0) {
                    return;
                }
                if (s.indexOf(" ") != -1) {
                    IbanCalcDialog.this.konto.setValue((Object)s.replaceAll(" ", ""));
                }
            }
        });
        return this.konto;
    }

    private LabelInput getMessage() {
        if (this.msg != null) {
            return this.msg;
        }
        this.msg = new LabelInput("");
        this.msg.setColor(Color.ERROR);
        return this.msg;
    }

    private TextInput getBlz() {
        if (this.blz != null) {
            return this.blz;
        }
        this.blz = new BLZInput("");
        this.blz.setMandatory(true);
        this.blz.addListener(this.listener);
        return this.blz;
    }

    private TextInput getIban() {
        if (this.iban != null) {
            return this.iban;
        }
        this.iban = new TextInput("");
        this.iban.setName(i18n.tr("IBAN"));
        return this.iban;
    }

    private TextInput getBic() {
        if (this.bic != null) {
            return this.bic;
        }
        this.bic = new TextInput("");
        this.bic.setName(i18n.tr("BIC"));
        return this.bic;
    }

    private void calc() {
        String iban = "";
        String bic = "";
        String kto = StringUtils.trimToEmpty((String)((String)this.getKonto().getValue()));
        String blz = StringUtils.trimToEmpty((String)((String)this.getBlz().getValue()));
        if (kto.length() == 0) {
            this.getKonto().setComment(i18n.tr("Bitte Kontonummer eingeben"));
        }
        if (blz.length() == 0) {
            this.getBlz().setComment(i18n.tr("Bitte BLZ eingeben"));
        }
        if (blz.length() != HBCIProperties.HBCI_BLZ_LENGTH) {
            this.getBlz().setComment(i18n.tr("BLZ ung\u00fcltig"));
        }
        if (kto.length() > 0 && blz.length() == HBCIProperties.HBCI_BLZ_LENGTH) {
            boolean ok = HBCIProperties.checkAccountCRC(blz, kto);
            this.getKonto().setComment(i18n.tr(ok ? "Konto OK" : "BLZ/Kto ung\u00fcltig, bitte pr\u00fcfen"));
            if (ok) {
                LabelInput msg = this.getMessage();
                try {
                    IBAN newIban = HBCIProperties.getIBAN(blz, kto);
                    iban = newIban.getIBAN();
                    bic = newIban.getBIC();
                    IBANCode code = newIban.getCode();
                    if (code != null && code == IBANCode.PRUEFZIFFERNMETHODEFEHLT) {
                        msg.setColor(Color.COMMENT);
                        msg.setValue((Object)i18n.tr("IBAN ermittelt, Pr\u00fcfziffer jedoch nicht kontrolliert"));
                    } else {
                        msg.setColor(Color.SUCCESS);
                        msg.setValue((Object)i18n.tr("Pr\u00fcfziffer korrekt"));
                    }
                }
                catch (ApplicationException ae) {
                    msg.setColor(Color.ERROR);
                    msg.setValue((Object)ae.getMessage());
                }
                catch (Exception e) {
                    Logger.error((String)"error while calculating IBAN/BIC", (Throwable)e);
                    msg.setColor(Color.ERROR);
                    msg.setValue((Object)i18n.tr("IBAN-Berechnung fehlgeschlagen"));
                }
            }
        }
        this.getIban().setValue((Object)iban);
        this.getBic().setValue((Object)bic);
    }

    private class CalcListener
    implements Listener {
        private CalcListener() {
        }

        public void handleEvent(Event event) {
            String kto = StringUtils.trimToNull((String)((String)IbanCalcDialog.this.getKonto().getValue()));
            String blz = StringUtils.trimToNull((String)((String)IbanCalcDialog.this.getBlz().getValue()));
            if (kto != null && blz != null) {
                IbanCalcDialog.this.calc();
            }
        }
    }
}

