/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.IORegistry;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class ImportDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 420;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Input importerListe = null;
    private GenericObject context = null;
    private Class type = null;
    private Settings settings = null;
    private BackgroundTask task = null;

    public ImportDialog(GenericObject context, Class type) {
        super(1);
        this.context = context;
        this.type = type;
        this.setTitle(i18n.tr("Daten-Import"));
        this.setSize(420, -1);
        this.settings = new Settings(((Object)((Object)this)).getClass());
        this.settings.setStoreWhenRead(true);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie das gew\u00fcnschte Dateiformat f\u00fcr den Import aus"), true);
        Input formats = this.getImporterList();
        group.addLabelPair(i18n.tr("Verf\u00fcgbare Formate:"), formats);
        ButtonArea buttons = new ButtonArea();
        Button button = new Button(i18n.tr("Import starten"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                ImportDialog.this.doImport();
            }
        }, null, true, "ok.png");
        button.setEnabled(!(formats instanceof LabelInput));
        buttons.addButton(button);
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(420, -1));
    }

    private void doImport() throws ApplicationException {
        String s;
        Imp imp = null;
        try {
            imp = (Imp)this.getImporterList().getValue();
        }
        catch (Exception e) {
            Logger.error((String)"error while saving import file", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Starten des Imports"), (Throwable)e);
        }
        if (imp == null || imp.importer == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Import-Format aus"));
        }
        this.settings.setAttribute("lastformat", imp.format.getName());
        FileDialog fd = new FileDialog(GUI.getShell(), 4096);
        fd.setText(i18n.tr("Bitte w\u00e4hlen Sie die Datei aus, welche f\u00fcr den Import verwendet werden soll."));
        fd.setFilterNames(imp.format.getFileExtensions());
        String path = this.settings.getString("lastdir", System.getProperty("user.home"));
        if (path != null && path.length() > 0) {
            fd.setFilterPath(path);
        }
        if ((s = fd.open()) == null || s.length() == 0) {
            this.close();
            return;
        }
        final File file = new File(s);
        if (!file.exists() || !file.isFile()) {
            throw new ApplicationException(i18n.tr("Datei existiert nicht oder ist nicht lesbar"));
        }
        this.settings.setAttribute("lastdir", file.getParent());
        this.close();
        final Importer importer = imp.importer;
        final IOFormat format = imp.format;
        this.task = new BackgroundTask(){
            private boolean interrupted = false;

            public void run(ProgressMonitor monitor) throws ApplicationException {
                try {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                    importer.doImport(ImportDialog.this.context, format, is, monitor, ImportDialog.this.task);
                    monitor.setPercentComplete(100);
                    monitor.setStatus(4);
                    GUI.getStatusBar().setSuccessText(i18n.tr("Daten importiert aus {0}", s));
                    GUI.getCurrentView().reload();
                }
                catch (OperationCanceledException oce) {
                    throw oce;
                }
                catch (ApplicationException ae) {
                    GUI.getStatusBar().setErrorText(ae.getMessage());
                    throw ae;
                }
                catch (Exception e) {
                    monitor.setStatus(3);
                    Logger.error((String)("error while reading objects from " + s), (Throwable)e);
                    ApplicationException ae = new ApplicationException(i18n.tr("Fehler beim Importieren der Daten aus {0}", s), (Throwable)e);
                    monitor.setStatusText(ae.getMessage());
                    GUI.getStatusBar().setErrorText(ae.getMessage());
                    throw ae;
                }
            }

            public void interrupt() {
                this.interrupted = true;
            }

            public boolean isInterrupted() {
                return this.interrupted;
            }
        };
        Application.getController().start(this.task);
    }

    private Input getImporterList() throws Exception {
        if (this.importerListe != null) {
            return this.importerListe;
        }
        Importer[] importers = IORegistry.getImporters();
        int size = 0;
        ArrayList<Imp> l = new ArrayList<Imp>();
        String lastFormat = this.settings.getString("lastformat", null);
        Imp selected = null;
        int i = 0;
        while (i < importers.length) {
            Importer imp = importers[i];
            if (imp != null) {
                IOFormat[] formats = imp.getIOFormats(this.type);
                if (formats == null || formats.length == 0) {
                    Logger.debug((String)("importer " + imp.getName() + " provides no import formats for " + this.type.getName() + ", skipping"));
                } else {
                    int j = 0;
                    while (j < formats.length) {
                        ++size;
                        Imp im = new Imp(imp, formats[j]);
                        l.add(im);
                        String lf = im.format.getName();
                        if (lastFormat != null && lf != null && lf.equals(lastFormat)) {
                            selected = im;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (size == 0) {
            this.importerListe = new LabelInput(i18n.tr("Keine Import-Filter verf\u00fcgbar"));
            return this.importerListe;
        }
        Collections.sort(l);
        GenericObject[] imp = l.toArray(new Imp[size]);
        this.importerListe = new SelectInput(PseudoIterator.fromArray((GenericObject[])imp), selected);
        return this.importerListe;
    }

    protected Object getData() throws Exception {
        return null;
    }

    private class Imp
    implements GenericObject,
    Comparable {
        private Importer importer = null;
        private IOFormat format = null;

        private Imp(Importer importer, IOFormat format) {
            this.importer = importer;
            this.format = format;
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return this.format.getName();
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name"};
        }

        public String getID() throws RemoteException {
            return String.valueOf(this.importer.getClass().getName()) + "#" + this.format.getClass().getName();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            if (arg0 == null) {
                return false;
            }
            return this.getID().equals(arg0.getID());
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof Imp)) {
                return -1;
            }
            try {
                return this.format.getName().compareTo(((Imp)o).format.getName());
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

