/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class KontoAuswahlDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 500;
    private String text = null;
    private Konto choosen = null;
    private Konto preselected = null;
    private KontoFilter filter = null;
    private Button apply = null;
    private KontoInput auswahl = null;
    private LabelInput institut = null;
    private LabelInput name = null;
    private LabelInput saldo = null;

    public KontoAuswahlDialog(int position) {
        this(null, position);
    }

    public KontoAuswahlDialog(Konto preselected, int position) {
        this(preselected, null, position);
    }

    public KontoAuswahlDialog(Konto preselected, KontoFilter filter, int position) {
        super(position);
        this.preselected = preselected;
        this.filter = filter;
        this.setTitle(i18n.tr("Konto-Auswahl"));
        this.setSize(500, -1);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(this.text != null && this.text.length() > 0 ? this.text : i18n.tr("Bitte w\u00e4hlen Sie das gew\u00fcnschte Konto aus."), true);
        group.addInput((Input)this.getKontoAuswahl());
        group.addInput((Input)this.getInstitut());
        group.addInput((Input)this.getName());
        group.addInput((Input)this.getSaldo());
        ButtonArea b = new ButtonArea();
        b.addButton(this.getApplyButton());
        b.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoAuswahlDialog.this.choosen = null;
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(b);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
        this.getKontoAuswahl().focus();
    }

    protected Object getData() throws Exception {
        return this.choosen;
    }

    private KontoInput getKontoAuswahl() throws RemoteException {
        if (this.auswahl != null) {
            return this.auswahl;
        }
        this.auswahl = new KontoInput(this.preselected, this.filter);
        this.auswahl.setComment(null);
        this.auswahl.addListener(new Listener(){

            public void handleEvent(Event event) {
                KontoAuswahlDialog.this.preselected = (Konto)KontoAuswahlDialog.this.auswahl.getValue();
                KontoAuswahlDialog.this.getApplyButton().setEnabled(KontoAuswahlDialog.this.preselected != null);
                try {
                    KontoAuswahlDialog.this.updateInstitute();
                    KontoAuswahlDialog.this.updateName();
                    KontoAuswahlDialog.this.updateSaldo();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to update account information", (Throwable)e);
                }
            }
        });
        return this.auswahl;
    }

    private LabelInput getInstitut() throws RemoteException {
        if (this.institut == null) {
            this.institut = new LabelInput("");
            this.institut.setName(i18n.tr("Institut"));
            this.updateInstitute();
        }
        return this.institut;
    }

    private void updateInstitute() throws RemoteException {
        String name;
        this.getInstitut().setValue((Object)"");
        if (this.preselected != null && (name = HBCIProperties.getNameForBank(this.preselected.getBLZ())) != null && name.length() > 0) {
            this.getInstitut().setValue((Object)name);
        }
    }

    private LabelInput getName() throws RemoteException {
        if (this.name == null) {
            this.name = new LabelInput("");
            this.name.setName(i18n.tr("Konto"));
            this.updateName();
        }
        return this.name;
    }

    private void updateName() throws RemoteException {
        this.getName().setValue((Object)"");
        this.getName().setComment("");
        if (this.preselected != null) {
            String owner;
            String name = this.preselected.getBezeichnung();
            if (name != null && name.length() > 0) {
                this.getName().setValue((Object)name);
            }
            if ((owner = this.preselected.getName()) != null && owner.length() > 0) {
                this.getName().setComment(owner);
            }
        }
    }

    private LabelInput getSaldo() throws RemoteException {
        if (this.saldo == null) {
            this.saldo = new LabelInput("");
            this.saldo.setName("Saldo");
            this.updateSaldo();
        }
        return this.saldo;
    }

    private void updateSaldo() throws RemoteException {
        this.getSaldo().setValue((Object)"");
        this.getSaldo().setComment("");
        if (this.preselected != null) {
            Date date = this.preselected.getSaldoDatum();
            if (date != null) {
                double saldo = this.preselected.getSaldo();
                this.getSaldo().setColor(ColorUtil.getColor(saldo, Color.ERROR, Color.SUCCESS, Color.FOREGROUND));
                String curr = this.preselected.getWaehrung();
                if (curr == null || curr.length() == 0) {
                    curr = HBCIProperties.CURRENCY_DEFAULT_DE;
                }
                this.getSaldo().setValue((Object)(String.valueOf(HBCI.DECIMALFORMAT.format(saldo)) + " " + curr));
                this.getSaldo().setComment(i18n.tr("aktualisiert am {0}", HBCI.LONGDATEFORMAT.format(date)));
            } else {
                this.getSaldo().setColor(Color.COMMENT);
                this.getSaldo().setValue((Object)i18n.tr("Kein Saldo verf\u00fcgbar"));
            }
        }
    }

    public Button getApplyButton() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoAuswahlDialog.this.choosen = KontoAuswahlDialog.this.preselected;
                KontoAuswahlDialog.this.close();
            }
        }, null, true, "ok.png");
        this.apply.setEnabled(this.preselected != null);
        return this.apply;
    }

    public void setText(String text) {
        this.text = text;
    }
}

