/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class KontoDeleteDialog
extends AbstractDialog<Boolean> {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 400;
    private Konto konto = null;
    private TablePart deps = null;
    private CheckboxInput check = null;
    private Button apply = null;
    private Boolean choice = null;

    public KontoDeleteDialog(Konto k) {
        super(1);
        this.konto = k;
        this.setTitle(i18n.tr("Konto l\u00f6schen"));
        this.setSize(800, 400);
        this.setSideImage(SWTUtil.getImage((String)"dialog-warning-large.png"));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent, true);
        c.addHeadline(i18n.tr("Warnung"));
        c.addText(String.valueOf(i18n.tr("Wollen Sie das Konto wirklich l\u00f6schen?\nHierbei werden auch alle Daten gel\u00f6scht, die diesem Konto zugeordnet sind.")) + "\n", true);
        c.addPart((Part)this.getDependencies());
        c.addInput((Input)this.getCheck());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.getApply());
        buttons.addButton((Button)new Cancel());
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(800, 400));
    }

    private CheckboxInput getCheck() {
        if (this.check != null) {
            return this.check;
        }
        this.check = new CheckboxInput(false);
        this.check.setName(i18n.tr("Konto und alle zugeordneten Daten l\u00f6schen"));
        this.check.addListener(new Listener(){

            public void handleEvent(Event event) {
                KontoDeleteDialog.this.getApply().setEnabled(((Boolean)KontoDeleteDialog.this.getCheck().getValue()).booleanValue());
            }
        });
        return this.check;
    }

    private Button getApply() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("Jetzt l\u00f6schen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoDeleteDialog.this.choice = Boolean.TRUE;
                KontoDeleteDialog.this.close();
            }
        }, null, false, "user-trash-full.png");
        this.apply.setEnabled(false);
        return this.apply;
    }

    private TablePart getDependencies() throws RemoteException {
        if (this.deps != null) {
            return this.deps;
        }
        this.deps = new TablePart(null);
        this.deps.removeFeature(FeatureSummary.class);
        this.deps.addColumn(i18n.tr("Art der zugeordneten Daten"), "name");
        this.deps.addColumn(i18n.tr("Anzahl"), "size", null, false, 131072);
        this.deps.addColumn(i18n.tr("Bemerkung"), "comment");
        new Thread(){

            @Override
            public void run() {
                GUI.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BusyIndicator.showWhile((Display)GUI.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean added = false;
                                    added |= KontoDeleteDialog.this.add(i18n.tr("Ums\u00e4tze"), ((this).this).KontoDeleteDialog.this.konto.getNumUmsaetze(), null);
                                    added |= KontoDeleteDialog.this.add(i18n.tr("Umsatzkategorien"), ((this).this).KontoDeleteDialog.this.konto.getUmsatzTypen().size(), i18n.tr("Kategorien werden nicht gel\u00f6scht sondern nur die Verbindung zum Konto aufgehoben"));
                                    added |= KontoDeleteDialog.this.add(i18n.tr("Elektr. Kontoausz\u00fcge"), ((this).this).KontoDeleteDialog.this.konto.getKontoauszuege().size(), i18n.tr("Die PDF-Dateien werden nicht gel\u00f6scht"));
                                    added |= KontoDeleteDialog.this.add(i18n.tr("\u00dcberweisungen"), ((this).this).KontoDeleteDialog.this.konto.getAuslandsUeberweisungen().size(), i18n.tr("Gesendete Termin\u00fcberweisungen werden nicht bei der Bank gel\u00f6scht"));
                                    added |= KontoDeleteDialog.this.add(i18n.tr("Dauerauftr\u00e4ge"), ((this).this).KontoDeleteDialog.this.konto.getDauerauftraege().size(), i18n.tr("Auftr\u00e4ge werden nicht bei der Bank gel\u00f6scht"));
                                    added |= KontoDeleteDialog.this.add(i18n.tr("Lastschriften"), ((this).this).KontoDeleteDialog.this.konto.getSepaLastschriften().size(), null);
                                    added |= KontoDeleteDialog.this.add(i18n.tr("Sammel\u00fcberweisungen"), ((this).this).KontoDeleteDialog.this.konto.getSepaSammelUeberweisungen().size(), null);
                                    if (!(added |= KontoDeleteDialog.this.add(i18n.tr("Sammellastschriften"), ((this).this).KontoDeleteDialog.this.konto.getSepaSammelLastschriften().size(), null))) {
                                        KontoDeleteDialog.this.getDependencies().addItem((Object)new Dep("-", 0, i18n.tr("Keine weiteren zugeordneten Daten")));
                                        KontoDeleteDialog.this.getCheck().setName(i18n.tr("Konto l\u00f6schen"));
                                    }
                                }
                                catch (RemoteException re) {
                                    Logger.error((String)"unable to add data", (Throwable)re);
                                }
                            }
                        });
                    }
                });
            }
        }.start();
        return this.deps;
    }

    private boolean add(String name, int size, String comment) throws RemoteException {
        if (size == 0) {
            return false;
        }
        this.getDependencies().addItem((Object)new Dep(name, size, comment));
        return true;
    }

    protected Boolean getData() throws Exception {
        return this.choice;
    }

    public class Dep {
        private String name = null;
        private int size = 0;
        private String comment = null;

        private Dep(String name, int size, String comment) {
            this.name = name;
            this.size = size;
            this.comment = comment;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

