/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.NotificationPanel;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.forecast.ForecastCreator;
import de.willuhn.jameica.hbci.forecast.SaldoLimit;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.UmsatzDaysInput;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class KontoLimitsDialog
extends AbstractDialog {
    private static final Settings settings = new Settings(KontoLimitsDialog.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 500;
    private Konto konto = null;
    private SaldoLimit upper = null;
    private SaldoLimit lower = null;
    private KontoInput kontoAuswahl = null;
    private NotificationPanel hinweise = null;
    private Button apply = null;
    private CheckboxInput upperEnabled = null;
    private CheckboxInput lowerEnabled = null;
    private CheckboxInput upperNotify = null;
    private CheckboxInput lowerNotify = null;
    private DecimalInput upperValue = null;
    private DecimalInput lowerValue = null;
    private UmsatzDaysInput upperDays = null;
    private UmsatzDaysInput lowerDays = null;
    private Listener reloadListener = new ReloadListener();
    private Listener statusListener = new StatusListener();
    private Calendar cal = Calendar.getInstance();

    public KontoLimitsDialog(Konto konto) {
        super(1);
        this.konto = konto;
        this.setTitle(i18n.tr("Konto-Limits konfigurieren"));
        this.setSize(settings.getInt("window.width", 500), settings.getInt("window.height", -1));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(i18n.tr("Nach Auswahl des Kontos k\u00f6nnen Sie ein oberes bzw. unteres Limit f\u00fcr den Saldo festlegen. Sobald dieser den Wert innerhalb der angegebenen Tage \u00fcber- bzw. unterschreitet, erhalten Sie eine Benachrichtigung."), true);
        c.addInput((Input)this.getKontoAuswahl());
        c.addHeadline(SaldoLimit.Type.UPPER.getDescription());
        c.addInput((Input)this.getUpperEnabled());
        c.addInput((Input)this.getUpperValue());
        c.addInput((Input)this.getUpperDays());
        c.addInput((Input)this.getUpperNotify());
        c.addHeadline(SaldoLimit.Type.LOWER.getDescription());
        c.addInput((Input)this.getLowerEnabled());
        c.addInput((Input)this.getLowerValue());
        c.addInput((Input)this.getLowerDays());
        c.addInput((Input)this.getLowerNotify());
        c.addPart((Part)this.getHinweise());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.getApply());
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoLimitsDialog.this.close();
            }
        }, null, false, "window-close.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell shell = KontoLimitsDialog.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                Point size = shell.getSize();
                Logger.debug((String)("saving window size: " + size.x + "x" + size.y));
                settings.setAttribute("window.width", size.x);
                settings.setAttribute("window.height", size.y);
            }
        });
    }

    private Button getApply() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (KontoLimitsDialog.this.handleStore()) {
                    KontoLimitsDialog.this.close();
                }
            }
        }, null, true, "ok.png");
        return this.apply;
    }

    public KontoInput getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(this.konto, KontoFilter.ACTIVE);
        this.kontoAuswahl.setSupportGroups(false);
        this.kontoAuswahl.setComment(null);
        this.kontoAuswahl.addListener(this.reloadListener);
        this.reloadListener.handleEvent(null);
        return this.kontoAuswahl;
    }

    private CheckboxInput getLowerEnabled() {
        if (this.lowerEnabled != null) {
            return this.lowerEnabled;
        }
        this.lowerEnabled = new CheckboxInput(false);
        this.lowerEnabled.setName(i18n.tr("Limit aktiviert"));
        this.lowerEnabled.addListener(this.statusListener);
        return this.lowerEnabled;
    }

    private CheckboxInput getUpperEnabled() {
        if (this.upperEnabled != null) {
            return this.upperEnabled;
        }
        this.upperEnabled = new CheckboxInput(false);
        this.upperEnabled.setName(i18n.tr("Limit aktiviert"));
        this.upperEnabled.addListener(this.statusListener);
        return this.upperEnabled;
    }

    private CheckboxInput getLowerNotify() {
        if (this.lowerNotify != null) {
            return this.lowerNotify;
        }
        this.lowerNotify = new CheckboxInput(false);
        this.lowerNotify.setName(i18n.tr("Benachrichtigen, wenn Limit erreicht wird"));
        return this.lowerNotify;
    }

    private CheckboxInput getUpperNotify() {
        if (this.upperNotify != null) {
            return this.upperNotify;
        }
        this.upperNotify = new CheckboxInput(false);
        this.upperNotify.setName(i18n.tr("Benachrichtigen, wenn Limit erreicht wird"));
        return this.upperNotify;
    }

    private DecimalInput getLowerValue() {
        if (this.lowerValue != null) {
            return this.lowerValue;
        }
        this.lowerValue = new DecimalInput(HBCI.DECIMALFORMAT);
        this.lowerValue.setMandatory(true);
        this.lowerValue.setName(i18n.tr("Mindestsaldo"));
        this.lowerValue.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        this.lowerValue.addListener(this.statusListener);
        return this.lowerValue;
    }

    private DecimalInput getUpperValue() {
        if (this.upperValue != null) {
            return this.upperValue;
        }
        this.upperValue = new DecimalInput(HBCI.DECIMALFORMAT);
        this.upperValue.setMandatory(true);
        this.upperValue.setName(i18n.tr("H\u00f6chstsaldo"));
        this.upperValue.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        this.upperValue.addListener(this.statusListener);
        return this.upperValue;
    }

    private UmsatzDaysInput getLowerDays() {
        if (this.lowerDays != null) {
            return this.lowerDays;
        }
        this.lowerDays = new MyUmsatzDaysInput();
        this.lowerDays.setMandatory(true);
        this.lowerDays.setRememberSelection("limit.lower");
        this.lowerDays.setName(i18n.tr("Erreicht"));
        return this.lowerDays;
    }

    private UmsatzDaysInput getUpperDays() {
        if (this.upperDays != null) {
            return this.upperDays;
        }
        this.upperDays = new MyUmsatzDaysInput();
        this.upperDays.setMandatory(true);
        this.upperDays.setRememberSelection("limit.upper");
        this.upperDays.setName(i18n.tr("Erreicht"));
        return this.upperDays;
    }

    private NotificationPanel getHinweise() {
        if (this.hinweise != null) {
            return this.hinweise;
        }
        this.hinweise = new NotificationPanel();
        return this.hinweise;
    }

    protected Object getData() throws Exception {
        return null;
    }

    private boolean handleStore() {
        Double vl;
        Double vu;
        Boolean el;
        Boolean eu;
        block5: {
            block4: {
                try {
                    Konto k = (Konto)this.getKontoAuswahl().getValue();
                    if (k != null) break block4;
                    this.getHinweise().setText(NotificationPanel.Type.INFO, i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
                    return false;
                }
                catch (Exception e) {
                    Logger.error((String)"error while saving settings", (Throwable)e);
                    this.getHinweise().setText(NotificationPanel.Type.ERROR, e.getMessage());
                    return false;
                }
            }
            eu = (Boolean)this.getUpperEnabled().getValue();
            el = (Boolean)this.getLowerEnabled().getValue();
            vu = (Double)this.getUpperValue().getValue();
            vl = (Double)this.getLowerValue().getValue();
            if (!eu.booleanValue() || !el.booleanValue() || vu == null || vl == null || vu.compareTo(vl) > 0) break block5;
            this.getHinweise().setText(NotificationPanel.Type.ERROR, i18n.tr("Das obere Limit muss gr\u00f6\u00dfer als das untere Limit sein."));
            return false;
        }
        this.upper.setEnabled(eu);
        this.upper.setDays((Integer)this.getUpperDays().getValue());
        this.upper.setValue(vu);
        this.upper.setNotify((Boolean)this.getUpperNotify().getValue());
        ForecastCreator.setLimit(this.upper);
        this.lower.setEnabled(el);
        this.lower.setDays((Integer)this.getLowerDays().getValue());
        this.lower.setValue(vl);
        this.lower.setNotify((Boolean)this.getLowerNotify().getValue());
        ForecastCreator.setLimit(this.lower);
        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Einstellungen gespeichert"), 0));
        return true;
    }

    private class MyUmsatzDaysInput
    extends UmsatzDaysInput {
        private MyUmsatzDaysInput() {
            this.setScaling(1, 999, 1, 7);
        }

        public void setComment(String comment) {
            int days = (Integer)this.getValue();
            if (days == 1) {
                super.setComment(i18n.tr("morgen"));
                return;
            }
            KontoLimitsDialog.this.cal.setTime(DateUtil.startOfDay((Date)new Date()));
            KontoLimitsDialog.this.cal.add(5, days);
            super.setComment(i18n.tr("in {0} Tagen ({1})", new String[]{Integer.toString(days), HBCI.DATEFORMAT.format(KontoLimitsDialog.this.cal.getTime())}));
        }
    }

    private class ReloadListener
    implements Listener {
        private ReloadListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = KontoLimitsDialog.this.getKontoAuswahl().getValue();
                boolean haveKonto = o instanceof Konto;
                KontoLimitsDialog.this.getLowerEnabled().setEnabled(haveKonto);
                KontoLimitsDialog.this.getUpperEnabled().setEnabled(haveKonto);
                KontoLimitsDialog.this.getLowerDays().setEnabled(haveKonto);
                KontoLimitsDialog.this.getUpperDays().setEnabled(haveKonto);
                KontoLimitsDialog.this.getLowerValue().setEnabled(haveKonto);
                KontoLimitsDialog.this.getUpperValue().setEnabled(haveKonto);
                KontoLimitsDialog.this.getLowerNotify().setEnabled(haveKonto);
                KontoLimitsDialog.this.getUpperNotify().setEnabled(haveKonto);
                KontoLimitsDialog.this.getApply().setEnabled(haveKonto);
                if (!haveKonto) {
                    KontoLimitsDialog.this.getHinweise().setText(NotificationPanel.Type.INFO, i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
                    KontoLimitsDialog.this.getUpperEnabled().setValue((Object)false);
                    KontoLimitsDialog.this.getLowerEnabled().setValue((Object)false);
                    KontoLimitsDialog.this.getLowerValue().setValue(null);
                    KontoLimitsDialog.this.getUpperValue().setValue(null);
                    KontoLimitsDialog.this.getLowerDays().setValue(null);
                    KontoLimitsDialog.this.getUpperDays().setValue(null);
                    KontoLimitsDialog.this.getUpperNotify().setValue((Object)false);
                    KontoLimitsDialog.this.getLowerNotify().setValue((Object)false);
                    return;
                }
                KontoLimitsDialog.this.konto = (Konto)o;
                KontoLimitsDialog.this.upper = ForecastCreator.getLimit(KontoLimitsDialog.this.konto, SaldoLimit.Type.UPPER);
                KontoLimitsDialog.this.lower = ForecastCreator.getLimit(KontoLimitsDialog.this.konto, SaldoLimit.Type.LOWER);
                KontoLimitsDialog.this.getUpperEnabled().setValue((Object)KontoLimitsDialog.this.upper.isEnabled());
                KontoLimitsDialog.this.getLowerEnabled().setValue((Object)KontoLimitsDialog.this.lower.isEnabled());
                KontoLimitsDialog.this.getUpperValue().setValue((Object)KontoLimitsDialog.this.upper.getValue());
                KontoLimitsDialog.this.getLowerValue().setValue((Object)KontoLimitsDialog.this.lower.getValue());
                KontoLimitsDialog.this.getUpperDays().setValue(KontoLimitsDialog.this.upper.getDays());
                KontoLimitsDialog.this.getLowerDays().setValue(KontoLimitsDialog.this.lower.getDays());
                KontoLimitsDialog.this.getUpperNotify().setValue((Object)KontoLimitsDialog.this.upper.isNotify());
                KontoLimitsDialog.this.getLowerNotify().setValue((Object)KontoLimitsDialog.this.lower.isNotify());
                KontoLimitsDialog.this.statusListener.handleEvent(null);
            }
            catch (RemoteException re) {
                Logger.error((String)"error while reading data", (Throwable)re);
            }
        }
    }

    private class StatusListener
    implements Listener {
        private StatusListener() {
        }

        public void handleEvent(Event event) {
            boolean haveUpper = (Boolean)KontoLimitsDialog.this.getUpperEnabled().getValue();
            boolean haveLower = (Boolean)KontoLimitsDialog.this.getLowerEnabled().getValue();
            KontoLimitsDialog.this.getUpperValue().setEnabled(haveUpper);
            KontoLimitsDialog.this.getLowerValue().setEnabled(haveLower);
            KontoLimitsDialog.this.getUpperDays().setEnabled(haveUpper);
            KontoLimitsDialog.this.getLowerDays().setEnabled(haveLower);
            KontoLimitsDialog.this.getUpperNotify().setEnabled(haveUpper);
            KontoLimitsDialog.this.getLowerNotify().setEnabled(haveLower);
            Double vu = (Double)KontoLimitsDialog.this.getUpperValue().getValue();
            Double vl = (Double)KontoLimitsDialog.this.getLowerValue().getValue();
            KontoLimitsDialog.this.getApply().setEnabled(vu != null && vl != null);
        }
    }
}

