/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DirectoryInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.NotificationPanel;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class KontoauszugMoveDialog
extends AbstractDialog<Kontoauszug> {
    private static final Settings settings = new Settings(KontoauszugMoveDialog.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 580;
    private Kontoauszug[] list = null;
    private DirectoryInput target = null;
    private CheckboxInput overwrite = null;
    private CheckboxInput delete = null;
    private NotificationPanel error = null;
    private Button apply = null;

    public KontoauszugMoveDialog(Kontoauszug[] list) throws ApplicationException {
        super(1);
        if (list == null || list.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Kontoausz\u00fcge aus"));
        }
        this.list = list;
        this.setTitle(i18n.tr("Kontoausz\u00fcge verschieben"));
        this.setSize(580, -1);
    }

    private DirectoryInput getTarget() {
        if (this.target != null) {
            return this.target;
        }
        String fallback = System.getProperty("user.home");
        String s = settings.getString("lastdir", fallback);
        File dir = new File(s);
        if (!(dir.exists() && dir.canWrite() && dir.isDirectory())) {
            dir = new File(fallback);
        }
        this.target = new DirectoryInput(dir.getAbsolutePath());
        this.target.setName(i18n.tr("Zielverzeichnis"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                KontoauszugMoveDialog.this.check();
            }
        };
        this.target.addListener(l);
        return this.target;
    }

    private CheckboxInput getOverwrite() {
        if (this.overwrite != null) {
            return this.overwrite;
        }
        this.overwrite = new CheckboxInput(settings.getBoolean("overwrite", false));
        this.overwrite.setName(i18n.tr("Gleichnamige Dateien \u00fcberschreiben, wenn sie im Zielverzeichnis bereits existieren"));
        return this.overwrite;
    }

    private CheckboxInput getDelete() {
        if (this.delete != null) {
            return this.delete;
        }
        this.delete = new CheckboxInput(settings.getBoolean("delete", false));
        this.delete.setName(i18n.tr("Quelldateien nach dem Kopieren l\u00f6schen"));
        return this.delete;
    }

    private void check() {
        boolean enable;
        String text;
        block9: {
            File dir;
            block8: {
                block7: {
                    String s;
                    block6: {
                        s = StringUtils.trimToNull((String)((String)this.getTarget().getValue()));
                        text = null;
                        enable = false;
                        try {
                            if (s != null) break block6;
                            this.getError().setText(text != null ? NotificationPanel.Type.ERROR : NotificationPanel.Type.INVISIBLE, text != null ? i18n.tr(text) : "");
                        }
                        catch (Throwable throwable) {
                            this.getError().setText(text != null ? NotificationPanel.Type.ERROR : NotificationPanel.Type.INVISIBLE, text != null ? i18n.tr(text) : "");
                            this.getApplyButton().setEnabled(enable);
                            throw throwable;
                        }
                        this.getApplyButton().setEnabled(enable);
                        return;
                    }
                    dir = new File(s);
                    if (dir.exists()) break block7;
                    text = "Zielverzeichnis existiert nicht";
                    this.getError().setText(text != null ? NotificationPanel.Type.ERROR : NotificationPanel.Type.INVISIBLE, text != null ? i18n.tr(text) : "");
                    this.getApplyButton().setEnabled(enable);
                    return;
                }
                if (dir.isDirectory()) break block8;
                text = "Zielverzeichnis ist kein g\u00fcltiges Verzeichnis";
                this.getError().setText(text != null ? NotificationPanel.Type.ERROR : NotificationPanel.Type.INVISIBLE, text != null ? i18n.tr(text) : "");
                this.getApplyButton().setEnabled(enable);
                return;
            }
            if (dir.canWrite()) break block9;
            text = "Keine Schreibrechte in Zielverzeichnis";
            this.getError().setText(text != null ? NotificationPanel.Type.ERROR : NotificationPanel.Type.INVISIBLE, text != null ? i18n.tr(text) : "");
            this.getApplyButton().setEnabled(enable);
            return;
        }
        enable = true;
        this.getError().setText(text != null ? NotificationPanel.Type.ERROR : NotificationPanel.Type.INVISIBLE, text != null ? i18n.tr(text) : "");
        this.getApplyButton().setEnabled(enable);
    }

    private NotificationPanel getError() {
        if (this.error != null) {
            return this.error;
        }
        this.error = new NotificationPanel();
        return this.error;
    }

    private Button getApplyButton() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("Dateien jetzt verschieben"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoauszugMoveDialog.this.startMove();
            }
        }, null, false, "ok.png");
        this.apply.setEnabled(false);
        return this.apply;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie das Verzeichnis, in das die Dateien verschoben werden sollen und klicken Sie anschlie\u00dfend auf \"Dateien jetzt verschieben\", um den Vorgang zu starten."), true);
        group.addInput((Input)this.getTarget());
        group.addHeadline(i18n.tr("Optionen"));
        group.addInput((Input)this.getOverwrite());
        group.addInput((Input)this.getDelete());
        group.addSeparator();
        group.addText(i18n.tr("Hinweise: Sie k\u00f6nnen diese Funktion auch verwenden, wenn Sie einige oder alle Dateien bereits selbst kopiert oder verschoben haben. In dem Fall werden lediglich die Verkn\u00fcpfungen in Hibiscus aktualisiert.\n\nBeachten Sie, dass unterschiedliche Kontoausz\u00fcge verschiedener Konten dennoch identische Dateinamen besitzen k\u00f6nnen. Kopieren Sie diese in unterschiedliche Zielverzeichnisse, um sicherzustellen, dass keine Dateien verloren gehen oder versehentlich \u00fcberschrieben werden."), true, Color.COMMENT);
        group.addPart((Part)this.getError());
        ButtonArea b = new ButtonArea();
        b.addButton(this.getApplyButton());
        b.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, true, "process-stop.png");
        group.addButtonArea(b);
        this.getShell().setMinimumSize(this.getShell().computeSize(580, -1));
        this.check();
    }

    private void startMove() {
        final boolean overwrite = (Boolean)this.getOverwrite().getValue();
        final boolean delete = (Boolean)this.getDelete().getValue();
        final File dir = new File((String)this.getTarget().getValue());
        final String pfad = dir.getAbsolutePath();
        settings.setAttribute("lastdir", pfad);
        settings.setAttribute("overwrite", overwrite);
        settings.setAttribute("delete", delete);
        this.close();
        final double factor = 100.0 / (double)this.list.length;
        Application.getController().start(new BackgroundTask(){
            private boolean stop = false;

            public void run(ProgressMonitor monitor) throws ApplicationException {
                if (monitor != null) {
                    monitor.setStatusText(i18n.tr(delete ? "Verschiebe Dateien" : "Kopiere Dateien"));
                }
                int i = 0;
                while (i < KontoauszugMoveDialog.this.list.length) {
                    block21: {
                        Kontoauszug k = KontoauszugMoveDialog.this.list[i];
                        try {
                            boolean same;
                            if (this.stop) {
                                throw new OperationCanceledException();
                            }
                            if (monitor != null) {
                                monitor.log(i18n.tr("{0}/{1}: {2}", new String[]{Integer.toString(i + 1), Integer.toString(KontoauszugMoveDialog.this.list.length), k.getDateiname()}));
                                monitor.setPercentComplete((int)((double)(i + 1) * factor));
                            }
                            Logger.info((String)("processing kontoauszug [id: " + k.getID() + "], path: " + k.getPfad() + ", name: " + k.getDateiname() + ", uuid: " + k.getUUID()));
                            File source = null;
                            try {
                                source = KontoauszugPdfUtil.getFile(k);
                            }
                            catch (ApplicationException ae) {
                                Logger.warn((String)ae.getMessage());
                            }
                            File target = new File(dir, k.getDateiname());
                            boolean sourceExists = source != null;
                            boolean targetExists = target.exists();
                            boolean bl = same = sourceExists && targetExists && source.getCanonicalFile().equals(target.getCanonicalFile());
                            if (!sourceExists && !targetExists) {
                                throw new ApplicationException(i18n.tr("Quell- und Zieldatei existieren nicht, kein Kopieren/Verschieben m\u00f6glich"));
                            }
                            if (same) {
                                Logger.info((String)"skip copying, source and target are the same file");
                            }
                            if (sourceExists && (!targetExists || overwrite) && !same) {
                                Logger.info((String)("copying " + source + " to " + target));
                                FileInputStream is = null;
                                FileOutputStream os = null;
                                FileChannel src = null;
                                FileChannel dst = null;
                                try {
                                    if (targetExists) {
                                        Logger.info((String)("overwriting file " + target));
                                        if (monitor != null) {
                                            monitor.log("    " + i18n.tr("\u00dcberschreibe Datei {0}", target.getName()));
                                        }
                                    }
                                    is = new FileInputStream(source);
                                    os = new FileOutputStream(target);
                                    src = is.getChannel();
                                    dst = os.getChannel();
                                    dst.transferFrom(src, 0L, src.size());
                                }
                                catch (Throwable throwable) {
                                    IOUtil.close((Closeable[])new Closeable[]{src});
                                    IOUtil.close((Closeable[])new Closeable[]{dst});
                                    IOUtil.close((Closeable[])new Closeable[]{is});
                                    IOUtil.close((Closeable[])new Closeable[]{os});
                                    throw throwable;
                                }
                                IOUtil.close((Closeable[])new Closeable[]{src});
                                IOUtil.close((Closeable[])new Closeable[]{dst});
                                IOUtil.close((Closeable[])new Closeable[]{is});
                                IOUtil.close((Closeable[])new Closeable[]{os});
                            }
                            Logger.info((String)"updating data");
                            k.setPfad(pfad);
                            k.setUUID(null);
                            k.store();
                            if (delete && source != null && !same) {
                                String uuid = StringUtils.trimToNull((String)k.getUUID());
                                if (uuid != null) {
                                    Logger.info((String)("deleting " + uuid));
                                    QueryMessage qm = new QueryMessage(uuid, null);
                                    Application.getMessagingFactory().getMessagingQueue("jameica.messaging.del").sendSyncMessage((Message)qm);
                                } else {
                                    Logger.info((String)("deleting " + source.getAbsolutePath()));
                                    source.delete();
                                }
                            }
                        }
                        catch (ApplicationException ae) {
                            if (monitor != null) {
                                monitor.log("    " + ae.getMessage());
                            }
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to copy entry", (Throwable)e);
                            if (monitor == null) break block21;
                            monitor.log("    " + i18n.tr("fehlgeschlagen: {0}", e.getMessage()));
                        }
                    }
                    ++i;
                }
                if (monitor != null) {
                    monitor.setStatus(4);
                    monitor.setPercentComplete(100);
                    monitor.setStatusText(i18n.tr("Vorgang abgeschlossen"));
                }
            }

            public boolean isInterrupted() {
                return this.stop;
            }

            public void interrupt() {
                this.stop = true;
            }
        });
    }

    protected Kontoauszug getData() throws Exception {
        return null;
    }
}

