/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DirectoryInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.internal.action.Program;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.ScrolledContainer;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.messaging.MessagingAvailableConsumer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.KontoauszugInterval;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.kapott.hbci.GV_Result.GVRKontoauszug;

public class KontoauszugPdfSettingsDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = new Settings(KontoauszugPdfSettingsDialog.class);
    private static final int WINDOW_WIDTH = 700;
    private static final int WINDOW_HEIGHT = 500;
    private Konto konto = null;
    private KontoInput kontoAuswahl = null;
    private LabelInput hinweise = null;
    private LabelInput hinweise2 = null;
    private SelectInput interval = null;
    private CheckboxInput ignoreFormat = null;
    private CheckboxInput markRead = null;
    private CheckboxInput sendReceipt = null;
    private LabelInput nextFetch = null;
    private CheckboxInput messaging = null;
    private DirectoryInput path = null;
    private TextInput folder = null;
    private TextInput name = null;
    private LabelInput example = null;
    private LabelInput exampleText = null;
    private Button apply = null;
    private Listener reloadListener = new ReloadListener();
    private Listener supportListener = new SupportListener();
    private Listener exampleListener = new ExampleListener();
    private Listener intervalListener = new IntervalListener();

    public KontoauszugPdfSettingsDialog(Konto konto) {
        super(1);
        this.konto = konto;
        this.setTitle(i18n.tr("Einstellungen f\u00fcr den elektronischen Kontoauszug"));
        this.setSize(settings.getInt("window.width", 700), settings.getInt("window.height", 500));
    }

    protected void paint(Composite parent) throws Exception {
        ScrolledContainer scroll = new ScrolledContainer(parent, 1){

            public void update() {
                Composite comp = this.getComposite();
                if (comp == null || comp.isDisposed()) {
                    return;
                }
                comp.setSize(comp.computeSize(settings.getInt("window.width", 700), -1));
                comp.layout();
            }
        };
        SimpleContainer c = new SimpleContainer(scroll.getComposite());
        c.addText(String.valueOf(i18n.tr("W\u00e4hlen Sie das Konto aus, f\u00fcr das Sie den Abruf der elektronischen Kontoausz\u00fcge konfigurieren m\u00f6chten.\nF\u00fcr weitere Informationen klicken Sie auf die Schaltfl\u00e4che \"Hilfe\".")) + "\n", true);
        c.addInput((Input)this.getKontoAuswahl());
        c.addInput((Input)this.getHinweise());
        c.addInput((Input)this.getHinweise2());
        c.addInput((Input)this.getIgnoreFormat());
        c.addHeadline(i18n.tr("Konto-Synchronisation"));
        c.addText(i18n.tr("W\u00e4hlen Sie das Intervall, in dem die elektronischen Kontoausz\u00fcge bei der Konto-Synchronisation mit abgerufen werden sollen. Sie k\u00f6nnen au\u00dferdem festlegen, ob die Kontoausz\u00fcge auch dann abgerufen werden sollen, wenn die Bank kein PDF-Format anbietet (sondern nur MT940)."), true, Color.COMMENT);
        c.addInput((Input)this.getIntervall());
        c.addInput((Input)this.getNextFetch());
        c.addInput((Input)this.getSendReceipt());
        c.addInput((Input)this.getMarkRead());
        c.addText("", true);
        c.addHeadline(i18n.tr("Ablage-Ort der Kontoausz\u00fcge"));
        c.addText(i18n.tr("Sie k\u00f6nnen die folgenden Platzhalter zur Benennung der Unterordner und Dateinamen verwenden:\n\n${iban}, ${bic}, ${jahr}, ${monat}, ${tag}, ${stunde}, ${minute}, ${nummer}\n\nUnterordner werden bei Bedarf automatisch erstellt. Lassen Sie die Vorlage f\u00fcr Unterordner alternativ leer, wenn Sie diese nicht nutzen m\u00f6chten. Die passende Dateiendung wird automatisch an den Dateinamen angeh\u00e4ngt."), true, Color.COMMENT);
        if (MessagingAvailableConsumer.haveMessaging()) {
            c.addInput((Input)this.getMessaging());
        }
        c.addInput((Input)this.getPath());
        c.addInput((Input)this.getFolder());
        c.addInput((Input)this.getName());
        SimpleContainer c2 = new SimpleContainer(scroll.getComposite());
        c2.addInput((Input)this.getExampleText());
        c2.addInput((Input)this.getExample());
        c2.addInput((Input)new LabelInput(""));
        SimpleContainer c3 = new SimpleContainer(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(String.valueOf(i18n.tr("Hilfe")) + "  ", (Action)new Program(), (Object)"http://www.willuhn.de/wiki/doku.php?id=handbuch:kontoauszug", false, "gtk-info.png");
        buttons.addButton(this.getApply());
        buttons.addButton(i18n.tr("Schlie\u00dfen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoauszugPdfSettingsDialog.this.close();
            }
        }, null, false, "window-close.png");
        c3.addButtonArea(buttons);
        this.getShell().setMinimumSize(700, 500);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell shell = KontoauszugPdfSettingsDialog.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                Point size = shell.getSize();
                Logger.debug((String)("saving window size: " + size.x + "x" + size.y));
                settings.setAttribute("window.width", size.x);
                settings.setAttribute("window.height", size.y);
            }
        });
    }

    private Button getApply() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoauszugPdfSettingsDialog.this.handleStore();
            }
        }, null, true, "ok.png");
        return this.apply;
    }

    public KontoInput getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(this.konto, KontoFilter.ONLINE);
        this.kontoAuswahl.setSupportGroups(false);
        this.kontoAuswahl.setComment(null);
        this.kontoAuswahl.addListener(this.reloadListener);
        this.reloadListener.handleEvent(null);
        return this.kontoAuswahl;
    }

    private LabelInput getHinweise() {
        if (this.hinweise != null) {
            return this.hinweise;
        }
        this.hinweise = new LabelInput("");
        this.hinweise.setColor(Color.ERROR);
        this.hinweise.setName("");
        return this.hinweise;
    }

    private LabelInput getHinweise2() {
        if (this.hinweise2 != null) {
            return this.hinweise2;
        }
        this.hinweise2 = new LabelInput("");
        this.hinweise2.setColor(Color.ERROR);
        this.hinweise2.setName("");
        return this.hinweise2;
    }

    private SelectInput getIntervall() {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new SelectInput(KontoauszugInterval.KNOWN, null);
        this.interval.setName(MetaKey.KONTOAUSZUG_INTERVAL.getDescription());
        this.interval.setAttribute("name");
        this.interval.setComment("");
        this.interval.addListener(this.intervalListener);
        return this.interval;
    }

    private CheckboxInput getIgnoreFormat() {
        if (this.ignoreFormat != null) {
            return this.ignoreFormat;
        }
        this.ignoreFormat = new CheckboxInput(false);
        this.ignoreFormat.setName(MetaKey.KONTOAUSZUG_IGNORE_FORMAT.getDescription());
        this.ignoreFormat.addListener(this.supportListener);
        return this.ignoreFormat;
    }

    private CheckboxInput getMarkRead() {
        if (this.markRead != null) {
            return this.markRead;
        }
        this.markRead = new CheckboxInput(false);
        this.markRead.setName(MetaKey.KONTOAUSZUG_MARK_READ.getDescription());
        return this.markRead;
    }

    private CheckboxInput getSendReceipt() {
        if (this.sendReceipt != null) {
            return this.sendReceipt;
        }
        this.sendReceipt = new CheckboxInput(false);
        this.sendReceipt.setName(MetaKey.KONTOAUSZUG_SEND_RECEIPT.getDescription());
        return this.sendReceipt;
    }

    private LabelInput getNextFetch() {
        if (this.nextFetch != null) {
            return this.nextFetch;
        }
        this.nextFetch = new LabelInput("");
        this.nextFetch.setName(i18n.tr("N\u00e4chster Abruf"));
        this.nextFetch.setComment("");
        return this.nextFetch;
    }

    private CheckboxInput getMessaging() {
        if (this.messaging != null) {
            return this.messaging;
        }
        if (!MessagingAvailableConsumer.haveMessaging()) {
            return null;
        }
        this.messaging = new CheckboxInput(false);
        this.messaging.setName(MetaKey.KONTOAUSZUG_STORE_MESSAGING.getDescription());
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                Boolean checked = (Boolean)KontoauszugPdfSettingsDialog.this.getMessaging().getValue();
                KontoauszugPdfSettingsDialog.this.getPath().setEnabled(checked == false);
                KontoauszugPdfSettingsDialog.this.getFolder().setEnabled(checked == false);
                KontoauszugPdfSettingsDialog.this.getName().setEnabled(checked == false);
                if (checked.booleanValue()) {
                    KontoauszugPdfSettingsDialog.this.getExample().setValue((Object)"");
                    KontoauszugPdfSettingsDialog.this.getExampleText().setValue((Object)"");
                } else {
                    KontoauszugPdfSettingsDialog.this.exampleListener.handleEvent(null);
                }
            }
        };
        this.messaging.addListener(l);
        l.handleEvent(null);
        return this.messaging;
    }

    private DirectoryInput getPath() {
        if (this.path != null) {
            return this.path;
        }
        this.path = new DirectoryInput("");
        this.path.setName(MetaKey.KONTOAUSZUG_STORE_PATH.getDescription());
        this.path.addListener(this.exampleListener);
        return this.path;
    }

    private TextInput getFolder() {
        if (this.folder != null) {
            return this.folder;
        }
        this.folder = new TextInput("");
        this.folder.setName(MetaKey.KONTOAUSZUG_TEMPLATE_PATH.getDescription());
        this.folder.addListener(this.exampleListener);
        return this.folder;
    }

    private TextInput getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = new TextInput("");
        this.name.setName(MetaKey.KONTOAUSZUG_TEMPLATE_NAME.getDescription());
        this.name.addListener(this.exampleListener);
        return this.name;
    }

    private LabelInput getExample() {
        if (this.example != null) {
            return this.example;
        }
        this.example = new LabelInput("");
        this.example.addListener(this.exampleListener);
        this.exampleListener.handleEvent(null);
        return this.example;
    }

    private LabelInput getExampleText() {
        if (this.exampleText != null) {
            return this.exampleText;
        }
        this.exampleText = new LabelInput("");
        this.exampleText.setName("");
        return this.getExampleText();
    }

    protected Object getData() throws Exception {
        return null;
    }

    private void markDirty(boolean dirty) {
        this.getApply().setEnabled(!dirty);
    }

    private void markSupported(boolean supported, boolean conditional) {
        boolean support = supported || (Boolean)this.getIgnoreFormat().getValue() != false;
        this.getIntervall().setEnabled(support);
        this.getIgnoreFormat().setEnabled(conditional);
        CheckboxInput messaging = this.getMessaging();
        if (messaging != null && ((Boolean)messaging.getValue()).booleanValue()) {
            this.getPath().setEnabled(false);
            this.getFolder().setEnabled(false);
            this.getName().setEnabled(false);
            this.getMarkRead().setEnabled(false);
            this.getSendReceipt().setEnabled(false);
        } else {
            this.getPath().setEnabled(support);
            this.getFolder().setEnabled(support);
            this.getName().setEnabled(support);
            this.getMarkRead().setEnabled(support);
            this.getSendReceipt().setEnabled(support);
        }
        if (messaging != null) {
            messaging.setEnabled(support);
        }
    }

    private void handleStore() {
        try {
            CheckboxInput messaging;
            MetaKey.KONTOAUSZUG_IGNORE_FORMAT.set(this.konto, Boolean.toString((Boolean)this.getIgnoreFormat().getValue()));
            MetaKey.KONTOAUSZUG_INTERVAL.set(this.konto, ((KontoauszugInterval)this.getIntervall().getValue()).getId());
            if (KontoauszugInterval.getNextInterval(this.konto) != null) {
                SynchronizeOptions options = new SynchronizeOptions(this.konto);
                options.setSyncKontoauszuegePdf(true);
            }
            if ((messaging = this.getMessaging()) != null) {
                MetaKey.KONTOAUSZUG_STORE_MESSAGING.set(this.konto, Boolean.toString((Boolean)messaging.getValue()));
            }
            MetaKey.KONTOAUSZUG_STORE_PATH.set(this.konto, (String)this.getPath().getValue());
            MetaKey.KONTOAUSZUG_TEMPLATE_PATH.set(this.konto, (String)this.getFolder().getValue());
            MetaKey.KONTOAUSZUG_TEMPLATE_NAME.set(this.konto, (String)this.getName().getValue());
            MetaKey.KONTOAUSZUG_MARK_READ.set(this.konto, Boolean.toString((Boolean)this.getMarkRead().getValue()));
            MetaKey.KONTOAUSZUG_SEND_RECEIPT.set(this.konto, Boolean.toString((Boolean)this.getSendReceipt().getValue()));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Einstellungen gespeichert"), 0));
        }
        catch (RemoteException re) {
            Logger.error((String)"error while saving settings", (Throwable)re);
        }
    }

    private class ExampleListener
    implements Listener {
        private ExampleListener() {
        }

        public void handleEvent(Event event) {
            LabelInput label = KontoauszugPdfSettingsDialog.this.getExample();
            LabelInput comment = KontoauszugPdfSettingsDialog.this.getExampleText();
            try {
                String path = (String)KontoauszugPdfSettingsDialog.this.getPath().getValue();
                String folder = (String)KontoauszugPdfSettingsDialog.this.getFolder().getValue();
                String name = (String)KontoauszugPdfSettingsDialog.this.getName().getValue();
                String s = KontoauszugPdfUtil.createPath(KontoauszugPdfSettingsDialog.this.konto, null, path, folder, name);
                label.setValue((Object)s);
                if (!KontoauszugPdfUtil.testPath(KontoauszugPdfSettingsDialog.this.konto, folder, name)) {
                    comment.setValue((Object)i18n.tr("Definition der Platzhalter ung\u00fcltig"));
                    comment.setColor(Color.ERROR);
                    label.setColor(Color.FOREGROUND);
                    KontoauszugPdfSettingsDialog.this.markDirty(true);
                } else {
                    comment.setValue((Object)"");
                    label.setColor(Color.SUCCESS);
                    KontoauszugPdfSettingsDialog.this.markDirty(false);
                }
            }
            catch (ApplicationException ae) {
                comment.setValue((Object)ae.getMessage());
                comment.setColor(Color.ERROR);
                label.setValue((Object)"");
                label.setColor(Color.FOREGROUND);
                KontoauszugPdfSettingsDialog.this.markDirty(true);
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to create path", (Throwable)re);
                comment.setValue((Object)i18n.tr("Pfad-Angabe ung\u00fcltig"));
                comment.setColor(Color.ERROR);
                label.setValue((Object)"");
                label.setColor(Color.FOREGROUND);
                KontoauszugPdfSettingsDialog.this.markDirty(true);
            }
        }
    }

    private class IntervalListener
    implements Listener {
        private IntervalListener() {
        }

        public void handleEvent(Event event) {
            String s = null;
            Date last = null;
            try {
                s = MetaKey.KONTOAUSZUG_INTERVAL_LAST.get(KontoauszugPdfSettingsDialog.this.konto);
                if (s != null && s.length() > 0) {
                    last = HBCI.LONGDATEFORMAT.parse(s);
                }
            }
            catch (Exception e) {
                Logger.error((String)("unable to parse date: " + s), (Throwable)e);
            }
            KontoauszugInterval i = (KontoauszugInterval)KontoauszugPdfSettingsDialog.this.getIntervall().getValue();
            Date next = i.getNextInterval(last);
            LabelInput l = KontoauszugPdfSettingsDialog.this.getNextFetch();
            if (next == null) {
                l.setColor(Color.COMMENT);
                l.setValue((Object)"-");
            } else if (!next.after(new Date())) {
                l.setColor(Color.SUCCESS);
                l.setValue((Object)i18n.tr("Bei der n\u00e4chsten Synchronisation"));
            } else {
                l.setColor(Color.SUCCESS);
                l.setValue((Object)HBCI.DATEFORMAT.format(next));
            }
        }
    }

    private class ReloadListener
    implements Listener {
        private ReloadListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = KontoauszugPdfSettingsDialog.this.getKontoAuswahl().getValue();
                if (!(o instanceof Konto)) {
                    LabelInput hinweise = KontoauszugPdfSettingsDialog.this.getHinweise();
                    hinweise.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
                    KontoauszugPdfSettingsDialog.this.getHinweise2().setValue((Object)"");
                    KontoauszugPdfSettingsDialog.this.markSupported(false, false);
                    return;
                }
                KontoauszugPdfSettingsDialog.this.getHinweise2().setValue((Object)"");
                KontoauszugPdfSettingsDialog.this.konto = (Konto)o;
                KontoauszugPdfSettingsDialog.this.getIntervall().setValue((Object)KontoauszugInterval.find(MetaKey.KONTOAUSZUG_INTERVAL.get(KontoauszugPdfSettingsDialog.this.konto)));
                KontoauszugPdfSettingsDialog.this.getIgnoreFormat().setValue((Object)Boolean.parseBoolean(MetaKey.KONTOAUSZUG_IGNORE_FORMAT.get(KontoauszugPdfSettingsDialog.this.konto)));
                KontoauszugPdfSettingsDialog.this.getMarkRead().setValue((Object)Boolean.parseBoolean(MetaKey.KONTOAUSZUG_MARK_READ.get(KontoauszugPdfSettingsDialog.this.konto)));
                KontoauszugPdfSettingsDialog.this.getSendReceipt().setValue((Object)Boolean.parseBoolean(MetaKey.KONTOAUSZUG_SEND_RECEIPT.get(KontoauszugPdfSettingsDialog.this.konto)));
                String s = MetaKey.KONTOAUSZUG_INTERVAL_LAST.get(KontoauszugPdfSettingsDialog.this.konto);
                KontoauszugPdfSettingsDialog.this.getIntervall().setComment(i18n.tr("Letzter Abruf: {0}", s != null ? s : i18n.tr("nie")));
                CheckboxInput messaging = KontoauszugPdfSettingsDialog.this.getMessaging();
                if (messaging != null) {
                    KontoauszugPdfSettingsDialog.this.getMessaging().setValue((Object)Boolean.parseBoolean(MetaKey.KONTOAUSZUG_STORE_MESSAGING.get(KontoauszugPdfSettingsDialog.this.konto)));
                }
                KontoauszugPdfSettingsDialog.this.getPath().setValue((Object)MetaKey.KONTOAUSZUG_STORE_PATH.get(KontoauszugPdfSettingsDialog.this.konto));
                KontoauszugPdfSettingsDialog.this.getFolder().setValue((Object)MetaKey.KONTOAUSZUG_TEMPLATE_PATH.get(KontoauszugPdfSettingsDialog.this.konto));
                KontoauszugPdfSettingsDialog.this.getName().setValue((Object)MetaKey.KONTOAUSZUG_TEMPLATE_NAME.get(KontoauszugPdfSettingsDialog.this.konto));
                KontoauszugPdfSettingsDialog.this.intervalListener.handleEvent(null);
                KontoauszugPdfSettingsDialog.this.exampleListener.handleEvent(null);
                KontoauszugPdfSettingsDialog.this.supportListener.handleEvent(null);
            }
            catch (RemoteException re) {
                Logger.error((String)"error while reading data", (Throwable)re);
            }
        }
    }

    private class SupportListener
    implements Listener {
        private SupportListener() {
        }

        public void handleEvent(Event event) {
            boolean ok = false;
            String text1 = null;
            String text2 = null;
            if (KontoauszugPdfSettingsDialog.this.konto != null) {
                BPDUtil.Support hkekp = BPDUtil.getSupport(KontoauszugPdfSettingsDialog.this.konto, BPDUtil.Query.KontoauszugPdf);
                BPDUtil.Support hkeka = BPDUtil.getSupport(KontoauszugPdfSettingsDialog.this.konto, BPDUtil.Query.Kontoauszug);
                boolean bl = ok = hkekp != null && hkekp.isSupported();
                if (ok) {
                    text1 = "HKEKP: Von Bank unterst\u00fctzt und f\u00fcr Konto freigeschaltet";
                }
                if (!ok) {
                    boolean bl2 = ok = hkeka != null && hkeka.getBpdSupport() && hkeka.getUpdSupport() && KontoauszugPdfUtil.getFormats(hkeka.getBpd()).contains(GVRKontoauszug.Format.PDF);
                    if (ok) {
                        text2 = "HKEKA: Von Bank unterst\u00fctzt, freigeschaltet und PDF-Format vorhanden";
                    }
                }
                if (!ok) {
                    if (hkekp != null) {
                        text1 = !hkekp.getBpdSupport() ? "HKEKP: Bank unterst\u00fctzt Gesch\u00e4ftsvorfall nicht" : "HKEKP: Von Bank unterst\u00fctzt, jedoch nicht f\u00fcr Konto freigeschaltet";
                    }
                    if (hkeka != null) {
                        if (!hkeka.getBpdSupport()) {
                            text2 = "HKEKA: Bank unterst\u00fctzt Gesch\u00e4ftsvorfall nicht";
                        } else if (!hkeka.getUpdSupport()) {
                            text2 = "HKEKA: Von Bank unterst\u00fctzt, jedoch nicht f\u00fcr Konto freigeschaltet";
                        } else if (!KontoauszugPdfUtil.getFormats(hkeka.getBpd()).contains(GVRKontoauszug.Format.PDF)) {
                            text2 = "HKEKA: Von Bank unterst\u00fctzt, jedoch nicht im PDF-Format";
                        }
                    }
                }
            }
            LabelInput hinweise = KontoauszugPdfSettingsDialog.this.getHinweise();
            LabelInput hinweise2 = KontoauszugPdfSettingsDialog.this.getHinweise2();
            KontoauszugPdfSettingsDialog.this.markSupported(ok, true);
            hinweise.setColor(ok ? Color.SUCCESS : Color.ERROR);
            hinweise2.setColor(ok ? Color.SUCCESS : Color.ERROR);
            hinweise.setValue((Object)StringUtils.trimToEmpty((String)text1));
            hinweise2.setValue((Object)StringUtils.trimToEmpty((String)text2));
        }
    }
}

