/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;

public class KontoauszugSettingsDialog
extends AbstractDialog {
    private static final de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 500;
    private CheckboxInput displayAll = null;
    private CheckboxInput instantSearch = null;
    private CheckboxInput markReadOnExit = null;

    public KontoauszugSettingsDialog() {
        super(1);
        this.setTitle(i18n.tr("Anzeige-Einstellungen"));
        this.setSize(500, -1);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addInput((Input)this.getDisplayAll());
        c.addInput((Input)this.getInstantSearch());
        c.addInput((Input)this.getMarkReadOnExit());
        Button apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                settings.setAttribute("usage.display.all", ((Boolean)KontoauszugSettingsDialog.this.getDisplayAll().getValue()).booleanValue());
                settings.setAttribute("usage.instantsearch", ((Boolean)KontoauszugSettingsDialog.this.getInstantSearch().getValue()).booleanValue());
                Settings.setMarkReadOnExit((Boolean)KontoauszugSettingsDialog.this.getMarkReadOnExit().getValue());
                KontoauszugSettingsDialog.this.close();
            }
        }, null, true, "ok.png");
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(apply);
        buttons.addButton((Button)new Cancel());
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
    }

    protected Object getData() throws Exception {
        return null;
    }

    private CheckboxInput getDisplayAll() {
        if (this.displayAll != null) {
            return this.displayAll;
        }
        this.displayAll = new CheckboxInput(settings.getBoolean("usage.display.all", false));
        this.displayAll.setName(i18n.tr("Alle Daten des Verwendungszwecks anzeigen"));
        return this.displayAll;
    }

    private CheckboxInput getInstantSearch() {
        if (this.instantSearch != null) {
            return this.instantSearch;
        }
        this.instantSearch = new CheckboxInput(settings.getBoolean("usage.instantsearch", false));
        this.instantSearch.setName(i18n.tr("Suche bei Eingabe eines Suchbegriffs sofort starten"));
        return this.instantSearch;
    }

    private CheckboxInput getMarkReadOnExit() {
        if (this.markReadOnExit != null) {
            return this.markReadOnExit;
        }
        this.markReadOnExit = new CheckboxInput(Settings.getMarkReadOnExit());
        this.markReadOnExit.setName(i18n.tr("Ums\u00e4tze beim Beenden als gelesen markieren"));
        return this.markReadOnExit;
    }
}

