/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.INILetter;

public class NewInstKeysDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 540;
    private HBCIPassport passport = null;
    private Boolean choosen = null;

    public NewInstKeysDialog(HBCIPassport p) {
        super(1);
        this.passport = p;
        this.setTitle(i18n.tr("Neue Bank-Schl\u00fcssel erhalten"));
        this.setSize(540, -1);
    }

    protected void onEscape() {
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(i18n.tr("Bitte vergleichen Sie die von der Bank \u00fcbermittelten Hash-Werte (Checksummen)\nmit denen in Ihren Unterlagen. Stimmen diese mit den folgenden Werten \u00fcberein,\ndann best\u00e4tigen Sie bitte mit OK.\nAndernfalls brechen Sie den Vorgang aus Sicherheitsgr\u00fcnden bitte ab."), true);
        INILetter iniletter = new INILetter(this.passport, 1);
        group.addHeadline(i18n.tr("Hashwert"));
        group.addText(HBCIUtils.data2hex((byte[])iniletter.getKeyHashDisplay()).toUpperCase(), true, Color.ERROR);
        group.addHeadline(i18n.tr("Exponent"));
        group.addText(HBCIUtils.data2hex((byte[])iniletter.getKeyExponentDisplay()).toUpperCase(), true);
        group.addHeadline(i18n.tr("Modulus"));
        group.addText(HBCIUtils.data2hex((byte[])iniletter.getKeyModulusDisplay()).toUpperCase(), true);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("OK"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                NewInstKeysDialog.this.choosen = Boolean.TRUE;
                NewInstKeysDialog.this.close();
            }
        }, null, false, "ok.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                NewInstKeysDialog.this.choosen = Boolean.FALSE;
                NewInstKeysDialog.this.close();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(540, -1));
    }

    protected Object getData() throws Exception {
        return this.choosen;
    }
}

