/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.INILetter;

public class NewKeysDialog
extends AbstractDialog {
    private static final Settings settings = new Settings(NewKeysDialog.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 540;
    private static final DocFlavor DOCFLAVOR = DocFlavor.STRING.TEXT_PLAIN;
    private static final PrintRequestAttributeSet PRINTPROPS = new HashPrintRequestAttributeSet();
    private HBCIPassport passport;
    private INILetter iniletter;
    private Input printerList = null;
    private LabelInput error = null;

    static {
        PRINTPROPS.add(MediaSizeName.ISO_A4);
    }

    public NewKeysDialog(HBCIPassport p) {
        super(1);
        this.passport = p;
        this.setTitle(i18n.tr("INI-Brief erzeugen/anzeigen"));
        this.setSize(540, -1);
        this.iniletter = new INILetter(this.passport, 2);
    }

    protected void onEscape() {
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(i18n.tr("Bitte drucken Sie den INI-Brief aus und senden Ihn unterschrieben an Ihre Bank.\nNach der Freischaltung durch Ihr Geldinstitut kann dieser Schl\u00fcssel verwendet werden."), true);
        group.addHeadline(i18n.tr("Hashwert"));
        group.addText(HBCIUtils.data2hex((byte[])this.iniletter.getKeyHashDisplay()).toUpperCase(), true, Color.ERROR);
        group.addHeadline(i18n.tr("Exponent"));
        group.addText(HBCIUtils.data2hex((byte[])this.iniletter.getKeyExponentDisplay()).toUpperCase(), true);
        group.addHeadline(i18n.tr("Modulus"));
        group.addText(HBCIUtils.data2hex((byte[])this.iniletter.getKeyModulusDisplay()).toUpperCase(), true);
        Input printers = this.getPrinterList();
        group.addText("\n", true);
        group.addInput(printers);
        group.addInput((Input)this.getError());
        ButtonArea buttons = new ButtonArea();
        Button print = new Button(i18n.tr("Drucken"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                NewKeysDialog.this.print();
            }
        }, null, true, "document-print.png");
        print.setEnabled(printers instanceof SelectInput);
        buttons.addButton(print);
        buttons.addButton(i18n.tr("Speichern unter..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                NewKeysDialog.this.save();
            }
        }, null, false, "document-save.png");
        buttons.addButton(i18n.tr("Schlie\u00dfen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                NewKeysDialog.this.close();
            }
        }, null, false, "window-close.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("cancelled in ini letter dialog");
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(540, -1));
    }

    private void print() throws ApplicationException {
        try {
            PrintService service = (PrintService)this.getPrinterList().getValue();
            if (service == null) {
                this.getError().setValue((Object)i18n.tr("Kein Drucker gefunden."));
                return;
            }
            DocPrintJob pj = service.createPrintJob();
            SimpleDoc doc = new SimpleDoc(this.iniletter.toString(), DOCFLAVOR, null);
            pj.print(doc, PRINTPROPS);
        }
        catch (Exception e) {
            Logger.error((String)"error while printing ini letter", (Throwable)e);
            this.getError().setValue((Object)i18n.tr("Fehler: {0}", e.getMessage()));
        }
    }

    private void save() {
        block7: {
            String s;
            FileDialog fd = new FileDialog(GUI.getShell(), 8192);
            fd.setText(i18n.tr("Bitte geben Sie den Dateinamen an, in dem der INI-Brief gespeichert werden soll."));
            fd.setFileName(i18n.tr("hibiscus-inibrief-{0}.txt", HBCI.FASTDATEFORMAT.format(new Date())));
            fd.setOverwrite(true);
            String path = settings.getString("lastdir", System.getProperty("user.home"));
            if (path != null && path.length() > 0) {
                fd.setFilterPath(path);
            }
            if ((s = fd.open()) == null || s.length() == 0) {
                this.getError().setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie eine Datei f\u00fcr den INI-Brief aus."));
                return;
            }
            BufferedOutputStream os = null;
            try {
                try {
                    File file = new File(s);
                    os = new BufferedOutputStream(new FileOutputStream(file));
                    ((OutputStream)os).write(this.iniletter.toString().getBytes());
                    settings.setAttribute("lastdir", file.getParent());
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("INI-Brief gespeichert in {0}", s), 0));
                }
                catch (Exception e) {
                    Logger.error((String)("error while writing ini letter to " + s), (Throwable)e);
                    this.getError().setValue((Object)i18n.tr("Fehler: {0}", e.getMessage()));
                    IOUtil.close((Closeable[])new Closeable[]{os});
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
        }
    }

    private Input getPrinterList() throws Exception {
        if (this.printerList != null) {
            return this.printerList;
        }
        Object[] services = null;
        if (Application.getPlatform().getOS() != 3) {
            services = PrintServiceLookup.lookupPrintServices(DOCFLAVOR, PRINTPROPS);
        }
        if (services != null && services.length > 0) {
            this.printerList = new SelectInput(services, null);
            ((SelectInput)this.printerList).setAttribute("name");
        } else {
            this.printerList = new LabelInput(i18n.tr("Kein Drucker gefunden"));
            this.getError().setValue((Object)i18n.tr("Bitte speichern Sie den INI-Brief stattdessen."));
        }
        this.printerList.setName(i18n.tr("Drucker"));
        return this.printerList;
    }

    private LabelInput getError() {
        if (this.error != null) {
            return this.error;
        }
        this.error = new LabelInput("");
        this.error.setColor(Color.ERROR);
        this.error.setName("");
        return this.error;
    }

    protected Object getData() throws Exception {
        return null;
    }
}

