/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.dialogs.PasswordDialog;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.JameicaCompat;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;

public class PINDialog
extends PasswordDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public PINDialog(String pin) {
        super(1);
        Konto konto;
        this.setSize(550, -1);
        this.setLabelText(i18n.tr("Ihre PIN"));
        if (pin != null && pin.length() > 0) {
            try {
                JameicaCompat.set((Object)this, pin, "setPassword", "enteredPassword");
            }
            catch (Exception e) {
                Logger.error((String)"unable to apply pin", (Throwable)e);
            }
        }
        String s = null;
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
        Konto konto2 = konto = session != null ? session.getKonto() : null;
        if (konto != null) {
            try {
                s = konto.getBezeichnung();
                s = String.valueOf(s) + " [" + i18n.tr("Nr.") + " " + konto.getKontonummer();
                String name = HBCIProperties.getNameForBank(konto.getBLZ());
                if (name != null && name.length() > 0) {
                    s = String.valueOf(s) + " - " + name;
                }
                s = String.valueOf(s) + "]";
            }
            catch (Exception e) {
                Logger.error((String)"unable to determine account data", (Throwable)e);
            }
        }
        if (s != null) {
            this.setTitle(i18n.tr("PIN-Eingabe. Konto: {0}", s));
            this.setText(i18n.tr("Bitte geben Sie Ihre PIN ein.\nKonto: {0}", s));
        } else {
            this.setTitle(i18n.tr("PIN-Eingabe"));
            this.setText(i18n.tr("Bitte geben Sie Ihre PIN ein."));
        }
    }

    protected void paint(Composite parent) throws Exception {
        super.paint(parent);
        this.getShell().pack();
    }

    protected boolean checkPassword(String password) {
        if (password == null || password.length() < HBCIProperties.HBCI_PIN_MINLENGTH || password.length() > HBCIProperties.HBCI_PIN_MAXLENGTH) {
            this.setErrorText(String.valueOf(i18n.tr("L\u00e4nge der PIN ung\u00fcltig ({0}-{1} Zeichen)", new String[]{Integer.toString(HBCIProperties.HBCI_PIN_MINLENGTH), Integer.toString(HBCIProperties.HBCI_PIN_MAXLENGTH)})) + " " + this.getRetryString());
            return false;
        }
        return true;
    }

    private String getRetryString() {
        String retries = this.getRemainingRetries() > 1 ? i18n.tr("Versuche") : i18n.tr("Versuch");
        return String.valueOf(i18n.tr("Noch")) + " " + this.getRemainingRetries() + " " + retries + ".";
    }
}

