/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.sepa.SepaVersion;

public class PainVersionDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 400;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private SepaVersion.Type type = null;
    private SepaVersion painVersion = null;
    private Button ok = null;

    public PainVersionDialog(SepaVersion.Type type) {
        super(1);
        this.setTitle(i18n.tr("SEPA XML-Version"));
        this.type = type;
        this.setSize(400, -1);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(i18n.tr("Bitte w\u00e4hlen Sie die zu verwendende SEPA XML-Version."), true);
        final SelectInput version = this.getPainVersionInput();
        final LabelInput msg = this.getMessage();
        c.addInput((Input)version);
        c.addInput((Input)msg);
        ButtonArea buttons = new ButtonArea();
        this.ok = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                PainVersionDialog.this.painVersion = (SepaVersion)version.getValue();
                if (PainVersionDialog.this.painVersion == null) {
                    msg.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie eine SEPA XML-Version aus."));
                    return;
                }
                PainVersionDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(this.ok);
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(400, -1));
    }

    private SelectInput getPainVersionInput() {
        List list = SepaVersion.getKnownVersions((SepaVersion.Type)this.type);
        final SelectInput select = new SelectInput(list, (Object)SepaVersion.findGreatest((List)list));
        select.setAttribute("file");
        select.setName(i18n.tr("Schema-Version der SEPA XML-Datei"));
        select.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (PainVersionDialog.this.ok != null) {
                    PainVersionDialog.this.ok.setEnabled(select.getValue() != null);
                }
            }
        });
        return select;
    }

    private LabelInput getMessage() {
        LabelInput label = new LabelInput("");
        label.setColor(Color.ERROR);
        label.setName("");
        return label;
    }

    protected Object getData() throws Exception {
        return this.painVersion;
    }
}

