/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.input.PassportInput;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.Composite;

public class PassportAuswahlDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 400;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Konto konto = null;
    private PassportInput input = null;
    private Passport passport = null;
    private LabelInput comment = null;

    public PassportAuswahlDialog(int position) {
        this(null, position);
    }

    public PassportAuswahlDialog(Konto konto, int position) {
        super(position);
        this.konto = konto;
        this.setTitle(i18n.tr("Auswahl des HBCI-Verfahrens"));
        this.setSize(400, -1);
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(i18n.tr("Bitte w\u00e4hlen Sie das zu verwendende HBCI-Verfahren aus."), false);
        c.addInput((Input)this.getInput());
        c.addInput((Input)this.getComment());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    PassportAuswahlDialog.this.passport = (Passport)PassportAuswahlDialog.this.getInput().getValue();
                    if (PassportAuswahlDialog.this.passport == null) {
                        PassportAuswahlDialog.this.getComment().setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie ein Verfahren aus."));
                        return;
                    }
                    PassportAuswahlDialog.this.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to choose passport", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Auswahl fehlgeschlagen: {0}", e.getMessage()));
                }
            }
        }, null, true, "ok.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException(i18n.tr("Vorgang abgebrochen"));
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(400, -1));
    }

    private PassportInput getInput() throws RemoteException {
        if (this.input == null) {
            this.input = new PassportInput(this.konto);
        }
        return this.input;
    }

    private LabelInput getComment() throws RemoteException {
        if (this.comment == null) {
            this.comment = new LabelInput("");
            this.comment.setName("");
            this.comment.setColor(Color.ERROR);
        }
        return this.comment;
    }

    protected Object getData() throws Exception {
        return this.passport;
    }
}

