/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.PassportDeleteBPD;
import de.willuhn.jameica.hbci.gui.parts.PassportPropertyList;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;
import org.kapott.hbci.passport.HBCIPassport;

public class PassportPropertyDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private HBCIPassport passport = null;

    public PassportPropertyDialog(int position, HBCIPassport passport) {
        super(position);
        this.setTitle(i18n.tr("BPD/UPD"));
        this.setSize(560, 400);
        this.passport = passport;
    }

    protected Object getData() throws Exception {
        return this.passport;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        container.addText(i18n.tr("Bank-Parameter (BPD) und User-Parameter (UPD) dieses Sicherheitsmediums"), true);
        final PassportPropertyList table = new PassportPropertyList(this.passport);
        table.paint(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("BPD l\u00f6schen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                String s = i18n.tr("Die BPD (Bank-Parameter-Daten) werden beim n\u00e4chsten Verbindungsaufbau \nmit der Bank automatisch (oder durch Klick auf \"Konfiguration testen\") erneut abgerufen.\n\nHinweis: Bei Verwendung einer Chipkarte m\u00fcssen Sie gleich die PIN eingeben.\n\nBPD jetzt l\u00f6schen?");
                try {
                    if (!Application.getCallback().askUser(s)) {
                        return;
                    }
                    new PassportDeleteBPD().handleAction(PassportPropertyDialog.this.passport);
                    table.clearBPD();
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("BPD gel\u00f6scht"), 0));
                }
                catch (OperationCanceledException oce) {
                    Logger.info((String)oce.getMessage());
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to delete bpd", (Throwable)e);
                }
            }
        }, null, false, "user-trash-full.png");
        buttons.addButton(i18n.tr("Schlie\u00dfen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                PassportPropertyDialog.this.close();
            }
        }, null, true, "window-close.png");
        buttons.paint(parent);
    }
}

