/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.ReminderIntervalInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class ReminderIntervalDialog
extends AbstractDialog<ReminderInterval> {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private ReminderInterval interval = null;
    private Date start = null;
    private Date end = null;
    private ReminderIntervalInput input = null;
    private DateInput endInput = null;
    private LabelInput error = null;
    private CheckboxInput checkbox = null;
    private TablePart preview = null;

    public ReminderIntervalDialog(ReminderInterval interval, Date start, Date end, int position) {
        super(position);
        this.interval = interval;
        this.end = end;
        this.setDate(start);
        this.setTitle(i18n.tr("Auswahl des Intervalls"));
        this.setSize(480, 650);
    }

    public void setDate(Date date) {
        this.start = date != null ? date : new Date();
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer ct = new SimpleContainer(parent, true);
        ct.addText(i18n.tr("Bei einer regelm\u00e4\u00dfigen Wiederholung wird der Auftrag im angegebenen Intervall (beginnend mit dem ersten Erinnerungstermin) automatisch durch Hibiscus dupliziert"), true);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ReminderIntervalDialog.this.updatePreview();
            }
        };
        final Button apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                boolean enabled = (Boolean)ReminderIntervalDialog.this.checkbox.getValue();
                ReminderIntervalDialog.this.interval = enabled ? (ReminderInterval)ReminderIntervalDialog.this.input.getValue() : null;
                ReminderIntervalDialog.this.close();
            }
        }, null, true, "ok.png");
        Button cancel = new Button(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        this.checkbox = new CheckboxInput(this.interval != null);
        this.checkbox.setName(i18n.tr("Auftrag regelm\u00e4\u00dfig wiederholen"));
        this.checkbox.addListener(listener);
        this.input = new ReminderIntervalInput(this.interval);
        this.input.addListener(listener);
        TextInput startInput = new TextInput(HBCI.DATEFORMAT.format(this.start));
        startInput.setEnabled(false);
        startInput.setName("Erste Ausf\u00fchrung");
        this.error = new LabelInput("");
        this.error.setName("");
        this.error.setColor(Color.ERROR);
        this.endInput = new DateInput(this.end, HBCI.DATEFORMAT);
        this.endInput.setName(i18n.tr("Letzte Ausf\u00fchrung"));
        Listener endCheck = new Listener(){

            public void handleEvent(Event event) {
                Date myEnd = (Date)ReminderIntervalDialog.this.endInput.getValue();
                if (myEnd != null && !myEnd.after(ReminderIntervalDialog.this.start)) {
                    ReminderIntervalDialog.this.error.setValue((Object)i18n.tr("End-Datum liegt vor Start-Datum"));
                    ReminderIntervalDialog.this.preview.removeAll();
                    apply.setEnabled(false);
                } else {
                    ReminderIntervalDialog.this.error.setValue((Object)"");
                    apply.setEnabled(true);
                }
            }
        };
        this.endInput.addListener(endCheck);
        this.endInput.addListener(listener);
        endCheck.handleEvent(null);
        this.preview = new TablePart(null);
        this.preview.addColumn(i18n.tr("Vorschau auf die n\u00e4chsten Folge-Termine"), null);
        this.preview.setSummary(false);
        this.preview.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                Date d = (Date)item.getData();
                item.setText(d != null ? HBCI.DATEFORMAT.format(d) : "-");
            }
        });
        this.updatePreview();
        ct.addInput((Input)this.checkbox);
        ct.addInput((Input)this.input);
        ct.addInput((Input)startInput);
        ct.addInput((Input)this.endInput);
        ct.addInput((Input)this.error);
        ct.addPart((Part)this.preview);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(apply);
        buttons.addButton(cancel);
        ct.addButtonArea(buttons);
    }

    protected ReminderInterval getData() throws Exception {
        return this.interval;
    }

    public Date getEnd() {
        return this.end;
    }

    private void updatePreview() {
        try {
            boolean enabled = (Boolean)this.checkbox.getValue();
            this.preview.setEnabled(enabled);
            this.input.setEnabled(enabled);
            this.endInput.setEnabled(enabled);
            this.preview.removeAll();
            if (!enabled) {
                return;
            }
            this.end = (Date)this.endInput.getValue();
            if (this.end != null && !this.end.after(this.start)) {
                return;
            }
            ReminderInterval ri = (ReminderInterval)this.input.getValue();
            Date from = new Date(this.start.getTime() + 60000L);
            Calendar cal = Calendar.getInstance();
            cal.setTime(from);
            cal.add(1, 11);
            List dates = ri.getDates(this.start, from, cal.getTime());
            int i = 0;
            while (i < dates.size()) {
                if (this.end == null || !((Date)dates.get(i)).after(this.end)) {
                    this.preview.addItem(dates.get(i));
                    if (i < 9) {
                        ++i;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to calculate next dates", (Throwable)e);
        }
    }
}

