/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.dialogs.AbstractExecuteDialog;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;

public class SepaDauerauftragDialog
extends AbstractExecuteDialog {
    private SepaDauerauftrag auftrag;

    public SepaDauerauftragDialog(SepaDauerauftrag d, int position) {
        super(position);
        this.auftrag = d;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addHeadline(i18n.tr("Details des SEPA-Dauerauftrages"));
        LabelInput kto = new LabelInput(this.auftrag.getKonto().getKontonummer());
        kto.setComment(this.auftrag.getKonto().getBezeichnung());
        group.addLabelPair(i18n.tr("Eigenes Konto"), (Input)kto);
        LabelInput empfName = new LabelInput(this.auftrag.getGegenkontoName());
        group.addLabelPair(i18n.tr("Name des Empf\u00e4nger"), (Input)empfName);
        LabelInput empfKto = new LabelInput(HBCIProperties.formatIban(this.auftrag.getGegenkontoNummer()));
        group.addLabelPair(i18n.tr("IBAN des Empf\u00e4ngers"), (Input)empfKto);
        LabelInput empfBic = new LabelInput(this.auftrag.getGegenkontoBLZ());
        group.addLabelPair(i18n.tr("BIC des Empf\u00e4ngers"), (Input)empfBic);
        LabelInput betrag = new LabelInput(String.valueOf(HBCI.DECIMALFORMAT.format(this.auftrag.getBetrag())) + " " + this.auftrag.getKonto().getWaehrung());
        betrag.setColor(Color.ERROR);
        group.addLabelPair(i18n.tr("Betrag"), (Input)betrag);
        group.addSeparator();
        Date e = this.auftrag.getErsteZahlung();
        String se = i18n.tr("Zum n\u00e4chstm\u00f6glichen Termin");
        if (e != null) {
            se = HBCI.DATEFORMAT.format(e);
        }
        LabelInput ersteZahlung = new LabelInput(se);
        group.addLabelPair(i18n.tr("Erste Zahlung"), (Input)ersteZahlung);
        Date l = this.auftrag.getLetzteZahlung();
        String sl = i18n.tr("keine End-Datum vorgegeben");
        if (l != null) {
            sl = HBCI.DATEFORMAT.format(l);
        }
        LabelInput letzteZahlung = new LabelInput(sl);
        group.addLabelPair(i18n.tr("Letzte Zahlung"), (Input)letzteZahlung);
        LabelInput turnus = new LabelInput(TurnusHelper.createBezeichnung(this.auftrag.getTurnus()));
        group.addLabelPair(i18n.tr("Zahlungsturnus"), (Input)turnus);
        group.addHeadline(i18n.tr("Verwendungszweck"));
        group.addText(VerwendungszweckUtil.toString(this.auftrag, "\n"), false);
        group.addSeparator();
        if (this.auftrag.isActive()) {
            group.addText(String.valueOf(i18n.tr("Sind Sie sicher, da\u00df Sie diese \u00c4nderungen jetzt zur Bank senden wollen?")) + "\n", true);
        } else {
            group.addText(String.valueOf(i18n.tr("Sind Sie sicher, da\u00df Sie diesen Dauerauftrag jetzt ausf\u00fchren wollen?")) + "\n", true);
        }
        super.paint(parent);
        this.getShell().setMinimumSize(this.getShell().computeSize(-1, -1));
    }
}

