/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.FileInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.ExportDialog;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaExportDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 600;
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private SepaVersion.Type type = null;
    private SepaVersion painVersion = null;
    private File file = null;
    private Button ok = null;

    public SepaExportDialog(SepaVersion.Type type) {
        super(1);
        this.setTitle(i18n.tr("SEPA-Datei exportieren"));
        this.type = type;
        this.setSize(600, -1);
        this.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (SepaExportDialog.this.file != null) {
                    ExportDialog.SETTINGS.setAttribute("lastdir", SepaExportDialog.this.file.getParent());
                }
            }
        });
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        final SelectInput version = this.getPainVersionInput();
        final FileInput target = this.getFileInput();
        final LabelInput msg = this.getMessage();
        c.addInput((Input)version);
        c.addInput((Input)target);
        c.addInput((Input)msg);
        ButtonArea buttons = new ButtonArea();
        this.ok = new Button(i18n.tr("Export starten"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                SepaExportDialog.this.painVersion = (SepaVersion)version.getValue();
                if (SepaExportDialog.this.painVersion == null) {
                    msg.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie eine Schema-Version aus."));
                    return;
                }
                String s = StringUtils.trimToNull((String)((String)target.getValue()));
                if (s == null) {
                    msg.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie eine Datei aus"));
                    return;
                }
                SepaExportDialog.this.file = new File(s);
                if (SepaExportDialog.this.file.exists() && SepaExportDialog.this.file.canRead()) {
                    try {
                        if (!Application.getCallback().askUser(i18n.tr("Datei existiert bereits. \u00dcberschreiben?"))) {
                            return;
                        }
                    }
                    catch (OperationCanceledException oce) {
                        return;
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while asking user to overwrite file", (Throwable)e);
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Export fehlgeschlagen: {0}", e.getMessage()), 1));
                    }
                }
                SepaExportDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(this.ok);
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(600, -1));
    }

    private SelectInput getPainVersionInput() {
        List list = SepaVersion.getKnownVersions((SepaVersion.Type)this.type);
        final SelectInput select = new SelectInput(list, (Object)SepaVersion.findGreatest((List)list));
        select.setAttribute("file");
        select.setName(i18n.tr("Schema-Version der SEPA-Datei"));
        select.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (SepaExportDialog.this.ok != null) {
                    SepaExportDialog.this.ok.setEnabled(select.getValue() != null);
                }
            }
        });
        return select;
    }

    private LabelInput getMessage() {
        LabelInput label = new LabelInput("");
        label.setColor(Color.ERROR);
        label.setName("");
        return label;
    }

    private FileInput getFileInput() {
        final String path = ExportDialog.SETTINGS.getString("lastdir", System.getProperty("user.home"));
        String name = this.type.getName();
        name = name.replace(" ", "-");
        name = "hibiscus-sepa-" + name + "-" + DATEFORMAT.format(new Date()) + ".xml";
        File f = new File(path, name);
        final FileInput input = new FileInput(f.getAbsolutePath(), true){

            protected void customize(FileDialog fd) {
                if (path != null && path.length() > 0) {
                    fd.setFilterPath(path);
                }
            }
        };
        input.setName(i18n.tr("SEPA XML-Datei"));
        input.setMandatory(true);
        input.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (SepaExportDialog.this.ok != null) {
                    String s = (String)input.getValue();
                    SepaExportDialog.this.ok.setEnabled(StringUtils.trimToNull((String)s) != null);
                }
            }
        });
        return input;
    }

    protected Object getData() throws Exception {
        return this.getFile();
    }

    public File getFile() {
        return this.file;
    }

    public SepaVersion getPainVersion() {
        return this.painVersion;
    }
}

