/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.dialogs.AbstractExecuteDialog;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import org.eclipse.swt.widgets.Composite;

public class SepaLastschriftDialog
extends AbstractExecuteDialog {
    private SepaLastschrift last;

    public SepaLastschriftDialog(SepaLastschrift u, int position) {
        super(position);
        this.last = u;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addHeadline(i18n.tr("Details der SEPA-Lastschrift"));
        LabelInput kto = new LabelInput(this.last.getKonto().getIban());
        kto.setComment(this.last.getKonto().getBezeichnung());
        group.addLabelPair(i18n.tr("Eigenes Konto"), (Input)kto);
        LabelInput empfName = new LabelInput(this.last.getGegenkontoName());
        group.addLabelPair(i18n.tr("Name des Zahlungspflichtigen"), (Input)empfName);
        LabelInput empfKto = new LabelInput(HBCIProperties.formatIban(this.last.getGegenkontoNummer()));
        group.addLabelPair(i18n.tr("IBAN des Zahlungspflichtigen"), (Input)empfKto);
        LabelInput empfBic = new LabelInput(this.last.getGegenkontoBLZ());
        group.addLabelPair(i18n.tr("BIC des Zahlungspflichtigen"), (Input)empfBic);
        LabelInput empfMandate = new LabelInput(this.last.getMandateId());
        group.addLabelPair(i18n.tr("Mandats-Referenz"), (Input)empfMandate);
        LabelInput betrag = new LabelInput(String.valueOf(HBCI.DECIMALFORMAT.format(this.last.getBetrag())) + " " + this.last.getKonto().getWaehrung());
        betrag.setColor(Color.ERROR);
        group.addLabelPair(i18n.tr("Betrag"), (Input)betrag);
        group.addHeadline(i18n.tr("Verwendungszweck"));
        group.addText(VerwendungszweckUtil.toString(this.last, "\n"), false);
        super.paint(parent);
        this.getShell().setMinimumSize(this.getShell().computeSize(-1, -1));
    }
}

