/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.AbstractExecuteDialog;
import de.willuhn.jameica.hbci.gui.parts.SepaSammelTransferBuchungList;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import org.eclipse.swt.widgets.Composite;

public class SepaSammelTransferDialog
extends AbstractExecuteDialog {
    private SepaSammelTransfer st;

    public SepaSammelTransferDialog(SepaSammelTransfer s, int position) {
        super(position);
        this.st = s;
        this.setSize(550, 440);
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SepaSammelUeberweisung ueb;
        SimpleContainer group = new SimpleContainer(parent, false);
        group.addHeadline(i18n.tr("Details des SEPA-Sammelauftrages"));
        group.addLabelPair(i18n.tr("Bezeichnung"), (Input)new LabelInput(this.st.getBezeichnung()));
        LabelInput kto = new LabelInput(this.st.getKonto().getIban());
        kto.setComment(this.st.getKonto().getBezeichnung());
        group.addLabelPair(i18n.tr("Eigenes Konto"), (Input)kto);
        LabelInput betrag = new LabelInput(String.valueOf(HBCI.DECIMALFORMAT.format(this.st.getSumme())) + " " + this.st.getKonto().getWaehrung());
        betrag.setColor(Color.ERROR);
        group.addLabelPair(i18n.tr("Summe"), (Input)betrag);
        if (this.st instanceof SepaSammelUeberweisung && (ueb = (SepaSammelUeberweisung)this.st).isTerminUeberweisung()) {
            LabelInput termin = new LabelInput(HBCI.DATEFORMAT.format(ueb.getTermin()));
            group.addLabelPair(i18n.tr("Ausf\u00fchrungstermin"), (Input)termin);
        }
        group.addHeadline(i18n.tr("Enthaltene Buchungen"));
        SepaSammelTransferBuchungList buchungen = new SepaSammelTransferBuchungList(this.st, null);
        buchungen.setMulti(false);
        buchungen.setSummary(false);
        buchungen.paint(parent);
        super.paint(parent);
    }
}

