/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;

public class SepaSammelTransferSplitDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private int count = 1;
    private boolean canDelete = false;
    private Boolean delete = null;
    private CheckboxInput check = null;

    public SepaSammelTransferSplitDialog(int position, int count, boolean canDelete) {
        super(position);
        this.count = count;
        this.canDelete = canDelete;
        this.setTitle(i18n.tr("In SEPA-Einzelauftr\u00e4ge teilen"));
        this.setSize(420, -1);
    }

    protected Object getData() throws Exception {
        return this.delete;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        if (this.count > 1) {
            container.addText(i18n.tr("Der Sammelauftrag wird in {0} Einzelauftr\u00e4ge geteilt.", String.valueOf(this.count)), true);
        } else {
            container.addText(i18n.tr("Der Sammelauftrag wird in einen Einzelauftrag kopiert."), true);
        }
        if (this.canDelete) {
            this.check = new CheckboxInput(false);
            this.check.setName(i18n.tr("Sammelauftrag nach der \u00dcbernahme l\u00f6schen"));
            container.addInput((Input)this.check);
        }
        ButtonArea b = new ButtonArea();
        b.addButton(i18n.tr("Fortsetzen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (SepaSammelTransferSplitDialog.this.check != null) {
                    SepaSammelTransferSplitDialog.this.delete = (Boolean)SepaSammelTransferSplitDialog.this.check.getValue();
                }
                SepaSammelTransferSplitDialog.this.close();
            }
        }, null, false, "ok.png");
        b.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(b);
        this.getShell().setMinimumSize(this.getShell().computeSize(350, -1));
    }
}

