/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.PasswordInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszug;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszugPdf;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaDauerauftragList;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaLastschrift;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SynchronizeOptionsDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 500;
    private Konto konto = null;
    private boolean offline = false;
    private boolean syncAvail = false;
    private SynchronizeOptions options = null;
    private CheckboxInput syncOffline = null;
    private CheckboxInput syncSaldo = null;
    private CheckboxInput syncUmsatz = null;
    private CheckboxInput syncKontoauszug = null;
    private CheckboxInput syncAueb = null;
    private CheckboxInput syncSepaLast = null;
    private CheckboxInput syncSepaDauer = null;
    private CheckboxInput syncMessages = null;
    private CheckboxInput useCamt = null;
    private LabelInput error = null;
    private Button apply = null;
    private Map<SynchronizeBackend, List<Input>> properties = new HashMap<SynchronizeBackend, List<Input>>();

    public SynchronizeOptionsDialog(Konto konto, int position) throws RemoteException {
        super(position);
        this.setTitle(i18n.tr("Synchronisierungsoptionen"));
        this.setSize(500, -1);
        this.konto = konto;
        this.options = new SynchronizeOptions(konto);
        this.offline = konto.hasFlag(2);
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeEngine engine = (SynchronizeEngine)service.get(SynchronizeEngine.class);
        this.syncAvail = engine.supports(SynchronizeJobKontoauszug.class, konto);
        if (this.syncAvail) {
            try {
                SynchronizeBackend backend = engine.getBackend(SynchronizeJobKontoauszug.class, konto);
                List<String> names = backend.getPropertyNames(konto);
                if (names != null && names.size() > 0) {
                    ArrayList<Input> props = new ArrayList<Input>();
                    this.properties.put(backend, props);
                    for (String name : names) {
                        props.add(this.createCustomProperty(name));
                    }
                }
            }
            catch (ApplicationException ae) {
                Logger.error((String)ae.getMessage());
            }
        }
    }

    private Input createCustomProperty(String name) throws RemoteException {
        TextInput t = null;
        if (name.endsWith("(true/false)")) {
            String newName = name.replace("(true/false)", "").trim();
            String value = this.konto.getMeta(newName, null);
            t = new CheckboxInput(value != null && Boolean.valueOf(value) != false);
            t.setName(newName);
        } else if (name.endsWith("(pwd)") || name.endsWith("(password)")) {
            String newName = name.replace("(pwd)", "").replace("(password)", "").trim();
            t = new PasswordInput(this.konto.getMeta(newName, null));
            t.setName(newName);
        } else {
            t = new TextInput(this.konto.getMeta(name, null));
            t.setName(name);
        }
        return t;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addHeadline(this.konto.getLongName());
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie aus, welche Gesch\u00e4ftsvorf\u00e4lle bei der Synchronisierung des Kontos ausgef\u00fchrt werden sollen."), true);
        this.apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (!SynchronizeOptionsDialog.this.offline || SynchronizeOptionsDialog.this.syncAvail) {
                    SynchronizeOptionsDialog.this.options.setSyncSaldo((Boolean)SynchronizeOptionsDialog.this.getSyncSaldo().getValue());
                    SynchronizeOptionsDialog.this.options.setSyncKontoauszuege((Boolean)SynchronizeOptionsDialog.this.getSyncUmsatz().getValue());
                    BPDUtil.Support support = BPDUtil.getSupport(SynchronizeOptionsDialog.this.konto, BPDUtil.Query.UmsatzCamt);
                    if (support != null && support.isSupported()) {
                        try {
                            Boolean value = (Boolean)SynchronizeOptionsDialog.this.getUseCamt().getValue();
                            MetaKey.UMSATZ_CAMT.set(SynchronizeOptionsDialog.this.konto, value.toString());
                        }
                        catch (RemoteException re) {
                            Logger.error((String)"unable to save changes", (Throwable)re);
                            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("\u00dcbernehmen der Einstellungen fehlgeschlagen: {0}", re.getMessage()), 1));
                        }
                    }
                }
                if (SynchronizeOptionsDialog.this.offline) {
                    SynchronizeOptionsDialog.this.options.setSyncOffline((Boolean)SynchronizeOptionsDialog.this.getSyncOffline().getValue());
                } else {
                    SynchronizeOptionsDialog.this.options.setSyncKontoauszuegePdf((Boolean)SynchronizeOptionsDialog.this.getSyncKontoauszug().getValue());
                    SynchronizeOptionsDialog.this.options.setSyncMessages((Boolean)SynchronizeOptionsDialog.this.getSyncMessages().getValue());
                    SynchronizeOptionsDialog.this.options.setSyncSepaDauerauftraege((Boolean)SynchronizeOptionsDialog.this.getSyncSepaDauer().getValue());
                    SynchronizeOptionsDialog.this.options.setSyncAuslandsUeberweisungen((Boolean)SynchronizeOptionsDialog.this.getSyncAueb().getValue());
                    SynchronizeOptionsDialog.this.options.setSyncSepaLastschriften((Boolean)SynchronizeOptionsDialog.this.getSyncSepaLast().getValue());
                }
                try {
                    for (List<Input> l : SynchronizeOptionsDialog.this.properties.values()) {
                        for (Input prop : l) {
                            Object value = prop.getValue();
                            SynchronizeOptionsDialog.this.konto.setMeta(prop.getName(), value != null ? value.toString() : null);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to apply properties", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("\u00dcbernehmen der Optionen fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                SynchronizeOptionsDialog.this.close();
            }
        }, null, true, "ok.png");
        CheckboxInput i1 = this.getSyncSaldo();
        CheckboxInput i2 = this.getSyncUmsatz();
        CheckboxInput i3 = this.getSyncOffline();
        CheckboxInput i4 = this.getSyncAueb();
        CheckboxInput i5 = this.getSyncSepaLast();
        CheckboxInput i6 = this.getSyncSepaDauer();
        CheckboxInput i7 = this.getSyncMessages();
        CheckboxInput i8 = this.getSyncKontoauszug();
        CheckboxInput camt = null;
        if (!this.offline || this.syncAvail) {
            BPDUtil.Support support = BPDUtil.getSupport(this.konto, BPDUtil.Query.UmsatzCamt);
            if (!this.offline && support != null && support.isSupported()) {
                camt = this.getUseCamt();
            }
            group.addInput((Input)i1);
            group.addInput((Input)i2);
        }
        if (this.offline) {
            group.addInput((Input)i3);
        } else {
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeEngine engine = (SynchronizeEngine)service.get(SynchronizeEngine.class);
            if (engine.supports(SynchronizeJobKontoauszugPdf.class, this.konto)) {
                group.addInput((Input)i8);
            }
            if (engine.supports(SynchronizeJobSepaUeberweisung.class, this.konto)) {
                group.addInput((Input)i4);
            }
            if (engine.supports(SynchronizeJobSepaLastschrift.class, this.konto)) {
                group.addInput((Input)i5);
            }
            if (engine.supports(SynchronizeJobSepaDauerauftragList.class, this.konto)) {
                group.addInput((Input)i6);
            }
            group.addInput((Input)i7);
        }
        if (camt != null && (!this.offline || this.syncAvail)) {
            group.addHeadline(i18n.tr("Erweiterte Einstellungen: FinTS"));
            group.addInput((Input)camt);
        }
        if (this.properties.size() > 0) {
            for (Map.Entry<SynchronizeBackend, List<Input>> e : this.properties.entrySet()) {
                group.addHeadline(i18n.tr("Erweiterte Einstellungen: {0}", e.getKey().getName()));
                for (Input prop : e.getValue()) {
                    group.addInput(prop);
                }
            }
        }
        group.addInput((Input)this.getErrorLabel());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.apply);
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                SynchronizeOptionsDialog.this.close();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
    }

    private CheckboxInput getSyncSaldo() {
        if (this.syncSaldo == null) {
            this.syncSaldo = new CheckboxInput(this.options.getSyncSaldo());
            this.syncSaldo.setName(i18n.tr("Saldo abrufen"));
        }
        return this.syncSaldo;
    }

    private CheckboxInput getSyncUmsatz() {
        if (this.syncUmsatz == null) {
            this.syncUmsatz = new CheckboxInput(this.options.getSyncKontoauszuege());
            this.syncUmsatz.setName(i18n.tr("Ums\u00e4tze abrufen"));
            if (this.offline) {
                this.syncUmsatz.addListener((Listener)new OfflineListener());
            }
        }
        return this.syncUmsatz;
    }

    private CheckboxInput getUseCamt() {
        if (this.useCamt == null) {
            this.useCamt = new CheckboxInput(KontoUtil.useCamt(this.konto, false));
            this.useCamt.setName(i18n.tr("Ums\u00e4tze im neuen SEPA CAMT-Format abrufen"));
            final CheckboxInput syncUms = this.getSyncUmsatz();
            Listener l = new Listener(){

                public void handleEvent(Event event) {
                    SynchronizeOptionsDialog.this.useCamt.setEnabled(((Boolean)syncUms.getValue()).booleanValue());
                }
            };
            syncUms.addListener(l);
            l.handleEvent(null);
        }
        return this.useCamt;
    }

    private CheckboxInput getSyncKontoauszug() {
        if (this.syncKontoauszug != null) {
            return this.syncKontoauszug;
        }
        this.syncKontoauszug = new CheckboxInput(this.options.getSyncKontoauszuegePdf());
        this.syncKontoauszug.setName(i18n.tr("Elektronischen Kontoauszug abrufen"));
        boolean supported = KontoauszugPdfUtil.supported(this.konto);
        this.syncKontoauszug.setEnabled(supported);
        if (!supported) {
            this.syncKontoauszug.setValue((Object)supported);
        }
        return this.syncKontoauszug;
    }

    private CheckboxInput getSyncSepaDauer() {
        if (this.syncSepaDauer == null) {
            this.syncSepaDauer = new CheckboxInput(this.options.getSyncSepaDauerauftraege());
            this.syncSepaDauer.setName(i18n.tr("SEPA-Dauerauftr\u00e4ge synchronisieren"));
        }
        return this.syncSepaDauer;
    }

    private CheckboxInput getSyncAueb() {
        if (this.syncAueb == null) {
            this.syncAueb = new CheckboxInput(this.options.getSyncAuslandsUeberweisungen());
            this.syncAueb.setName(i18n.tr("F\u00e4llige SEPA-\u00dcberweisungen absenden"));
        }
        return this.syncAueb;
    }

    private CheckboxInput getSyncSepaLast() {
        if (this.syncSepaLast == null) {
            this.syncSepaLast = new CheckboxInput(this.options.getSyncSepaLastschriften());
            this.syncSepaLast.setName(i18n.tr("F\u00e4llige SEPA-Lastschriften einziehen"));
        }
        return this.syncSepaLast;
    }

    private CheckboxInput getSyncMessages() {
        if (this.syncMessages != null) {
            return this.syncMessages;
        }
        this.syncMessages = new CheckboxInput(this.options.getSyncMessages());
        this.syncMessages.setName(i18n.tr("Banknachrichten abrufen"));
        CheckboxInput i1 = this.getSyncSaldo();
        CheckboxInput i2 = this.getSyncUmsatz();
        CheckboxInput i3 = this.getSyncAueb();
        CheckboxInput i4 = this.getSyncSepaLast();
        CheckboxInput i5 = this.getSyncSepaDauer();
        CheckboxInput i6 = this.getSyncKontoauszug();
        Listener l = new Listener((Input)i1, (Input)i2, (Input)i3, (Input)i4, (Input)i5, (Input)i6){
            private final /* synthetic */ Input val$i1;
            private final /* synthetic */ Input val$i2;
            private final /* synthetic */ Input val$i3;
            private final /* synthetic */ Input val$i4;
            private final /* synthetic */ Input val$i5;
            private final /* synthetic */ Input val$i6;
            {
                this.val$i1 = input;
                this.val$i2 = input2;
                this.val$i3 = input3;
                this.val$i4 = input4;
                this.val$i5 = input5;
                this.val$i6 = input6;
            }

            public void handleEvent(Event event) {
                boolean b = (Boolean)this.val$i1.getValue();
                b |= ((Boolean)this.val$i2.getValue()).booleanValue();
                b |= ((Boolean)this.val$i3.getValue()).booleanValue();
                b |= ((Boolean)this.val$i4.getValue()).booleanValue();
                b |= ((Boolean)this.val$i5.getValue()).booleanValue();
                SynchronizeOptionsDialog.this.syncMessages.setEnabled(b |= ((Boolean)this.val$i6.getValue()).booleanValue());
            }
        };
        i1.addListener(l);
        i2.addListener(l);
        i3.addListener(l);
        i4.addListener(l);
        i5.addListener(l);
        i6.addListener(l);
        l.handleEvent(null);
        return this.syncMessages;
    }

    private CheckboxInput getSyncOffline() {
        if (this.syncOffline == null) {
            this.syncOffline = new CheckboxInput(this.options.getSyncOffline());
            this.syncOffline.setName(i18n.tr("Passende Gegenbuchungen automatisch anlegen"));
            this.syncOffline.addListener((Listener)new OfflineListener());
        }
        return this.syncOffline;
    }

    private LabelInput getErrorLabel() {
        if (this.error == null) {
            this.error = new LabelInput("\n");
            this.error.setColor(Color.ERROR);
        }
        return this.error;
    }

    protected Object getData() throws Exception {
        return null;
    }

    private class OfflineListener
    implements Listener {
        private OfflineListener() {
        }

        public void handleEvent(Event event) {
            if (SynchronizeOptionsDialog.this.offline && SynchronizeOptionsDialog.this.syncAvail) {
                boolean a = (Boolean)SynchronizeOptionsDialog.this.getSyncOffline().getValue();
                boolean b = (Boolean)SynchronizeOptionsDialog.this.getSyncUmsatz().getValue();
                if (a && b) {
                    SynchronizeOptionsDialog.this.getErrorLabel().setValue((Object)i18n.tr("Umsatzabruf und Anlegen von Gegenbuchungen\nk\u00f6nnen nicht zusammen aktiviert werden."));
                } else {
                    SynchronizeOptionsDialog.this.getErrorLabel().setValue((Object)"\n");
                }
                SynchronizeOptionsDialog.this.apply.setEnabled(!a || !b);
            }
        }
    }
}

