/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.input.ScaleInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.JameicaCompat;
import de.willuhn.jameica.hbci.SynchronizeSchedulerSettings;
import de.willuhn.jameica.hbci.rmi.SynchronizeSchedulerService;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SynchronizeSchedulerOptionsDialog
extends AbstractDialog<Void> {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 540;
    private CheckboxInput enabled = null;
    private CheckboxInput stopOnError = null;
    private CheckboxInput minimizeToSystray = null;
    private ScaleInput interval = null;
    private List<CheckboxInput> weekdays = null;
    private SelectInput timeFrom = null;
    private SelectInput timeTo = null;

    public SynchronizeSchedulerOptionsDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Automatische Synchronisierung konfigurieren"));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer c1 = new SimpleContainer(parent);
        c1.addPart((Part)this.getEnabled());
        c1.addPart((Part)this.getStopOnError());
        c1.addInput((Input)this.getInterval());
        c1.addText(i18n.tr("Mehr als 4 Synchronisierungen pro Tag k\u00f6nnen dazu f\u00fchren, dass die Bank eine TAN verlangt."), true, Color.COMMENT);
        c1.addHeadline(i18n.tr("Wochentage einschr\u00e4nken"));
        c1.addText(i18n.tr("Die automatische Synchronisierung wird nur an den angegebenen Wochentagen ausgef\u00fchrt. An den nicht ausgew\u00e4hlten Tagen wird sie pausiert."), true, Color.COMMENT);
        for (CheckboxInput c : this.getWeekdays()) {
            c1.addPart((Part)c);
        }
        c1.addHeadline(i18n.tr("Uhrzeit einschr\u00e4nken"));
        c1.addText(i18n.tr("Die automatische Synchronisierung wird nur im angegebenen Zeitfenster ausgef\u00fchrt. In der \u00fcbrigen Zeit wird sie pausiert."), true, Color.COMMENT);
        MultiInput multi = new MultiInput(new Input[]{this.getTimeFrom(), this.getTimeTo()});
        c1.addInput((Input)multi);
        Input sysCheck = this.getMinimizeToSystray();
        if (sysCheck != null) {
            c1.addHeadline(i18n.tr("System-Tray"));
            c1.addPart((Part)sysCheck);
            c1.addText(i18n.tr("Sie finden diese Option auch in \"Datei->Einstellungen->Look and Feel\""), true, Color.COMMENT);
        }
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), a -> {
            if (sysCheck != null) {
                this.setSystrayParameter("setEnabled");
                this.setSystrayParameter("setMinimizeToSystray");
            }
            boolean enabled = (Boolean)this.getEnabled().getValue();
            SynchronizeSchedulerSettings.setEnabled(enabled);
            SynchronizeSchedulerSettings.setSchedulerInterval((Integer)this.getInterval().getValue());
            SynchronizeSchedulerSettings.setSchedulerStartTime((Integer)this.getTimeFrom().getValue());
            SynchronizeSchedulerSettings.setSchedulerEndTime((Integer)this.getTimeTo().getValue());
            boolean stop = (Boolean)this.getStopOnError().getValue();
            SynchronizeSchedulerSettings.setStopSchedulerOnError(stop);
            for (CheckboxInput ci : this.getWeekdays()) {
                Integer day = (Integer)ci.getData("day");
                SynchronizeSchedulerSettings.setSchedulerIncludeDay(day, (Boolean)ci.getValue());
            }
            try {
                SynchronizeSchedulerService scheduler = (SynchronizeSchedulerService)Application.getServiceFactory().lookup(HBCI.class, "synchronizescheduler");
                if (enabled) {
                    if (!scheduler.isStarted()) {
                        scheduler.start();
                    }
                } else if (scheduler.isStarted()) {
                    scheduler.stop(true);
                }
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            }
            catch (Exception e) {
                Logger.error((String)"error while loading synchronize scheduler status", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Status der automatischen Synchronisierung nicht ermittelbar: {0}", e.getMessage()), 1));
            }
            this.close();
            GUI.getCurrentView().reload();
        }, null, true, "ok.png");
        buttons.addButton((Button)new Cancel());
        c1.addButtonArea(buttons);
        Point size = this.getShell().computeSize(540, -1);
        this.getShell().setMinimumSize(size);
        this.setSize(size.x, size.y);
    }

    private Object getSystrayService() {
        try {
            Class c = Application.getClassLoader().load("de.willuhn.jameica.services.SystrayService");
            return Application.getBootLoader().getBootable(c);
        }
        catch (Exception e) {
            Logger.info((String)"systray service not found - jameica version too old");
            return null;
        }
    }

    private void setSystrayParameter(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Object systray = this.getSystrayService();
        Input input = this.getMinimizeToSystray();
        if (systray == null || input == null) {
            return;
        }
        boolean value = (Boolean)input.getValue();
        try {
            Method m = systray.getClass().getMethod(name, Boolean.TYPE);
            m.invoke(systray, value);
        }
        catch (Exception e) {
            Logger.error((String)"unable to apply systray service settings", (Throwable)e);
        }
    }

    private CheckboxInput getEnabled() {
        if (this.enabled != null) {
            return this.enabled;
        }
        this.enabled = new CheckboxInput(SynchronizeSchedulerSettings.isEnabled());
        this.enabled.setName(i18n.tr("Automatische Synchronisierung aktivieren"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                boolean b = (Boolean)SynchronizeSchedulerOptionsDialog.this.getEnabled().getValue();
                SynchronizeSchedulerOptionsDialog.this.getInterval().setEnabled(b);
                SynchronizeSchedulerOptionsDialog.this.getStopOnError().setEnabled(b);
                SynchronizeSchedulerOptionsDialog.this.getTimeFrom().setEnabled(b);
                SynchronizeSchedulerOptionsDialog.this.getTimeTo().setEnabled(b);
                for (CheckboxInput i : SynchronizeSchedulerOptionsDialog.this.getWeekdays()) {
                    i.setEnabled(b);
                }
            }
        };
        this.enabled.addListener(l);
        l.handleEvent(null);
        return this.enabled;
    }

    public ScaleInput getInterval() {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new ScaleInput(SynchronizeSchedulerSettings.getSchedulerInterval());
        this.interval.setScaling(60, 1440, 60, 60);
        this.interval.setName(i18n.tr("Ausf\u00fchrungsintervall"));
        this.interval.setComment("");
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                int i = (Integer)SynchronizeSchedulerOptionsDialog.this.interval.getValue();
                if (i % 60 == 0) {
                    if (i == 60) {
                        SynchronizeSchedulerOptionsDialog.this.interval.setComment(i18n.tr("1 Stunde"));
                    } else {
                        SynchronizeSchedulerOptionsDialog.this.interval.setComment(i18n.tr("{0} Stunden", Integer.toString(i / 60)));
                    }
                } else {
                    SynchronizeSchedulerOptionsDialog.this.interval.setComment(i18n.tr("{0} Minuten", Integer.toString(i)));
                }
            }
        };
        this.interval.addListener(l);
        l.handleEvent(null);
        return this.interval;
    }

    public Input getMinimizeToSystray() {
        Boolean b;
        block5: {
            if (this.minimizeToSystray != null) {
                return this.minimizeToSystray;
            }
            Object service = this.getSystrayService();
            if (service == null) {
                return null;
            }
            try {
                b = (Boolean)JameicaCompat.get(service, "isEnabled", null);
                if (b != null) break block5;
                return null;
            }
            catch (Exception e) {
                Logger.info((String)"systray service not found - jameica version too old");
                return null;
            }
        }
        this.minimizeToSystray = new CheckboxInput(b.booleanValue());
        this.minimizeToSystray.setName(i18n.tr("Fenster beim Minimieren in System-Tray verschieben"));
        return this.minimizeToSystray;
    }

    private CheckboxInput getStopOnError() {
        if (this.stopOnError != null) {
            return this.stopOnError;
        }
        this.stopOnError = new CheckboxInput(SynchronizeSchedulerSettings.getStopSchedulerOnError());
        this.stopOnError.setName(i18n.tr("Im Fehlerfall anhalten"));
        return this.stopOnError;
    }

    private List<CheckboxInput> getWeekdays() {
        if (this.weekdays != null) {
            return this.weekdays;
        }
        DateFormatSymbols symbols = new DateFormatSymbols(Application.getConfig().getLocale());
        String[] dayNames = symbols.getWeekdays();
        this.weekdays = new ArrayList<CheckboxInput>();
        for (int i : Arrays.asList(2, 3, 4, 5, 6, 7, 1)) {
            CheckboxInput c = new CheckboxInput(SynchronizeSchedulerSettings.getSchedulerIncludeDay(i));
            c.setName(dayNames[i]);
            c.setData("day", (Object)i);
            this.weekdays.add(c);
        }
        return this.weekdays;
    }

    private SelectInput getTimeFrom() {
        if (this.timeFrom != null) {
            return this.timeFrom;
        }
        this.timeFrom = new SelectInput(this.getHours(), (Object)SynchronizeSchedulerSettings.getSchedulerStartTime());
        this.timeFrom.setEditable(false);
        this.timeFrom.setComment(i18n.tr("Uhr"));
        this.timeFrom.setName(i18n.tr("Nur in der Zeit von"));
        return this.timeFrom;
    }

    private SelectInput getTimeTo() {
        if (this.timeTo != null) {
            return this.timeTo;
        }
        this.timeTo = new SelectInput(this.getHours(), (Object)SynchronizeSchedulerSettings.getSchedulerEndTime());
        this.timeTo.setEditable(false);
        this.timeTo.setComment(i18n.tr("Uhr"));
        this.timeTo.setName(i18n.tr("bis"));
        return this.timeTo;
    }

    private List<Integer> getHours() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < 24) {
            result.add(i);
            ++i;
        }
        return result;
    }

    protected Void getData() throws Exception {
        return null;
    }
}

