/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TransferMergeDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private SammelTransfer transfer = null;
    private Boolean delete = Boolean.FALSE;
    private CheckboxInput useExisting = null;
    private SelectInput existing = null;
    private KontoInput konto = null;
    private TextInput bezeichnung = null;

    public TransferMergeDialog(SammelTransfer t, int position) {
        super(position);
        this.transfer = t;
        this.setTitle(i18n.tr("Auftr\u00e4ge zusammenf\u00fchren"));
        this.setSize(550, -1);
    }

    protected Object getData() throws Exception {
        return this.transfer;
    }

    protected void paint(Composite parent) throws Exception {
        if (this.transfer.ausgefuehrt()) {
            throw new ApplicationException(i18n.tr("Der Auftrag wurde bereits ausgef\u00fchrt"));
        }
        SimpleContainer container = new SimpleContainer(parent);
        container.addInput((Input)this.getUseExisting());
        container.addInput((Input)this.getExistingList());
        container.addSeparator();
        container.addInput((Input)this.getKonto());
        container.addInput((Input)this.getBezeichnung());
        final CheckboxInput delBox = new CheckboxInput(this.delete.booleanValue());
        container.addCheckbox(delBox, i18n.tr("Einzelauftr\u00e4ge nach \u00dcbernahme in den Sammel-Auftrag l\u00f6schen"));
        final LabelInput comment = new LabelInput("");
        comment.setColor(Color.ERROR);
        container.addLabelPair("", (Input)comment);
        ButtonArea b = new ButtonArea();
        b.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    TransferMergeDialog.this.delete = (Boolean)delBox.getValue();
                    boolean use = (Boolean)TransferMergeDialog.this.getUseExisting().getValue();
                    if (use) {
                        TransferMergeDialog.this.transfer = (SammelTransfer)TransferMergeDialog.this.getExistingList().getValue();
                        if (TransferMergeDialog.this.transfer == null) {
                            comment.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus."));
                            return;
                        }
                    } else {
                        Konto konto = (Konto)TransferMergeDialog.this.getKonto().getValue();
                        if (konto == null) {
                            comment.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus."));
                            return;
                        }
                        TransferMergeDialog.this.transfer.setKonto(konto);
                        String text = (String)TransferMergeDialog.this.getBezeichnung().getValue();
                        if (text == null || text.length() == 0) {
                            comment.setValue((Object)i18n.tr("Bitte geben Sie eine Bezeichnung ein."));
                            return;
                        }
                        TransferMergeDialog.this.transfer.setBezeichnung(text);
                        TransferMergeDialog.this.transfer.setTermin(new Date());
                    }
                }
                catch (RemoteException e) {
                    Logger.error((String)"error while checking transfer", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des Auftrages"));
                }
                TransferMergeDialog.this.close();
            }
        }, null, false, "ok.png");
        b.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(b);
        this.getShell().setMinimumSize(this.getShell().computeSize(550, -1));
    }

    public boolean getDelete() {
        return this.delete;
    }

    private CheckboxInput getUseExisting() throws RemoteException {
        if (this.useExisting != null) {
            return this.useExisting;
        }
        this.useExisting = new CheckboxInput(false);
        this.useExisting.setName(i18n.tr("Einem existierenden Sammel-Auftrag zuordnen"));
        this.useExisting.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    boolean use = (Boolean)TransferMergeDialog.this.useExisting.getValue();
                    TransferMergeDialog.this.getExistingList().setEnabled(use);
                    TransferMergeDialog.this.getKonto().setEnabled(!use);
                    TransferMergeDialog.this.getBezeichnung().setEnabled(!use);
                }
                catch (Exception e) {
                    Logger.error((String)"error while switching state", (Throwable)e);
                }
            }
        });
        return this.useExisting;
    }

    private SelectInput getExistingList() throws RemoteException {
        if (this.existing != null) {
            return this.existing;
        }
        HBCIDBService service = Settings.getDBService();
        DBIterator list = this.transfer.getList();
        list.addFilter("ausgefuehrt = 0");
        list.setOrder("ORDER BY " + service.getSQLTimestamp("termin") + " DESC, id DESC");
        this.existing = new SelectInput((GenericIterator)list, null);
        this.existing.setName(i18n.tr("Existierende Auftr\u00e4ge"));
        this.existing.setPleaseChoose(i18n.tr("Bitte w\u00e4hlen..."));
        this.existing.setEnabled(false);
        if (list.size() == 0) {
            this.getUseExisting().setValue((Object)Boolean.FALSE);
            this.getUseExisting().setEnabled(false);
        }
        return this.existing;
    }

    private SelectInput getKonto() throws RemoteException {
        if (this.konto == null) {
            this.konto = new KontoInput(this.transfer.getKonto(), KontoFilter.ONLINE);
            this.konto.setMandatory(true);
        }
        return this.konto;
    }

    private TextInput getBezeichnung() throws RemoteException {
        if (this.bezeichnung != null) {
            return this.bezeichnung;
        }
        String s = this.transfer.getBezeichnung();
        if (s == null || s.length() == 0) {
            s = i18n.tr("Sammel-Auftrag vom {0}", HBCI.DATEFORMAT.format(new Date()));
        }
        this.bezeichnung = new TextInput(s, 255);
        this.bezeichnung.setMandatory(true);
        this.bezeichnung.setName(i18n.tr("Bezeichnung"));
        return this.bezeichnung;
    }
}

