/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.dialogs.TurnusEditDialog;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class TurnusDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private TablePart turnusList = null;
    private Turnus turnus = null;

    public TurnusDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Zahlungsturnus ausw\u00e4hlen"));
    }

    protected void paint(Composite parent) throws Exception {
        this.turnusList = new TablePart((GenericIterator)Settings.getDBService().createList(Turnus.class), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    TurnusDialog.this.turnus = (Turnus)context;
                }
                catch (Exception e) {
                    Logger.error((String)"error while choosing turnus", (Throwable)e);
                }
                TurnusDialog.this.close();
            }
        });
        this.turnusList.addColumn(i18n.tr("Bezeichnung"), "bezeichnung");
        this.turnusList.setMulti(false);
        this.turnusList.setSummary(false);
        this.turnusList.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    Turnus t = (Turnus)item.getData();
                    if (t.isInitial()) {
                        item.setForeground(Settings.getBuchungSollForeground());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while formatting turnus", (Throwable)e);
                }
            }
        });
        ContextMenu c = new ContextMenu();
        c.addItem(new ContextMenuItem(i18n.tr("Neu..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                TurnusDialog.this.handleEdit(null);
            }
        }));
        c.addItem(new ContextMenuItem(i18n.tr("Bearbeiten..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof Turnus)) {
                    return;
                }
                TurnusDialog.this.handleEdit((Turnus)context);
            }
        }){

            public boolean isEnabledFor(Object o) {
                block4: {
                    if (o != null && o instanceof Turnus) break block4;
                    return false;
                }
                try {
                    Turnus t = (Turnus)o;
                    if (t.isInitial()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while checking context menu item", (Throwable)e);
                }
                return super.isEnabledFor(o);
            }
        });
        c.addItem(new ContextMenuItem(i18n.tr("L\u00f6schen..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof Turnus)) {
                    return;
                }
                try {
                    Turnus t = (Turnus)context;
                    t.delete();
                }
                catch (Exception e) {
                    Logger.error((String)"error while deleting turnus", (Throwable)e);
                }
            }
        }){

            public boolean isEnabledFor(Object o) {
                block4: {
                    if (o != null && o instanceof Turnus) break block4;
                    return false;
                }
                try {
                    Turnus t = (Turnus)o;
                    if (t.isInitial()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while checking context menu item", (Throwable)e);
                }
                return super.isEnabledFor(o);
            }
        });
        this.turnusList.setContextMenu(c);
        SimpleContainer container = new SimpleContainer(parent);
        container.addPart((Part)this.turnusList);
        ButtonArea buttonArea = new ButtonArea();
        buttonArea.addButton(i18n.tr("Neu"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                TurnusDialog.this.handleEdit(null);
            }
        }, null, false, "document-new.png");
        buttonArea.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    TurnusDialog.this.turnus = (Turnus)TurnusDialog.this.turnusList.getSelection();
                }
                catch (Exception e) {
                    Logger.error((String)"error while choosing turnus", (Throwable)e);
                }
                TurnusDialog.this.close();
            }
        }, null, true, "ok.png");
        buttonArea.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                TurnusDialog.this.turnus = null;
                TurnusDialog.this.close();
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttonArea);
    }

    private void handleEdit(Turnus t) {
        boolean isNew = t == null;
        TurnusEditDialog te = new TurnusEditDialog(0, t);
        try {
            Turnus t2 = (Turnus)te.open();
            if (t2 != null) {
                if (isNew) {
                    this.turnusList.addItem((Object)t2);
                } else {
                    int index = this.turnusList.removeItem((Object)t2);
                    if (index == -1) {
                        return;
                    }
                    this.turnusList.addItem((Object)t2, index);
                }
                this.turnusList.select((Object)t2);
            }
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (Exception e) {
            Logger.error((String)"error while adding turnus", (Throwable)e);
        }
    }

    protected Object getData() throws Exception {
        return this.turnus;
    }
}

