/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TurnusEditDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Turnus turnus = null;
    private SelectInput intervall = null;
    private SelectInput zeiteinheit = null;
    private SelectInput tagMonatlich = null;
    private SelectInput tagWoechentlich = null;
    private LabelInput error = null;
    private String pleaseChoose = i18n.tr("Bitte w\u00e4hlen...");
    private String lastOfMonth = i18n.tr("Zum Monatsletzten");

    public TurnusEditDialog(int position, Turnus turnus) {
        super(position);
        this.setTitle(i18n.tr("Zahlungsturnus anlegen/bearbeiten"));
        this.turnus = turnus;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        try {
            group.addLabelPair(i18n.tr("Zeiteinheit"), (Input)this.getZeiteinheit());
            group.addLabelPair(i18n.tr("Zahlung aller"), (Input)this.getIntervall());
            group.addLabelPair(i18n.tr("Zahlung am"), (Input)this.getTagWoechentlich());
            group.addLabelPair("", (Input)this.getTagMonatlich());
            group.addInput((Input)this.getError());
        }
        catch (RemoteException e) {
            Logger.error((String)"error while reading turnus", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Lesen des Zahlungsturnus."));
        }
        ButtonArea buttonArea = new ButtonArea();
        buttonArea.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    TurnusEditDialog.this.handleStore();
                    TurnusEditDialog.this.close();
                }
                catch (ApplicationException ae) {
                    TurnusEditDialog.this.getError().setValue((Object)ae.getMessage());
                }
            }
        }, null, true, "ok.png");
        buttonArea.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                TurnusEditDialog.this.close();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(buttonArea);
    }

    protected Object getData() throws Exception {
        return this.getTurnus();
    }

    private LabelInput getError() {
        if (this.error == null) {
            this.error = new LabelInput("");
            this.error.setColor(Color.ERROR);
            this.error.setName("");
        }
        return this.error;
    }

    private Turnus getTurnus() throws RemoteException {
        if (this.turnus == null) {
            this.turnus = (Turnus)Settings.getDBService().createObject(Turnus.class, null);
        }
        return this.turnus;
    }

    public SelectInput getIntervall() throws RemoteException {
        if (this.intervall != null) {
            return this.intervall;
        }
        this.intervall = new SelectInput((Object[])new String[]{this.pleaseChoose, "1", "2", "3", "4", "5", "6", "12"}, (Object)("" + this.getTurnus().getIntervall()));
        if (this.getTurnus().getZeiteinheit() == 2) {
            this.intervall.setComment(i18n.tr("Monate"));
        } else {
            this.intervall.setComment(i18n.tr("Wochen"));
        }
        return this.intervall;
    }

    public SelectInput getZeiteinheit() throws RemoteException {
        if (this.zeiteinheit != null) {
            return this.zeiteinheit;
        }
        GenericObject[] values = new GenericObject[]{new Zeiteinheit(2), new Zeiteinheit(1)};
        this.zeiteinheit = new SelectInput(PseudoIterator.fromArray((GenericObject[])values), (GenericObject)new Zeiteinheit(this.getTurnus().getZeiteinheit()));
        this.zeiteinheit.addListener((Listener)new TagListener());
        return this.zeiteinheit;
    }

    public SelectInput getTagMonatlich() throws RemoteException {
        if (this.tagMonatlich != null) {
            return this.tagMonatlich;
        }
        Object[] values = new String[32];
        values[0] = this.pleaseChoose;
        int i = 1;
        while (i < 31) {
            values[i] = "" + i;
            ++i;
        }
        values[31] = this.lastOfMonth;
        this.tagMonatlich = new SelectInput(values, (Object)("" + this.getTurnus().getTag()));
        return this.tagMonatlich;
    }

    public SelectInput getTagWoechentlich() throws RemoteException {
        if (this.tagWoechentlich != null) {
            return this.tagWoechentlich;
        }
        GenericObject[] values = new GenericObject[8];
        values[0] = new Tag(-1);
        int i = 1;
        while (i < 8) {
            values[i] = new Tag(i);
            ++i;
        }
        this.tagWoechentlich = new SelectInput(PseudoIterator.fromArray((GenericObject[])values), (GenericObject)new Tag(this.getTurnus().getTag()));
        new TagListener().handleEvent(null);
        return this.tagWoechentlich;
    }

    private void handleStore() throws ApplicationException {
        try {
            Turnus t = this.getTurnus();
            if (t.isInitial()) {
                throw new ApplicationException(i18n.tr("Turnus ist Bestandteil der System-Daten und kann nicht ge\u00e4ndert werden."));
            }
            Zeiteinheit zh = (Zeiteinheit)this.getZeiteinheit().getValue();
            t.setZeiteinheit(zh.id);
            if (zh.id == 1) {
                Tag tag = (Tag)this.getTagWoechentlich().getValue();
                t.setTag(tag.id);
            } else {
                String s = (String)this.getTagMonatlich().getValue();
                if (this.lastOfMonth.equals(s)) {
                    t.setTag(HBCIProperties.HBCI_LAST_OF_MONTH);
                } else if (this.pleaseChoose.equals(s)) {
                    t.setTag(1);
                } else {
                    t.setTag(Integer.parseInt(s));
                }
            }
            t.setIntervall(Integer.parseInt((String)this.getIntervall().getValue()));
            t.store();
        }
        catch (RemoteException re) {
            Logger.error((String)"error while storing turnus", (Throwable)re);
            throw new ApplicationException(re.getMessage());
        }
    }

    private class Tag
    implements GenericObject {
        private int id = -1;
        private String name;

        private Tag(int id) {
            this.name = TurnusEditDialog.this.pleaseChoose;
            this.id = id;
            if (this.id > 0) {
                this.name = TurnusHelper.getWochentag(id);
            }
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return this.name;
        }

        public String getID() throws RemoteException {
            return "" + this.id;
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "foo";
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            if (arg0 == null) {
                return false;
            }
            return this.getID().equals(arg0.getID());
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"foo"};
        }
    }

    private class TagListener
    implements Listener {
        private TagListener() {
        }

        public void handleEvent(Event event) {
            try {
                Zeiteinheit zh = (Zeiteinheit)TurnusEditDialog.this.getZeiteinheit().getValue();
                if (zh == null) {
                    return;
                }
                if (zh.id == 2) {
                    TurnusEditDialog.this.getTagMonatlich().enable();
                    TurnusEditDialog.this.getTagWoechentlich().disable();
                    TurnusEditDialog.this.getTagWoechentlich().setPreselected((Object)new Tag(-1));
                    TurnusEditDialog.this.getIntervall().setComment(i18n.tr("Monate"));
                } else {
                    TurnusEditDialog.this.getTagMonatlich().disable();
                    TurnusEditDialog.this.getTagMonatlich().setPreselected((Object)TurnusEditDialog.this.pleaseChoose);
                    TurnusEditDialog.this.getTagWoechentlich().enable();
                    TurnusEditDialog.this.getIntervall().setComment(i18n.tr("Wochen"));
                }
            }
            catch (Exception e) {
                Logger.error((String)"error while reading zeiteinheit", (Throwable)e);
            }
        }
    }

    private class Zeiteinheit
    implements GenericObject {
        private int id = -1;
        private String name;

        private Zeiteinheit(int id) {
            this.name = TurnusEditDialog.this.pleaseChoose;
            this.id = id;
            if (this.id == 2) {
                this.name = i18n.tr("monatlich");
            } else if (this.id == 1) {
                this.name = i18n.tr("w\u00f6chentlich");
            }
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return this.name;
        }

        public String getID() throws RemoteException {
            return "" + this.id;
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "foo";
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            if (arg0 == null) {
                return false;
            }
            return this.getID().equals(arg0.getID());
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"foo"};
        }
    }
}

