/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.UmsatzTypBean;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class UmsatzTypListDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(UmsatzTypListDialog.class);
    private static final int WINDOW_WIDTH = 370;
    private static final int WINDOW_HEIGHT = 500;
    private List<UmsatzTypBean> list = null;
    private UmsatzTyp choosen = null;
    private int typ = 2;
    private TextInput search = null;
    private CheckboxInput children = null;
    private TablePart table = null;
    private Button apply = null;

    public UmsatzTypListDialog(int position, UmsatzTyp preselected, int typ) throws RemoteException {
        super(position);
        this.choosen = preselected;
        this.typ = typ;
        this.list = UmsatzTypUtil.getList(null, this.typ);
        this.setTitle(i18n.tr("Auswahl der Kategorie"));
        this.setSize(settings.getInt("window.width", 370), settings.getInt("window.height", 500));
    }

    protected Object getData() throws Exception {
        return this.choosen;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent, true);
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie die zu verwendende Kategorie aus."), true);
        TextInput text = this.getSearch();
        group.addInput((Input)text);
        group.addPart((Part)this.getTable());
        group.addInput((Input)this.getChildren());
        if (this.choosen != null) {
            this.getTable().select((Object)new UmsatzTypBean(this.choosen));
        }
        text.getControl().addKeyListener((KeyListener)new DelayedAdapter());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.getApplyButton());
        buttons.addButton(i18n.tr("K&eine Kategorie"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                UmsatzTypListDialog.this.choosen = null;
                UmsatzTypListDialog.this.close();
            }
        }, null, false, "list-remove.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(buttons);
        this.getShell().setMinimumSize(370, 500);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell shell = UmsatzTypListDialog.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                Point size = shell.getSize();
                Logger.debug((String)("saving window size: " + size.x + "x" + size.y));
                settings.setAttribute("window.width", size.x);
                settings.setAttribute("window.height", size.y);
            }
        });
    }

    private CheckboxInput getChildren() {
        if (this.children != null) {
            return this.children;
        }
        this.children = new CheckboxInput(settings.getBoolean("search.children", true));
        this.children.setName(i18n.tr("Unterkategorien von Treffern anzeigen"));
        this.children.addListener(e -> {
            settings.setAttribute("search.children", ((Boolean)this.children.getValue()).booleanValue());
            this.update();
        });
        return this.children;
    }

    private Button getApplyButton() {
        if (this.apply != null) {
            return this.apply;
        }
        this.apply = new Button(i18n.tr("\u00dcbernehmen"), (Action)new Apply(), null, true, "ok.png");
        this.apply.setEnabled(false);
        return this.apply;
    }

    private TextInput getSearch() {
        if (this.search != null) {
            return this.search;
        }
        this.search = new TextInput("");
        this.search.focus();
        this.search.setName(i18n.tr("Suchbegriff"));
        return this.search;
    }

    private TablePart getTable() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new TablePart(this.list, (Action)new Apply());
        this.table.setSummary(false);
        this.table.setRememberColWidths(true);
        this.table.addColumn(i18n.tr("Bezeichnung"), "indented");
        this.table.addColumn(i18n.tr("Kommentar"), "kommentar");
        this.table.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                if (item == null) {
                    return;
                }
                try {
                    int t;
                    UmsatzTypBean parent;
                    UmsatzTypBean b = (UmsatzTypBean)item.getData();
                    if (b == null) {
                        return;
                    }
                    UmsatzTyp ut = b.getTyp();
                    if (ut == null) {
                        return;
                    }
                    String q = (String)UmsatzTypListDialog.this.getSearch().getValue();
                    if (StringUtils.trimToNull((String)q) != null && (parent = b.getParent()) != null && !UmsatzTypListDialog.this.table.getItems().contains(parent)) {
                        item.setText(0, b.getPathName());
                    }
                    Color c = null;
                    c = ut.isCustomColor() ? ColorUtil.getColor(ut) : ((t = ut.getTyp()) == 0 ? Settings.getBuchungSollForeground() : (t == 1 ? Settings.getBuchungHabenForeground() : de.willuhn.jameica.gui.util.Color.FOREGROUND.getSWTColor()));
                    if (c != null) {
                        item.setForeground(c);
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to apply custom color", (Throwable)e);
                }
            }
        });
        this.table.addSelectionListener(e -> this.getApplyButton().setEnabled(e.data != null));
        this.getApplyButton().setEnabled(this.choosen != null);
        return this.table;
    }

    private void update() {
        TablePart table = this.getTable();
        table.removeAll();
        boolean children = (Boolean)this.getChildren().getValue();
        String text = (String)this.getSearch().getValue();
        text = text.trim().toLowerCase();
        try {
            HashSet<String> lookup = children ? new HashSet<String>() : null;
            for (UmsatzTypBean t : this.list) {
                if (text.length() == 0) {
                    table.addItem((Object)t);
                    continue;
                }
                if (!t.getTyp().getName().toLowerCase().contains(text)) continue;
                this.addItems(t, lookup);
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"error while adding items to table", (Throwable)re);
        }
    }

    private void addItems(UmsatzTypBean b, Set<String> lookup) throws RemoteException {
        if (lookup != null) {
            if (lookup.contains(b.getID())) {
                return;
            }
            lookup.add(b.getID());
        }
        TablePart table = this.getTable();
        table.addItem((Object)b);
        if (lookup == null) {
            return;
        }
        GenericIterator children = b.getChildren();
        while (children.hasNext()) {
            this.addItems((UmsatzTypBean)children.next(), lookup);
        }
    }

    private class Apply
    implements Action {
        private Apply() {
        }

        public void handleAction(Object context) throws ApplicationException {
            UmsatzTypBean b = (UmsatzTypBean)UmsatzTypListDialog.this.getTable().getSelection();
            UmsatzTyp umsatzTyp = UmsatzTypListDialog.this.choosen = b != null ? b.getTyp() : null;
            if (UmsatzTypListDialog.this.choosen != null) {
                UmsatzTypListDialog.this.close();
            }
        }
    }

    private class DelayedAdapter
    extends KeyAdapter {
        private Listener forward = new DelayedListener(150, new Listener(){

            public void handleEvent(Event event) {
                UmsatzTypListDialog.this.update();
            }
        });

        private DelayedAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            this.forward.handleEvent(null);
        }
    }
}

