/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.LabelGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.controller.UmsatzTypControl;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.Composite;

public class UmsatzTypNewDialog
extends AbstractDialog {
    private I18N i18n = null;
    private LabelInput check = null;
    private UmsatzTypControl control = new UmsatzTypControl(null);

    public UmsatzTypNewDialog(int position) {
        super(position);
        this.i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        this.setTitle(this.i18n.tr("Umsatz-Kategorie speichern"));
    }

    protected void paint(Composite parent) throws Exception {
        LabelGroup group = new LabelGroup(parent, this.i18n.tr("Eigenschaften"));
        group.addLabelPair(this.i18n.tr("Bezeichnung"), (Input)this.control.getName());
        group.addLabelPair(this.i18n.tr("Art des Umsatzes"), (Input)this.control.getArt());
        group.addLabelPair("", (Input)this.getCheck());
        ButtonArea buttons = new ButtonArea(parent, 2);
        buttons.addButton(this.i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    String s = (String)UmsatzTypNewDialog.this.control.getName().getValue();
                    if (s == null || s.length() == 0) {
                        UmsatzTypNewDialog.this.getCheck().setValue((Object)UmsatzTypNewDialog.this.i18n.tr("Bitte geben Sie eine Bezeichnung ein."));
                        return;
                    }
                    UmsatzTyp typ = UmsatzTypNewDialog.this.control.getUmsatzTyp();
                    typ.setName(s);
                    UmsatzTypControl.UmsatzTypObject uto = (UmsatzTypControl.UmsatzTypObject)UmsatzTypNewDialog.this.control.getArt().getValue();
                    typ.setTyp(uto.getTyp());
                    UmsatzTypNewDialog.this.close();
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to apply data", (Throwable)e);
                    throw new ApplicationException(UmsatzTypNewDialog.this.i18n.tr("Fehler beim Speichern des Umsatz-Filters"));
                }
            }
        }, null, true);
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        });
    }

    protected Object getData() throws Exception {
        return this.control.getUmsatzTyp();
    }

    private LabelInput getCheck() {
        if (this.check == null) {
            this.check = new LabelInput("");
            this.check.setColor(Color.ERROR);
        }
        return this.check;
    }
}

