/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.parts.ErweiterteVerwendungszwecke;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.Composite;

public class VerwendungszweckDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private ErweiterteVerwendungszwecke ewz = null;
    private String[] lines = null;
    private boolean readOnly = false;

    private VerwendungszweckDialog(int pos) throws RemoteException {
        super(pos);
        this.setTitle(i18n.tr("Weitere Verwendungszwecke"));
    }

    public VerwendungszweckDialog(HibiscusTransfer transfer, int pos) throws RemoteException {
        this(pos);
        this.lines = transfer.getWeitereVerwendungszwecke();
        this.ewz = new ErweiterteVerwendungszwecke(transfer);
        this.readOnly = transfer instanceof Terminable && ((Terminable)((Object)transfer)).ausgefuehrt();
    }

    public VerwendungszweckDialog(SammelTransferBuchung buchung, int pos) throws RemoteException {
        this(pos);
        this.lines = buchung.getWeitereVerwendungszwecke();
        this.ewz = new ErweiterteVerwendungszwecke(buchung);
        SammelTransfer tf = buchung.getSammelTransfer();
        this.readOnly = tf.ausgefuehrt();
    }

    public Object getData() throws Exception {
        return this.lines;
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true, 1);
        this.ewz.paint(container.getComposite());
        ButtonArea buttons = new ButtonArea();
        Button apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    VerwendungszweckDialog.this.lines = VerwendungszweckDialog.this.ewz.getTexts();
                    VerwendungszweckDialog.this.close();
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to apply data", (Throwable)re);
                    throw new ApplicationException(i18n.tr("Fehler beim \u00dcbernehmen der Verwendungszwecke"));
                }
            }
        }, null, true, "ok.png");
        apply.setEnabled(!this.readOnly);
        buttons.addButton(apply);
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
    }
}

