/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.security.Wallet;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.swt.widgets.Composite;

public class WalletDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public WalletDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Inhalt des Wallet"));
        this.setSize(560, 400);
    }

    protected Object getData() throws Exception {
        return null;
    }

    protected void paint(Composite parent) throws Exception {
        Wallet wallet = Settings.getWallet();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Enumeration e = wallet.getKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            entries.add(new Entry(key, wallet.get(key)));
        }
        TablePart table = new TablePart(entries, null);
        table.addColumn(i18n.tr("Name"), "name");
        table.addColumn(i18n.tr("Wert"), "value");
        table.setSummary(false);
        SimpleContainer container = new SimpleContainer(parent);
        container.addText(i18n.tr("Inhalt der Wallet-Datei"), true);
        table.paint(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Schlie\u00dfen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                WalletDialog.this.close();
            }
        }, null, true, "window-close.png");
        buttons.paint(parent);
    }

    public class Entry {
        private String name = null;
        private String value = null;

        private Entry(String name, Serializable s) {
            this.name = name;
            this.value = s != null ? s.toString() : null;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

